/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;

public class StorageTextureManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final StorageTextureManager INSTANCE = new StorageTextureManager();
    private static final String PARENT_TAG = "parent";
    private static final String TYPE_TAG = "type";
    private static final String TEXTURES_TAG = "textures";
    private static final class_4719 defaultChestWoodType = class_4719.field_21679;
    private static final String CHEST_SUFFIX = "_chest";
    private static final Map<String, Supplier<ITextureParser>> TEXTURE_PARSERS = new HashMap<String, Supplier<ITextureParser>>();
    private final Map<class_4719, Map<class_2745, Map<ChestMaterial, class_4730>>> woodChestMaterials = new HashMap<class_4719, Map<class_2745, Map<ChestMaterial, class_4730>>>();

    private StorageTextureManager() {
        super(GSON, "storage_texture_definitions");
    }

    public class_2960 getFabricId() {
        return SophisticatedStorage.getRL("storage_texture_manager");
    }

    protected Map<class_2960, JsonElement> method_20731(class_3300 resourceManager, class_3695 profiler) {
        this.clear();
        Map fileContents = super.method_20731(resourceManager, profiler);
        HashMap<class_2960, StorageTextureDefinition> storageTextureDefinitions = new HashMap<class_2960, StorageTextureDefinition>();
        fileContents.forEach((resourceLocation, json) -> this.loadDefinition((Map<class_2960, StorageTextureDefinition>)storageTextureDefinitions, (class_2960)resourceLocation, (JsonElement)json, fileContents));
        storageTextureDefinitions.forEach((fileName, definition) -> {
            String type = definition.getType();
            String filePath = fileName.method_12832();
            if (type.equals("chest") && filePath.endsWith(CHEST_SUFFIX)) {
                class_4719.method_24026().filter(wt -> wt.comp_1299().equals(filePath.substring(0, filePath.lastIndexOf(CHEST_SUFFIX)))).findFirst().ifPresent(wt -> {
                    EnumMap chestMaterials = new EnumMap(class_2745.class);
                    definition.getTextures().forEach((chestTypeName, textures) -> textures.forEach((textureName, rl) -> ChestMaterial.fromString(textureName).ifPresent(cm -> chestMaterials.computeIfAbsent(class_2745.valueOf((String)chestTypeName.toUpperCase(Locale.ROOT)), t -> new EnumMap(ChestMaterial.class)).put(cm, new class_4730(class_4722.field_21709, rl)))));
                    this.woodChestMaterials.put((class_4719)wt, chestMaterials);
                });
            }
        });
        return fileContents;
    }

    private void clear() {
        this.woodChestMaterials.clear();
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
    }

    @Nullable
    public Map<ChestMaterial, class_4730> getWoodChestMaterials(class_2745 chestType, class_4719 woodType) {
        Map<class_2745, Map<ChestMaterial, class_4730>> chestTypeMaterials = this.woodChestMaterials.getOrDefault(woodType, this.woodChestMaterials.get(defaultChestWoodType));
        return chestTypeMaterials == null ? null : chestTypeMaterials.get(chestType);
    }

    private Optional<StorageTextureDefinition> loadDefinition(Map<class_2960, StorageTextureDefinition> storageTextureDefinitions, class_2960 resourceLocation, JsonElement json, Map<class_2960, JsonElement> fileContents) {
        JsonElement parentJson;
        class_2960 parent;
        if (storageTextureDefinitions.containsKey(resourceLocation)) {
            return Optional.of(storageTextureDefinitions.get(resourceLocation));
        }
        if (!json.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject jsonContents = json.getAsJsonObject();
        String type = "";
        StorageTextureDefinition parentDefinition = null;
        if (jsonContents.has(PARENT_TAG) && jsonContents.get(PARENT_TAG).isJsonPrimitive() && (parentDefinition = (StorageTextureDefinition)this.loadDefinition(storageTextureDefinitions, parent = new class_2960(jsonContents.get(PARENT_TAG).getAsString()), parentJson = fileContents.get(parent), fileContents).orElse(null)) != null) {
            type = parentDefinition.getType();
        }
        if (jsonContents.has(TYPE_TAG) && jsonContents.get(TYPE_TAG).isJsonPrimitive()) {
            type = jsonContents.get(TYPE_TAG).getAsString();
        }
        if (!TEXTURE_PARSERS.containsKey(type)) {
            return Optional.empty();
        }
        ITextureParser textureParser = TEXTURE_PARSERS.get(type).get();
        if (parentDefinition != null) {
            textureParser.copyFromParentDefinition(parentDefinition);
        }
        Optional<StorageTextureDefinition> result = textureParser.parseDefinition(type, jsonContents);
        result.ifPresent(def -> storageTextureDefinitions.put(resourceLocation, (StorageTextureDefinition)def));
        return result;
    }

    static {
        TEXTURE_PARSERS.put("chest", ChestTextureParser::new);
    }

    public static class StorageTextureDefinition {
        private static final String ALL_SIDES_TEXTURES = "allSides";
        private final String type;
        private final Map<String, Map<String, Map<String, class_2960>>> textures;

        public StorageTextureDefinition(String type, Map<String, Map<String, Map<String, class_2960>>> multiplePartTextures, boolean multipleTextureIgnoredParameter) {
            this.type = type;
            this.textures = multiplePartTextures;
        }

        public StorageTextureDefinition(String type, Map<String, Map<String, class_2960>> textures) {
            this.type = type;
            this.textures = new HashMap<String, Map<String, Map<String, class_2960>>>();
            this.textures.put(ALL_SIDES_TEXTURES, textures);
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Map<String, class_2960>> getTextures() {
            return this.textures.getOrDefault(ALL_SIDES_TEXTURES, new HashMap());
        }
    }

    private static interface ITextureParser {
        public void copyFromParentDefinition(StorageTextureDefinition var1);

        public Optional<StorageTextureDefinition> parseDefinition(String var1, JsonObject var2);
    }

    public static enum ChestMaterial {
        BASE,
        WOOD_TIER,
        COPPER_TIER,
        IRON_TIER,
        GOLD_TIER,
        DIAMOND_TIER,
        NETHERITE_TIER,
        TINTABLE_MAIN,
        TINTABLE_ACCENT,
        PACKED;


        public static Optional<ChestMaterial> fromString(String materialName) {
            for (ChestMaterial value : ChestMaterial.values()) {
                if (!value.name().toLowerCase(Locale.ROOT).equals(materialName)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    private static class ChestTextureParser
    implements ITextureParser {
        private final Map<String, Map<String, class_2960>> textures = new HashMap<String, Map<String, class_2960>>();

        private ChestTextureParser() {
        }

        @Override
        public void copyFromParentDefinition(StorageTextureDefinition parentDefinition) {
            parentDefinition.getTextures().forEach((key, value) -> this.textures.put((String)key, new HashMap(value)));
        }

        @Override
        public Optional<StorageTextureDefinition> parseDefinition(String type, JsonObject jsonContents) {
            if (jsonContents.has(StorageTextureManager.TEXTURES_TAG) && jsonContents.get(StorageTextureManager.TEXTURES_TAG).isJsonObject()) {
                JsonObject jsonTextures = jsonContents.get(StorageTextureManager.TEXTURES_TAG).getAsJsonObject();
                jsonTextures.keySet().forEach(name -> jsonTextures.get(name).getAsJsonObject().entrySet().forEach(entry -> {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        this.textures.computeIfAbsent((String)name, k -> new HashMap()).put((String)entry.getKey(), new class_2960(((JsonElement)entry.getValue()).getAsString()));
                    }
                }));
            }
            return Optional.of(new StorageTextureDefinition(type, this.textures));
        }
    }
}

