/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.CompositeElementsModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import net.p3pp3rf1y.sophisticatedstorage.mixin.client.accessor.BlockModelAccessor;
import org.joml.Quaternionf;

public abstract class BarrelDynamicModelBase<T extends BarrelDynamicModelBase<T>>
implements IUnbakedGeometry<T> {
    private static final Map<Integer, class_1087> BAKED_PART_MODELS = new HashMap<Integer, class_1087>();
    private static final String REFERENCE_PREFIX = "reference/";
    private final Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartDefinitions;
    @Nullable
    private final class_2960 parentLocation;
    @Nullable
    private BarrelDynamicModelBase<?> parent;
    @Nullable
    private final class_2960 flatTopModelName;
    private final Map<DynamicBarrelBakingData.DynamicPart, class_2960> dynamicPartModels;
    private final Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions;

    public static void invalidateCache() {
        BAKED_PART_MODELS.clear();
    }

    protected BarrelDynamicModelBase(@Nullable class_2960 parentLocation, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartDefinitions, @Nullable class_2960 flatTopModelName, Map<DynamicBarrelBakingData.DynamicPart, class_2960> dynamicPartModels, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions) {
        this.parentLocation = parentLocation;
        this.woodModelPartDefinitions = woodModelPartDefinitions;
        this.flatTopModelName = flatTopModelName;
        this.dynamicPartModels = dynamicPartModels;
        this.woodPartitionedModelPartDefinitions = woodPartitionedModelPartDefinitions;
    }

    public class_1087 bake(class_793 context, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        Map<String, Map<BarrelModelPart, class_1087>> woodModelParts = this.bakeWoodModelParts(baker, spriteGetter, modelState, modelLocation, this.woodModelPartDefinitions);
        Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData = this.getDynamicBakingData(modelState, modelLocation);
        this.copyAndResolveTextures(this.woodModelPartDefinitions, this.woodPartitionedModelPartDefinitions);
        Map<String, Map<BarrelModelPart, class_1087>> woodPartitionedModelParts = this.bakeWoodModelParts(baker, spriteGetter, modelState, modelLocation, this.woodPartitionedModelPartDefinitions);
        class_1087 flatTopModel = this.getFlatTopModelName().map(modelName -> baker.method_45872(modelName).method_4753(baker, spriteGetter, modelState, modelLocation)).orElse(null);
        return this.instantiateBakedModel(baker, spriteGetter, woodModelParts, flatTopModel, woodDynamicBakingData, woodPartitionedModelParts);
    }

    private void copyAndResolveTextures(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        BarrelDynamicModelBase.copyTextures(woodOverrides, partitionedWoodOverrides);
        BarrelDynamicModelBase.resolveTextureReferences(partitionedWoodOverrides);
    }

    private static void resolveTextureReferences(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        partitionedWoodOverrides.values().forEach(partDefinitions -> partDefinitions.values().forEach(definition -> {
            HashMap replacements = new HashMap();
            definition.textures.forEach((key, value) -> {
                String path = value.method_24147().method_12832();
                if (value.method_24147().method_12836().equals("minecraft") && path.startsWith(REFERENCE_PREFIX)) {
                    String referredTextureName = path.substring(REFERENCE_PREFIX.length());
                    if (definition.textures().containsKey(referredTextureName)) {
                        replacements.put(key, definition.textures.get(referredTextureName));
                    }
                }
            });
            definition.textures.putAll(replacements);
        }));
    }

    private static void copyTextures(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> partitionedWoodOverrides) {
        woodOverrides.forEach((woodType, partDefinitions) -> {
            if (partitionedWoodOverrides.containsKey(woodType)) {
                Map partitionedWoodOverride = (Map)partitionedWoodOverrides.get(woodType);
                partDefinitions.forEach((part, definition) -> {
                    if (partitionedWoodOverride.containsKey(part)) {
                        ((BarrelModelPartDefinition)partitionedWoodOverride.get((Object)((Object)((Object)((Object)part))))).textures.putAll(definition.textures);
                    } else {
                        partitionedWoodOverride.put(part, new BarrelModelPartDefinition(null, new HashMap<String, class_4730>(definition.textures())));
                    }
                });
            }
        });
    }

    private Map<String, Map<BarrelModelPart, class_1100>> createUnbakedWoodModelParts(Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> definitions) {
        ImmutableMap.Builder woodModelsBuilder = ImmutableMap.builder();
        definitions.forEach((woodName, woodDefinitions) -> {
            ImmutableMap.Builder modelsBuilder = ImmutableMap.builder();
            woodDefinitions.forEach((barrelPart, barrelPartDefinition) -> barrelPartDefinition.modelLocation().ifPresent(partModelLocation -> {
                HashMap<String, Either<class_4730, String>> materials = new HashMap<String, Either<class_4730, String>>();
                barrelPartDefinition.textures().forEach((textureName, texture) -> materials.put((String)textureName, (Either<class_4730, String>)Either.left((Object)texture)));
                modelsBuilder.put((Object)barrelPart, (Object)new CompositeElementsModel((class_2960)partModelLocation, (Map<String, Either<class_4730, String>>)materials));
            }));
            woodModelsBuilder.put(woodName, (Object)modelsBuilder.build());
        });
        return woodModelsBuilder.build();
    }

    private Map<String, Map<BarrelModelPart, class_1087>> bakeWoodModelParts(class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> definitions) {
        Map<String, Map<BarrelModelPart, class_1100>> woodModels = this.createUnbakedWoodModelParts(definitions);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        woodModels.forEach((woodName, partModels) -> {
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            partModels.forEach((part, model) -> {
                model.method_45785(arg_0 -> ((class_7775)baker).method_45872(arg_0));
                int hash = this.getBakedModelHash((class_1100)model, modelTransform, (BarrelModelPart)((Object)((Object)part)));
                class_1087 bakedModel = BAKED_PART_MODELS.computeIfAbsent(hash, h -> model.method_4753(baker, spriteGetter, modelTransform, modelLocation));
                if (bakedModel != null) {
                    partBuilder.put((Object)part, (Object)bakedModel);
                }
            });
            builder.put(woodName, (Object)partBuilder.build());
        });
        return builder.build();
    }

    private Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> getDynamicBakingData(class_3665 modelTransform, class_2960 modelLocation) {
        HashMap<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData = new HashMap<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>>();
        this.woodModelPartDefinitions.forEach((woodName, partDefinitions) -> {
            EnumMap dynamicPartBakingData = new EnumMap(DynamicBarrelBakingData.DynamicPart.class);
            this.dynamicPartModels.forEach((dynamicPart, dynamicPartModel) -> dynamicPartBakingData.put((DynamicBarrelBakingData.DynamicPart)((Object)((Object)dynamicPart)), new DynamicBarrelBakingData(new BarrelModelPartDefinition((class_2960)dynamicPartModel, ((BarrelModelPartDefinition)partDefinitions.get((Object)BarrelModelPart.BASE)).textures()), modelTransform, modelLocation)));
            woodDynamicBakingData.put((String)woodName, dynamicPartBakingData);
        });
        return woodDynamicBakingData;
    }

    private Optional<class_2960> getFlatTopModelName() {
        BarrelDynamicModelBase<?> model = this;
        while (model != null) {
            if (model.flatTopModelName != null) {
                return Optional.of(model.flatTopModelName);
            }
            model = model.parent;
        }
        return Optional.empty();
    }

    private int getBakedModelHash(class_1100 model, class_3665 modelTransform, BarrelModelPart part) {
        int hash = part.hashCode();
        for (Object dependency : model.method_4755()) {
            hash = 31 * hash + dependency.hashCode();
        }
        if (model instanceof class_793) {
            class_793 blockModel = (class_793)model;
            for (Either either : ((BlockModelAccessor)blockModel).getTextureMap().values()) {
                Optional mat = either.left();
                if (!mat.isPresent()) continue;
                hash = 31 * hash + ((class_4730)mat.get()).hashCode();
            }
        }
        if (model instanceof CompositeElementsModel) {
            CompositeElementsModel compositeElementsModel = (CompositeElementsModel)model;
            for (Map.Entry entry : ((BlockModelAccessor)((Object)compositeElementsModel)).getTextureMap().entrySet()) {
                hash = 31 * hash + ((String)entry.getKey()).hashCode();
                hash = 31 * hash + ((Either)entry.getValue()).hashCode();
            }
        }
        hash = 31 * hash + Boolean.valueOf(modelTransform.method_3512()).hashCode();
        class_4590 rotation = modelTransform.method_3509();
        hash = 31 * hash + rotation.method_22936().hashCode();
        hash = 31 * hash + rotation.method_35865().hashCode();
        Quaternionf leftRotation = rotation.method_22937();
        hash = 31 * hash + leftRotation.hashCode();
        hash = 31 * hash + Objects.hash(Float.valueOf(leftRotation.x()), Float.valueOf(leftRotation.y()), Float.valueOf(leftRotation.z()));
        hash = 31 * hash + rotation.method_35866().hashCode();
        return hash;
    }

    protected abstract BarrelBakedModelBase instantiateBakedModel(class_7775 var1, Function<class_4730, class_1058> var2, Map<String, Map<BarrelModelPart, class_1087>> var3, @Nullable class_1087 var4, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> var5, Map<String, Map<BarrelModelPart, class_1087>> var6);

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 context) {
        this.visitAndUpdateParents(modelGetter);
        this.updatePartDefinitionsFromParents();
        this.updatePartitionedPartDefinitionsFromParents();
        this.updateDynamicPartModelsFromParents();
    }

    private void updateDynamicPartModelsFromParents() {
        BarrelDynamicModelBase<?> model = this.parent;
        while (model != null) {
            this.updateDynamicPartModelsFromModel(model);
            model = model.parent;
        }
    }

    private void updateDynamicPartModelsFromModel(BarrelDynamicModelBase<?> model) {
        model.dynamicPartModels.forEach((dynamicPart, dynamicPartModel) -> {
            if (!this.dynamicPartModels.containsKey(dynamicPart)) {
                this.dynamicPartModels.put((DynamicBarrelBakingData.DynamicPart)((Object)dynamicPart), (class_2960)dynamicPartModel);
            }
        });
    }

    private void updatePartDefinitionsFromParents() {
        BarrelDynamicModelBase<?> model = this.parent;
        while (model != null) {
            this.updateWoodModelPartDefinitionsFromModel(model);
            model = model.parent;
        }
    }

    private void updatePartitionedPartDefinitionsFromParents() {
        BarrelDynamicModelBase<?> model = this.parent;
        while (model != null) {
            this.updateWoodPartitionedModelPartDefinitionsFromModel(model);
            model = model.parent;
        }
    }

    private void updateWoodModelPartDefinitionsFromModel(BarrelDynamicModelBase<?> model) {
        model.woodModelPartDefinitions.forEach((woodType, parentModelDefinitions) -> {
            if (!this.woodModelPartDefinitions.containsKey(woodType)) {
                this.woodModelPartDefinitions.put((String)woodType, parentModelDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BarrelModelPartDefinition)e.getValue()).copy())));
            } else {
                parentModelDefinitions.forEach((part, definition) -> {
                    if (!this.woodModelPartDefinitions.get(woodType).containsKey(part)) {
                        this.woodModelPartDefinitions.get(woodType).put((BarrelModelPart)((Object)((Object)part)), definition.copy());
                    } else {
                        this.woodModelPartDefinitions.get(woodType).get(part).mergeMissing((BarrelModelPartDefinition)definition);
                    }
                });
            }
        });
    }

    private void updateWoodPartitionedModelPartDefinitionsFromModel(BarrelDynamicModelBase<?> model) {
        model.woodPartitionedModelPartDefinitions.forEach((woodType, parentModelDefinitions) -> {
            if (!this.woodPartitionedModelPartDefinitions.containsKey(woodType)) {
                this.woodPartitionedModelPartDefinitions.put((String)woodType, parentModelDefinitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BarrelModelPartDefinition)e.getValue()).copy())));
            } else {
                parentModelDefinitions.forEach((part, definition) -> {
                    if (!this.woodPartitionedModelPartDefinitions.get(woodType).containsKey(part)) {
                        this.woodPartitionedModelPartDefinitions.get(woodType).put((BarrelModelPart)((Object)((Object)part)), definition.copy());
                    } else {
                        this.woodPartitionedModelPartDefinitions.get(woodType).get(part).mergeMissing((BarrelModelPartDefinition)definition);
                    }
                });
            }
        });
    }

    private void visitAndUpdateParents(Function<class_2960, class_1100> modelGetter) {
        LinkedHashSet visitedModels = Sets.newLinkedHashSet();
        BarrelDynamicModelBase<?> currentModel = this;
        while (currentModel.parentLocation != null && currentModel.parent == null) {
            visitedModels.add(currentModel);
            if (!this.updateModelParent(modelGetter, visitedModels, currentModel)) break;
            currentModel = currentModel.parent;
        }
    }

    private boolean updateModelParent(Function<class_2960, class_1100> modelGetter, Set<BarrelDynamicModelBase<?>> visitedModels, BarrelDynamicModelBase<?> currentModel) {
        class_1100 class_11002 = modelGetter.apply(currentModel.parentLocation);
        if (!(class_11002 instanceof class_793)) {
            SophisticatedStorage.LOGGER.warn("Parent '{}' doesn't hold a block model while loading '{}'", (Object)currentModel.parentLocation, currentModel);
            return false;
        }
        class_793 parentBlockModel = (class_793)class_11002;
        IUnbakedGeometry iUnbakedGeometry = parentBlockModel.getCustomGeometry();
        if (!(iUnbakedGeometry instanceof BarrelDynamicModelBase)) {
            SophisticatedStorage.LOGGER.warn("Parent '{}' doesn't hold a barrel model of 'BarrelDynamicModelBase' while loading '{}'", (Object)parentBlockModel, currentModel);
            return false;
        }
        BarrelDynamicModelBase parentModel = (BarrelDynamicModelBase)iUnbakedGeometry;
        if (visitedModels.contains(parentModel)) {
            SophisticatedStorage.LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{currentModel, visitedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), currentModel.parentLocation});
            return false;
        }
        currentModel.parent = parentModel;
        return true;
    }

    public static final class BarrelModelPartDefinition {
        @Nullable
        private class_2960 modelLocation;
        private final Map<String, class_4730> textures;

        private BarrelModelPartDefinition(@Nullable class_2960 modelLocation, Map<String, class_4730> textures) {
            this.modelLocation = modelLocation;
            this.textures = textures;
        }

        public BarrelModelPartDefinition copy() {
            return new BarrelModelPartDefinition(this.modelLocation, new HashMap<String, class_4730>(this.textures));
        }

        public void mergeMissing(BarrelModelPartDefinition other) {
            if (other.modelLocation != null && this.modelLocation == null) {
                this.modelLocation = other.modelLocation;
            }
            other.textures.forEach((key, value) -> {
                if (!this.textures.containsKey(key)) {
                    this.textures.put((String)key, (class_4730)value);
                }
            });
        }

        public static BarrelModelPartDefinition deserialize(JsonObject json) {
            class_2960 modelLocation = null;
            if (json.has("model")) {
                modelLocation = new class_2960(json.get("model").getAsString());
            }
            HashMap<String, class_4730> textures = new HashMap<String, class_4730>();
            if (json.has("textures")) {
                JsonObject texturesJson = json.getAsJsonObject("textures");
                for (Map.Entry entry : texturesJson.entrySet()) {
                    Object textureName = ((JsonElement)entry.getValue()).getAsString();
                    if (((String)textureName).startsWith("#")) {
                        textureName = BarrelDynamicModelBase.REFERENCE_PREFIX + ((String)textureName).substring(1);
                    }
                    textures.put((String)entry.getKey(), new class_4730(class_1723.field_21668, new class_2960((String)textureName)));
                }
            }
            return new BarrelModelPartDefinition(modelLocation, textures);
        }

        public Optional<class_2960> modelLocation() {
            return Optional.ofNullable(this.modelLocation);
        }

        public Map<String, class_4730> textures() {
            return this.textures;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            BarrelModelPartDefinition that = (BarrelModelPartDefinition)obj;
            return Objects.equals(this.modelLocation, that.modelLocation) && Objects.equals(this.textures, that.textures);
        }

        public int hashCode() {
            return Objects.hash(this.modelLocation, this.textures);
        }

        public String toString() {
            return "BarrelModelPartDefinition[modelLocation=" + this.modelLocation + ", textures=" + this.textures + "]";
        }
    }

    public static abstract class Loader<T extends BarrelDynamicModelBase<T>>
    implements IGeometryLoader<T> {
        public T read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            class_2960 parentLocation = null;
            if (modelContents.has("parent")) {
                parentLocation = new class_2960(modelContents.get("parent").getAsString());
            }
            Map<BarrelModelPart, BarrelModelPartDefinition> modelParts = Loader.readModelParts(modelContents, "model_parts");
            Map<BarrelModelPart, BarrelModelPartDefinition> partitionedModelParts = Loader.readModelParts(modelContents, "partitioned_model_parts");
            Map<DynamicBarrelBakingData.DynamicPart, class_2960> dynamicPartModels = Loader.readDynamicPartModels(modelContents);
            Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides = Loader.readWoodOverrides(modelContents);
            if (parentLocation == null && modelParts.isEmpty() && woodOverrides.isEmpty() && dynamicPartModels.isEmpty()) {
                SophisticatedStorage.LOGGER.warn("None of 'parent', 'model_parts' and 'wood_overrides' present in model definition");
            }
            this.mergeModelPartDefinitionsIntoWoodOnes(modelParts, woodOverrides);
            Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions = Loader.readWoodOverrides(modelContents, Set.of(BarrelModelPart.BASE, BarrelModelPart.BASE_OPEN));
            this.mergeModelPartDefinitionsIntoWoodOnes(partitionedModelParts, woodPartitionedModelPartDefinitions);
            class_2960 flatTopModelName = Loader.readFlatTopModel(modelContents);
            return this.instantiateModel(parentLocation, woodOverrides, flatTopModelName, dynamicPartModels, woodPartitionedModelPartDefinitions);
        }

        @Nullable
        private static class_2960 readFlatTopModel(JsonObject modelContents) {
            class_2960 flatTopModelName = null;
            if (modelContents.has("flat_top_model")) {
                flatTopModelName = new class_2960(modelContents.get("flat_top_model").getAsString());
            }
            return flatTopModelName;
        }

        private static Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> readWoodOverrides(JsonObject modelContents) {
            return Loader.readWoodOverrides(modelContents, Collections.emptySet());
        }

        private static Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> readWoodOverrides(JsonObject modelContents, Set<BarrelModelPart> partsToIgnore) {
            HashMap<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodOverrides = new HashMap<String, Map<BarrelModelPart, BarrelModelPartDefinition>>();
            if (modelContents.has("wood_overrides")) {
                JsonObject woodOverridesJson = modelContents.getAsJsonObject("wood_overrides");
                for (Map.Entry entry : woodOverridesJson.entrySet()) {
                    JsonObject woodOverrideJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    EnumMap woodOverride = new EnumMap(BarrelModelPart.class);
                    for (Map.Entry woodModelParts : woodOverrideJson.entrySet()) {
                        JsonObject modelPartJson = ((JsonElement)woodModelParts.getValue()).getAsJsonObject();
                        BarrelModelPart.getByNameOptional((String)woodModelParts.getKey()).ifPresent(part -> {
                            if (partsToIgnore.contains(part)) {
                                return;
                            }
                            woodOverride.put((BarrelModelPart)((Object)part), BarrelModelPartDefinition.deserialize(modelPartJson));
                        });
                    }
                    woodOverrides.put((String)entry.getKey(), woodOverride);
                }
            }
            return woodOverrides;
        }

        private static Map<DynamicBarrelBakingData.DynamicPart, class_2960> readDynamicPartModels(JsonObject modelContents) {
            EnumMap<DynamicBarrelBakingData.DynamicPart, class_2960> dynamicPartModels = new EnumMap<DynamicBarrelBakingData.DynamicPart, class_2960>(DynamicBarrelBakingData.DynamicPart.class);
            if (modelContents.has("dynamic_part_models")) {
                JsonObject dynamicPartsJson = modelContents.getAsJsonObject("dynamic_part_models");
                for (Map.Entry entry : dynamicPartsJson.entrySet()) {
                    DynamicBarrelBakingData.DynamicPart.getByNameOptional((String)entry.getKey()).ifPresent(part -> dynamicPartModels.put((DynamicBarrelBakingData.DynamicPart)((Object)part), new class_2960(((JsonElement)entry.getValue()).getAsString())));
                }
            }
            return dynamicPartModels;
        }

        private static Map<BarrelModelPart, BarrelModelPartDefinition> readModelParts(JsonObject modelContents, String memberName) {
            EnumMap<BarrelModelPart, BarrelModelPartDefinition> modelParts = new EnumMap<BarrelModelPart, BarrelModelPartDefinition>(BarrelModelPart.class);
            if (modelContents.has(memberName)) {
                JsonObject modelPartsJson = modelContents.getAsJsonObject(memberName);
                for (Map.Entry entry : modelPartsJson.entrySet()) {
                    JsonObject modelPartJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    BarrelModelPart.getByNameOptional((String)entry.getKey()).ifPresent(part -> modelParts.put((BarrelModelPart)((Object)part), BarrelModelPartDefinition.deserialize(modelPartJson)));
                }
            }
            return modelParts;
        }

        private void mergeModelPartDefinitionsIntoWoodOnes(Map<BarrelModelPart, BarrelModelPartDefinition> modelPartDefinitions, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> woodModelPartdefinitions) {
            for (BarrelModelPart part : BarrelModelPart.values()) {
                if (!modelPartDefinitions.containsKey((Object)part)) continue;
                WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> {
                    String woodName = woodType.comp_1299().toLowerCase(Locale.ROOT);
                    if (woodModelPartdefinitions.containsKey(woodName)) {
                        Map definitions = (Map)woodModelPartdefinitions.get(woodName);
                        if (definitions.containsKey((Object)part)) {
                            ((BarrelModelPartDefinition)definitions.get((Object)part)).mergeMissing((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part));
                        } else {
                            definitions.put(part, ((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part)).copy());
                        }
                    } else {
                        woodModelPartdefinitions.put(woodName, new EnumMap<BarrelModelPart, BarrelModelPartDefinition>(Map.of(part, ((BarrelModelPartDefinition)modelPartDefinitions.get((Object)part)).copy())));
                    }
                });
            }
        }

        protected abstract T instantiateModel(@Nullable class_2960 var1, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> var2, @Nullable class_2960 var3, Map<DynamicBarrelBakingData.DynamicPart, class_2960> var4, Map<String, Map<BarrelModelPart, BarrelModelPartDefinition>> var5);
    }
}

