/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_777;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.TranslucentVertexConsumer;

public class BarrelRenderer<T extends BarrelBlockEntity>
extends StorageRenderer<T> {
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new class_243(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, class_243.field_1353);

    public void render(T blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_2248 class_22482;
        class_2680 blockState = blockEntity.method_11010();
        boolean flatTop = Boolean.TRUE.equals(blockState.method_11654((class_2769)BarrelBlock.FLAT_TOP));
        if (((WoodStorageBlockEntity)blockEntity).isPacked() || !((class_22482 = blockState.method_26204()) instanceof BarrelBlock)) {
            return;
        }
        BarrelBlock storageBlock = (BarrelBlock)class_22482;
        packedLight = class_761.method_23794((class_1920)blockEntity.method_10997(), (class_2338)blockEntity.method_11016().method_10093(storageBlock.getFacing(blockState)));
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop, blockState);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(T blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean flatTop, class_2680 blockState) {
        if (!(((BarrelBlockEntity)blockEntity).hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || ((StorageBlockEntity)blockEntity).shouldShowUpgrades())) {
            return;
        }
        poseStack.method_22903();
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)BarrelBlock.FACING);
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(facing));
        poseStack.method_22904(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
        boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
        if (((StorageBlockEntity)blockEntity).shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
            if (flatTop) {
                this.flatDisplayItemRenderer.renderUpgradeItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
            } else {
                this.displayItemRenderer.renderUpgradeItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(blockEntity));
            }
        }
        if (((BarrelBlockEntity)blockEntity).hasDynamicRenderer()) {
            if (flatTop) {
                this.flatDisplayItemRenderer.renderDisplayItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !((BarrelBlockEntity)blockEntity).hasFullyDynamicRenderer());
            } else {
                this.displayItemRenderer.renderDisplayItems((StorageBlockEntity)blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !((BarrelBlockEntity)blockEntity).hasFullyDynamicRenderer());
            }
        }
        poseStack.method_22909();
    }

    public int method_33893() {
        return 32;
    }

    protected void renderHiddenTier(T blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (!((StorageBlockEntity)blockEntity).shouldShowTier() && this.holdsItemThatShowsHiddenTiers()) {
            this.renderTranslucentQuads(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, BarrelBakedModelBase::getTierQuads);
        }
    }

    protected void renderHiddenLock(T blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (!((StorageBlockEntity)blockEntity).shouldShowLock() && ((StorageBlockEntity)blockEntity).isLocked() && this.holdsToolInToggleLockOrLockDisplay()) {
            this.renderTranslucentQuads(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, BarrelBakedModelBase::getLockQuads);
        }
    }

    private void renderTranslucentQuads(T blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, GetQuadsFunction getQuads) {
        String woodName = ((WoodStorageBlockEntity)blockEntity).getWoodType().orElse(class_4719.field_21679).comp_1299();
        class_2680 state = blockEntity.method_11010();
        class_1087 blockModel = class_310.method_1551().method_1541().method_3349(state);
        poseStack.method_22903();
        poseStack.method_22904(-0.005, -0.005, -0.005);
        poseStack.method_22905(1.01f, 1.01f, 1.01f);
        if (blockEntity.method_10997() != null && blockModel instanceof BarrelBakedModelBase) {
            BarrelBakedModelBase barrelBakedModel = (BarrelBakedModelBase)blockModel;
            class_4588 vertexConsumer = TranslucentVertexConsumer.getVertexConsumer(bufferSource, 128);
            getQuads.apply(barrelBakedModel, state, blockEntity.method_10997().field_9229, woodName, class_1921.method_23581()).forEach(quad -> vertexConsumer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay));
        }
        poseStack.method_22909();
    }

    private static interface GetQuadsFunction {
        public List<class_777> apply(BarrelBakedModelBase var1, class_2680 var2, class_5819 var3, String var4, class_1921 var5);
    }
}

