/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsPacket;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class CommonEventHandler {
    private static final int AVERAGE_MAX_ITEM_ENTITY_DROP_COUNT = 20;
    private final Queue<class_3738> pendingTickTasks = Queues.newConcurrentLinkedQueue();

    public void registerHandlers() {
        ServerPlayConnectionEvents.JOIN.register(this::onPlayerLoggedIn);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(this::onPlayerChangedDimension);
        ServerPlayerEvents.AFTER_RESPAWN.register(this::onPlayerRespawn);
        PlayerBlockBreakEvents.BEFORE.register(this::onBlockBreak);
        AttackBlockCallback.EVENT.register(this::onLimitedBarrelLeftClicked);
        UseBlockCallback.EVENT.register(this::onSneakItemBlockInteraction);
        ServerTickEvents.END_SERVER_TICK.register(this::onLevelTick);
    }

    private class_1269 onLimitedBarrelLeftClicked(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (!player.method_7337()) {
            return class_1269.field_5811;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof LimitedBarrelBlock)) {
            return class_1269.field_5811;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)class_22482;
        if (limitedBarrel.tryToTakeItem(state, level, pos, player)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1269 onSneakItemBlockInteraction(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!player.method_5715()) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ISneakItemInteractionBlock)) {
            return class_1269.field_5811;
        }
        ISneakItemInteractionBlock sneakItemInteractionBlock = (ISneakItemInteractionBlock)class_22482;
        if (sneakItemInteractionBlock.trySneakItemInteraction(player, hand, state, level, pos, hitResult, player.method_5998(hand))) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void onPlayerChangedDimension(class_3222 player, class_3218 origin, class_3218 destination) {
        this.sendPlayerSettingsToClient((class_1657)player);
    }

    private void onPlayerLoggedIn(class_3244 handler, PacketSender sender, MinecraftServer server) {
        this.sendPlayerSettingsToClient((class_1657)handler.field_14140);
    }

    private void sendPlayerSettingsToClient(class_1657 player) {
        String playerTagName = "sophisticatedStorageSettings";
        PacketHelper.sendToPlayer((FabricPacket)new SyncPlayerSettingsPacket(playerTagName, SettingsManager.getPlayerSettingsTag((class_1657)player, (String)playerTagName)), (class_1657)player);
    }

    private void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        this.sendPlayerSettingsToClient((class_1657)newPlayer);
    }

    private void onLevelTick(MinecraftServer server) {
        if (this.pendingTickTasks.isEmpty()) {
            return;
        }
        Iterator it = this.pendingTickTasks.iterator();
        while (it.hasNext()) {
            class_3738 tickTask = (class_3738)it.next();
            if (tickTask.method_16338() > server.method_3780()) continue;
            tickTask.run();
            it.remove();
        }
    }

    private boolean onBlockBreak(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (!(state.method_26204() instanceof WoodStorageBlockBase) || player.method_5715()) {
            return true;
        }
        AtomicBoolean cancelEvent = new AtomicBoolean(false);
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
            if (wbe.isPacked() || Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                return;
            }
            AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
            InventoryHelper.iterate((SlottedStorage)wbe.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.method_7960()) {
                    return;
                }
                droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.method_7947() / (double)Math.min(stack.method_7914(), 20)));
            });
            if (droppedItemEntityCount.get() > (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
                cancelEvent.set(true);
                ItemBase packingTapeItem = ModItems.PACKING_TAPE;
                class_5250 packingTapeItemName = packingTapeItem.method_7864(new class_1799((class_1935)packingTapeItem)).method_27661().method_27692(class_124.field_1060);
                class_1799 clonedStack = state.method_26204() instanceof BlockPickInteractionAware ? ((BlockPickInteractionAware)state.method_26204()).getPickedStack(state, (class_1922)level, pos, player, (class_239)new class_3965(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), class_2350.field_11033, pos, true)) : state.method_26204().method_9574((class_4538)level, pos, state);
                player.method_43496(StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{clonedStack.method_7964().method_27661().method_27692(class_124.field_1060), class_2561.method_43470((String)String.valueOf(droppedItemEntityCount)).method_27692(class_124.field_1061), packingTapeItemName}));
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    level.method_39279(pos, state.method_26204(), 2);
                    this.pendingTickTasks.add(new class_3738(serverLevel.method_8503().method_3780() + 2, () -> {
                        wbe.setUpdateBlockRender();
                        WorldHelper.notifyBlockUpdate((class_2586)wbe);
                    }));
                }
            }
        });
        return !cancelEvent.get();
    }
}

