/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SettingsScreen;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiGridMenuInfo;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiSettingsGhostDragDropHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.emi.EmiStorageGhostDragDropHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.common.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class EmiCompat
implements EmiPlugin {
    public static Event<WorkstationCallback> WORKSTATIONS = EventFactory.createArrayBacked(WorkstationCallback.class, listeners -> consumer -> {
        for (WorkstationCallback listener : listeners) {
            listener.additionalWorkstations(consumer);
        }
    });

    public void register(EmiRegistry registry) {
        registry.addExclusionArea(StorageScreen.class, (screen, consumer) -> {
            screen.getUpgradeSlotsRectangle().ifPresent(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
            screen.getUpgradeSettingsControl().getTabRectangles().forEach(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
            screen.getSortButtonsRectangle().ifPresent(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
        });
        registry.addExclusionArea(StorageSettingsScreen.class, (screen, consumer) -> {
            if (screen == null || screen.getSettingsTabControl() == null) {
                return;
            }
            screen.getSettingsTabControl().getTabRectangles().forEach(r -> consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320())));
        });
        registry.addDragDropHandler(StorageScreen.class, (EmiDragDropHandler)new EmiStorageGhostDragDropHandler());
        registry.addDragDropHandler(SettingsScreen.class, (EmiDragDropHandler)new EmiSettingsGhostDragDropHandler());
        EmiCompat.registerCraftingRecipes(registry, DyeRecipesMaker.getRecipes());
        EmiCompat.registerCraftingRecipes(registry, TierUpgradeRecipesMaker.getShapedCraftingRecipes());
        EmiCompat.registerCraftingRecipes(registry, TierUpgradeRecipesMaker.getShapelessCraftingRecipes());
        EmiCompat.registerCraftingRecipes(registry, ShulkerBoxFromChestRecipesMaker.getRecipes());
        EmiCompat.registerCraftingRecipes(registry, FlatBarrelRecipesMaker.getRecipes());
        Comparison woodStorageNbtInterpreter = Comparison.compareData(emiStack -> {
            class_2487 tag = new class_2487();
            class_1799 stack = emiStack.getItemStack();
            WoodStorageBlockItem.getWoodType(stack).ifPresent(woodName -> tag.method_10582("woodName", woodName.comp_1299()));
            StorageBlockItem.getMainColorFromStack(stack).ifPresent(mainColor -> tag.method_10569("mainColor", mainColor.intValue()));
            StorageBlockItem.getAccentColorFromStack(stack).ifPresent(accentColor -> tag.method_10569("accentColor", accentColor.intValue()));
            return tag;
        });
        Comparison barrelNbtInterpreter = Comparison.compareData(emiStack -> {
            class_2487 tag = new class_2487();
            class_1799 stack = emiStack.getItemStack();
            WoodStorageBlockItem.getWoodType(stack).ifPresent(woodName -> tag.method_10582("woodName", woodName.comp_1299()));
            StorageBlockItem.getMainColorFromStack(stack).ifPresent(mainColor -> tag.method_10569("mainColor", mainColor.intValue()));
            StorageBlockItem.getAccentColorFromStack(stack).ifPresent(accentColor -> tag.method_10569("accentColor", accentColor.intValue()));
            tag.method_10556("flatTop", BarrelBlockItem.isFlatTop(stack));
            return tag;
        });
        for (class_1747 item : ModBlocks.ALL_BARREL_ITEMS) {
            registry.setDefaultComparison((Object)item, barrelNbtInterpreter);
        }
        for (class_1747 item : ModBlocks.CHEST_ITEMS) {
            registry.setDefaultComparison((Object)item, woodStorageNbtInterpreter);
        }
        Comparison shulkerBoxNbtInterpreter = Comparison.compareData(emiStack -> {
            class_2487 tag = new class_2487();
            class_1799 stack = emiStack.getItemStack();
            StorageBlockItem.getMainColorFromStack(stack).ifPresent(mainColor -> tag.method_10569("mainColor", mainColor.intValue()));
            StorageBlockItem.getAccentColorFromStack(stack).ifPresent(accentColor -> tag.method_10569("accentColor", accentColor.intValue()));
            return tag;
        });
        for (class_1747 item : ModBlocks.SHULKER_BOX_ITEMS) {
            registry.setDefaultComparison((Object)item, shulkerBoxNbtInterpreter);
        }
        registry.addRecipeHandler(ModBlocks.STORAGE_CONTAINER_TYPE, (EmiRecipeHandler)new EmiGridMenuInfo());
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)ModItems.CRAFTING_UPGRADE));
        registry.addWorkstation(VanillaEmiRecipeCategories.STONECUTTING, (EmiIngredient)EmiStack.of((class_1935)ModItems.STONECUTTER_UPGRADE));
        ArrayList entries = new ArrayList();
        ((WorkstationCallback)WORKSTATIONS.invoker()).additionalWorkstations(entries::add);
        for (WorkstationEntry entry : entries) {
            registry.addWorkstation(new EmiRecipeCategory(entry.id, (EmiRenderable)EmiStack.of((class_1935)entry.icon)), (EmiIngredient)EmiStack.of((class_1935)entry.workstation));
        }
    }

    private static void registerCraftingRecipes(EmiRegistry registry, Collection<class_8786<class_3955>> recipes) {
        class_310 mc = class_310.method_1551();
        recipes.forEach(r -> registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(((class_3955)r.comp_1933()).method_8117().stream().map(EmiIngredient::of).toList(), EmiStack.of((class_1799)((class_3955)r.comp_1933()).method_8110(mc.field_1687.method_30349())), r.comp_1932())));
    }

    public static interface WorkstationCallback {
        public void additionalWorkstations(Consumer<WorkstationEntry> var1);
    }

    public record WorkstationEntry(class_2960 id, class_2248 icon, class_1792 workstation) {
    }
}

