/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class BarrelMaterialRecipe
extends class_1852 {
    public BarrelMaterialRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_8566 container, class_1937 level) {
        int barrelRow = -1;
        int barrelCol = -1;
        int minRowWithBlock = Integer.MAX_VALUE;
        int minColWithBlock = Integer.MAX_VALUE;
        int maxRowWithBlock = Integer.MIN_VALUE;
        int maxColWithBlock = Integer.MIN_VALUE;
        HashMap<Integer, Integer> rowCounts = new HashMap<Integer, Integer>();
        for (int row = 0; row < container.method_17397(); ++row) {
            for (int col = 0; col < container.method_17398(); ++col) {
                class_1747 blockItem;
                class_1799 item = container.method_5438(col + row * container.method_17398());
                if (item.method_7960()) continue;
                class_1792 class_17922 = item.method_7909();
                if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof BarrelBlock) {
                    if (barrelRow < 0) {
                        barrelRow = row;
                        barrelCol = col;
                        continue;
                    }
                    return false;
                }
                if (item.method_7909() instanceof class_1747) {
                    boolean isBottomMiddleAndBottomLeftHasBlock;
                    boolean bl = isBottomMiddleAndBottomLeftHasBlock = barrelCol == col && barrelRow < row && rowCounts.getOrDefault(row, 0) > 0;
                    if (isBottomMiddleAndBottomLeftHasBlock) {
                        return false;
                    }
                    rowCounts.compute(row, (k, v) -> v == null ? 1 : v + 1);
                    if (row < minRowWithBlock) {
                        minRowWithBlock = row;
                    }
                    if (col < minColWithBlock) {
                        minColWithBlock = col;
                    }
                    if (row > maxRowWithBlock) {
                        maxRowWithBlock = row;
                    }
                    if (col <= maxColWithBlock) continue;
                    maxColWithBlock = col;
                    continue;
                }
                return false;
            }
        }
        if (barrelRow < 0 || rowCounts.isEmpty() || minRowWithBlock < barrelRow - 1 || maxRowWithBlock > barrelRow + 1 || minColWithBlock < barrelCol - 1 || maxColWithBlock > barrelCol + 1) {
            return false;
        }
        return rowCounts.getOrDefault(barrelRow - 1, 0) <= 3 && rowCounts.getOrDefault(barrelRow, 0) <= 2 && rowCounts.getOrDefault(barrelRow + 1, 0) <= 2;
    }

    public class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        int barrelColumn = -1;
        int barrelRow = -1;
        class_1799 barrelStackCopy = class_1799.field_8037;
        for (int row = 0; row < container.method_17397(); ++row) {
            for (int col = 0; col < container.method_17398(); ++col) {
                class_1747 blockItem;
                class_1792 class_17922;
                class_1799 item = container.method_5438(col + row * container.method_17398());
                if (item.method_7960() || barrelColumn >= 0 || !((class_17922 = item.method_7909()) instanceof class_1747) || !((blockItem = (class_1747)class_17922).method_7711() instanceof BarrelBlock)) continue;
                barrelColumn = col;
                barrelRow = row;
                barrelStackCopy = item.method_7972();
                barrelStackCopy.method_7939(1);
            }
        }
        EnumMap<BarrelMaterial, class_2960> materials = new EnumMap<BarrelMaterial, class_2960>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(barrelStackCopy));
        this.uncompactMaterials(materials);
        this.fillGridMaterials(container, barrelColumn, barrelRow, materials);
        BarrelMaterialRecipe.fillEmptyMaterialsWithDefaults(materials);
        BarrelMaterialRecipe.compactMaterials(materials);
        BarrelBlockItem.setMaterials(barrelStackCopy, materials);
        BarrelMaterialRecipe.removeCoveredTints(barrelStackCopy, materials);
        return barrelStackCopy;
    }

    private void uncompactMaterials(Map<BarrelMaterial, class_2960> materials) {
        if (materials.isEmpty()) {
            return;
        }
        EnumMap uncompactedMaterials = new EnumMap(BarrelMaterial.class);
        materials.forEach((mat, texture) -> {
            for (BarrelMaterial child : mat.getChildren()) {
                uncompactedMaterials.put(child, texture);
            }
        });
        materials.clear();
        materials.putAll(uncompactedMaterials);
    }

    private static void removeCoveredTints(class_1799 barrelStackCopy, Map<BarrelMaterial, class_2960> materials) {
        class_1792 class_17922 = barrelStackCopy.method_7909();
        if (class_17922 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
            boolean hasMainTint = tintableBlockItem.getMainColor(barrelStackCopy).isPresent();
            boolean hasAccentTint = tintableBlockItem.getAccentColor(barrelStackCopy).isPresent();
            if (hasMainTint || hasAccentTint) {
                Set materialModelParts = materials.keySet().stream().map(BarrelMaterial::getMaterialModelPart).collect(Collectors.toSet());
                if (hasMainTint && (materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.BOTH) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE))) {
                    tintableBlockItem.removeMainColor(barrelStackCopy);
                }
                if (hasAccentTint && (materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.BOTH) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM))) {
                    tintableBlockItem.removeAccentColor(barrelStackCopy);
                }
            }
        }
    }

    private static void compactMaterials(Map<BarrelMaterial, class_2960> materials) {
        for (BarrelMaterial material : BarrelMaterial.values()) {
            if (material.isLeaf()) continue;
            class_2960 firstChildTexture = null;
            boolean allChildrenHaveSameTexture = true;
            for (BarrelMaterial child : material.getChildren()) {
                class_2960 texture = materials.get((Object)child);
                if (texture == null || firstChildTexture != null && !firstChildTexture.equals((Object)texture)) {
                    allChildrenHaveSameTexture = false;
                    break;
                }
                if (firstChildTexture != null) continue;
                firstChildTexture = texture;
            }
            if (firstChildTexture == null || !allChildrenHaveSameTexture) continue;
            materials.put(material, firstChildTexture);
            for (BarrelMaterial child : material.getChildren()) {
                materials.remove((Object)child);
            }
        }
    }

    private static void fillEmptyMaterialsWithDefaults(Map<BarrelMaterial, class_2960> materials) {
        block0: for (BarrelMaterial material : BarrelMaterial.values()) {
            if (!material.isLeaf() || materials.containsKey((Object)material)) continue;
            for (BarrelMaterial fillFromDefault : BarrelMaterial.getFillFromDefaults(material)) {
                if (!materials.containsKey((Object)fillFromDefault)) continue;
                materials.put(material, materials.get((Object)fillFromDefault));
                continue block0;
            }
        }
    }

    private void fillGridMaterials(class_8566 container, int barrelColumn, int barrelRow, Map<BarrelMaterial, class_2960> materials) {
        for (int row = 0; row < container.method_17397(); ++row) {
            for (int col = 0; col < container.method_17398(); ++col) {
                class_1792 class_17922;
                class_1799 item = container.method_5438(col + row * container.method_17398());
                if (row == barrelRow && col == barrelColumn || item.method_7960() || !((class_17922 = item.method_7909()) instanceof class_1747)) continue;
                class_1747 blockItem = (class_1747)class_17922;
                List<BarrelMaterial> barrelMaterials = this.getBarrelMaterials(row, col, barrelRow, barrelColumn);
                boolean firstMaterial = true;
                for (BarrelMaterial barrelMaterial : barrelMaterials) {
                    if (!materials.containsKey((Object)barrelMaterial) || firstMaterial) {
                        materials.put(barrelMaterial, class_7923.field_41175.method_10221((Object)blockItem.method_7711()));
                    }
                    firstMaterial = false;
                }
            }
        }
    }

    private List<BarrelMaterial> getBarrelMaterials(int row, int col, int barrelRow, int barrelColumn) {
        if (row < barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.TOP);
            }
            if (col == barrelColumn) {
                return List.of(BarrelMaterial.TOP_INNER_TRIM, BarrelMaterial.TOP, BarrelMaterial.TOP_TRIM);
            }
            return List.of(BarrelMaterial.TOP_TRIM);
        }
        if (row == barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.SIDE);
            }
            return List.of(BarrelMaterial.SIDE_TRIM);
        }
        if (col < barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM);
        }
        if (col == barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM, BarrelMaterial.BOTTOM_TRIM);
        }
        return List.of(BarrelMaterial.BOTTOM_TRIM);
    }

    public boolean method_8113(int width, int height) {
        return width * height > 1;
    }

    public class_1865<?> method_8119() {
        return ModBlocks.BARREL_MATERIAL_RECIPE_SERIALIZER;
    }
}

