/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class ShulkerBoxItem
extends StorageBlockItem
implements IStashStorageItem {
    public ShulkerBoxItem(class_2248 block) {
        this(block, new class_1792.class_1793().method_7889(1));
    }

    public ShulkerBoxItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (flagIn == class_1836.field_41071) {
            StackStorageWrapper.fromData(stack).getContentsUuid().ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + uuid)).method_27692(class_124.field_1063)));
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public boolean method_31568() {
        return false;
    }

    public void method_33261(class_1542 itemEntity) {
        class_1937 level = itemEntity.method_37908();
        if (level.field_9236) {
            return;
        }
        class_1799 stack = itemEntity.method_6983();
        StackStorageWrapper storageWrapper = StackStorageWrapper.fromData(stack);
        InventoryHelper.dropItems((SlottedStackStorage)storageWrapper.getInventoryHandler(), (class_1937)level, (double)itemEntity.method_23317(), (double)itemEntity.method_23318(), (double)itemEntity.method_23321());
        InventoryHelper.dropItems((SlottedStackStorage)storageWrapper.getUpgradeHandler(), (class_1937)level, (double)itemEntity.method_23317(), (double)itemEntity.method_23318(), (double)itemEntity.method_23321());
    }

    public Optional<class_5632> getInventoryTooltip(class_1799 stack) {
        return Optional.of(new StorageContentsTooltip(stack));
    }

    public class_1799 stash(class_1799 storageStack, class_1799 stack) {
        StackStorageWrapper wrapper = StackStorageWrapper.fromData(storageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            wrapper.setContentsUuid(UUID.randomUUID());
        }
        try (Transaction inner = Transaction.openOuter();){
            class_1799 stashResult = stack.method_46651(stack.method_7947() - (int)wrapper.getInventoryForUpgradeProcessing().insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)inner));
            inner.commit();
            class_1799 class_17992 = stashResult;
            return class_17992;
        }
    }

    public IStashStorageItem.StashResult getItemStashable(class_1799 storageStack, class_1799 stack) {
        StackStorageWrapper wrapper = StackStorageWrapper.fromData(storageStack);
        if (StorageUtil.simulateInsert((Storage)wrapper.getInventoryForUpgradeProcessing(), (Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), null) == 0L) {
            return IStashStorageItem.StashResult.NO_SPACE;
        }
        if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.method_7909()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
            return IStashStorageItem.StashResult.MATCH_AND_SPACE;
        }
        return IStashStorageItem.StashResult.SPACE;
    }

    public void setNumberOfInventorySlots(class_1799 shulkerBoxStack, int numberOfInventorySlots) {
        NBTHelper.putInt((class_2487)shulkerBoxStack.method_7948(), (String)"numberOfInventorySlots", (int)numberOfInventorySlots);
    }

    public int getNumberOfInventorySlots(class_1799 shulkerBoxStack) {
        int defaultNumberOfInventorySlots = StackStorageWrapper.fromData(shulkerBoxStack).getDefaultNumberOfInventorySlots();
        return NBTHelper.getInt((class_1799)shulkerBoxStack, (String)"numberOfInventorySlots").map(inventorySlots -> Math.max(inventorySlots, defaultNumberOfInventorySlots)).orElse(defaultNumberOfInventorySlots);
    }

    public int getNumberOfUpgradeSlots(class_1799 shulkerBoxStack) {
        int defaultNumberOfUpgradeSlots = StackStorageWrapper.fromData(shulkerBoxStack).getDefaultNumberOfUpgradeSlots();
        return NBTHelper.getInt((class_1799)shulkerBoxStack, (String)"numberOfUpgradeSlots").map(numberOfUpgradeSlots -> Math.max(numberOfUpgradeSlots, defaultNumberOfUpgradeSlots)).orElse(defaultNumberOfUpgradeSlots);
    }

    public void setNumberOfUpgradeSlots(class_1799 shulkerBoxStack, int numberOfUpgradeSlots) {
        NBTHelper.putInt((class_2487)shulkerBoxStack.method_7948(), (String)"numberOfUpgradeSlots", (int)numberOfUpgradeSlots);
    }

    public boolean method_31565(class_1799 storageStack, class_1735 slot, class_5536 action, class_1657 player) {
        if (storageStack.method_7947() > 1 || !slot.method_7674(player) || slot.method_7677().method_7960() || action != class_5536.field_27014) {
            return super.method_31565(storageStack, slot, action, player);
        }
        class_1799 stackToStash = slot.method_7677();
        class_1799 stashResult = this.stash(storageStack, stackToStash);
        if (stashResult.method_7947() != stackToStash.method_7947()) {
            slot.method_7673(stashResult);
            slot.method_7667(player, stashResult);
            return true;
        }
        return super.method_31565(storageStack, slot, action, player);
    }

    public boolean method_31566(class_1799 storageStack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 carriedAccess) {
        if (storageStack.method_7947() > 1 || !slot.method_7680(storageStack) || action != class_5536.field_27014) {
            return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        class_1799 result = this.stash(storageStack, otherStack);
        if (result.method_7947() != otherStack.method_7947()) {
            carriedAccess.method_32332(result);
            slot.method_7673(storageStack);
            return true;
        }
        return super.method_31566(storageStack, otherStack, slot, action, player, carriedAccess);
    }
}

