/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.common.StorageWrapperLookup;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;

public class StackStorageWrapper
extends StorageWrapper {
    private static final String CONTENTS_TAG = "contents";
    private class_1799 storageStack;

    public StackStorageWrapper() {
        super(() -> () -> {}, () -> {}, () -> {});
    }

    public static StackStorageWrapper fromData(class_1799 stack) {
        StackStorageWrapper stackStorageWrapper = StorageWrapperLookup.getOrCreate(stack);
        stackStorageWrapper.setStorageStack(stack);
        UUID uuid = NBTHelper.getUniqueId((class_1799)stack, (String)"uuid").orElse(null);
        if (uuid != null) {
            class_2487 compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).method_10562("storageWrapper");
            stackStorageWrapper.load(compoundtag);
            stackStorageWrapper.setContentsUuid(uuid);
        }
        return stackStorageWrapper;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable(this.contentsUuid);
    }

    @Override
    public void setContentsUuid(@Nullable UUID contentsUuid) {
        super.setContentsUuid(contentsUuid);
        if (contentsUuid != null) {
            NBTHelper.setUniqueId((class_1799)this.storageStack, (String)"uuid", (UUID)contentsUuid);
            ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
            class_2487 storageContents = itemContentsStorage.getOrCreateStorageContents(contentsUuid);
            if (!storageContents.method_10545("storageWrapper")) {
                class_2487 storageWrapperTag = new class_2487();
                storageWrapperTag.method_10566(CONTENTS_TAG, (class_2520)new class_2487());
                storageContents.method_10566("storageWrapper", (class_2520)storageWrapperTag);
            }
            this.onContentsNbtUpdated();
        }
    }

    @Override
    protected class_2487 getContentsNbt() {
        if (this.contentsUuid == null) {
            this.contentsUuid = this.getNewUuid();
        }
        return ItemContentsStorage.get().getOrCreateStorageContents(this.contentsUuid).method_10562("storageWrapper").method_10562(CONTENTS_TAG);
    }

    @Override
    protected void onUpgradeRefresh() {
    }

    @Override
    public int getDefaultNumberOfInventorySlots() {
        int n;
        BlockItemBase blockItem;
        class_1792 class_17922 = this.storageStack.method_7909();
        if (class_17922 instanceof BlockItemBase && (class_17922 = (blockItem = (BlockItemBase)class_17922).method_7711()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)class_17922;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    protected void loadSlotNumbers(class_2487 tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((class_1799)this.storageStack, (String)"numberOfInventorySlots").orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((class_1799)this.storageStack, (String)"numberOfUpgradeSlots").orElse(0);
    }

    @Override
    public int getDefaultNumberOfUpgradeSlots() {
        int n;
        BlockItemBase blockItem;
        class_1792 class_17922 = this.storageStack.method_7909();
        if (class_17922 instanceof BlockItemBase && (class_17922 = (blockItem = (BlockItemBase)class_17922).method_7711()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)class_17922;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    protected void setStorageStack(class_1799 storageStack) {
        this.storageStack = storageStack;
    }

    @Override
    protected boolean isAllowedInStorage(class_1799 stack) {
        if (!(this.storageStack.method_7909() instanceof ShulkerBoxItem)) {
            return false;
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        return !(block instanceof ShulkerBoxBlock) && !(block instanceof class_2480) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.method_7909());
    }

    public String getStorageType() {
        return "irrelevant";
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43473();
    }
}

