/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.entity.CableBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class CableBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<CableBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_41759.xmap(Tier::valueOf, Enum::toString).fieldOf("tier").forGetter(CableBlock::getTier)).apply((Applicative)instance, CableBlock::new));
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE_CORE = class_2248.method_9541((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final class_265 SHAPE_UP = class_2248.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 SHAPE_DOWN = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final class_265 SHAPE_NORTH = class_2248.method_9541((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final class_265 SHAPE_EAST = class_2248.method_9541((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final class_265 SHAPE_WEST = class_2248.method_9541((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private final Tier tier;

    public CableBlock(Tier tier) {
        super((class_4970.class_2251)tier.getProperties());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.tier = tier;
    }

    public Tier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_1937 level = blockPlaceContext.method_8045();
        class_2338 selfPos = blockPlaceContext.method_8037();
        class_3610 fluidState = level.method_8316(selfPos);
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)UP, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11036)))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11033)))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11043)))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11035)))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11034)))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11039)))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return state;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        class_265 shape = SHAPE_CORE;
        if (((Boolean)blockState.method_11654((class_2769)UP)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_UP);
        }
        if (((Boolean)blockState.method_11654((class_2769)DOWN)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_DOWN);
        }
        if (((Boolean)blockState.method_11654((class_2769)NORTH)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_NORTH);
        }
        if (((Boolean)blockState.method_11654((class_2769)SOUTH)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_SOUTH);
        }
        if (((Boolean)blockState.method_11654((class_2769)EAST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_EAST);
        }
        if (((Boolean)blockState.method_11654((class_2769)WEST)).booleanValue()) {
            shape = class_259.method_1084((class_265)shape, (class_265)SHAPE_WEST);
        }
        return shape;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 selfPos, class_2338 facingPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(selfPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, facing, facingState, level, selfPos, facingPos);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{UP}).method_11667(new class_2769[]{DOWN}).method_11667(new class_2769[]{NORTH}).method_11667(new class_2769[]{SOUTH}).method_11667(new class_2769[]{EAST}).method_11667(new class_2769[]{WEST}).method_11667(new class_2769[]{WATERLOGGED});
    }

    public void method_9612(class_2680 selfState, class_1937 level, class_2338 selfPos, class_2248 fromBlock, class_2338 fromPos, boolean isMoving) {
        super.method_9612(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.method_8608()) {
            return;
        }
        class_3610 fluidState = level.method_8316(selfPos);
        class_2680 newState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)UP, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11036)))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11033)))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11043)))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11035)))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11034)))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, class_2350.field_11039)))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        level.method_8501(selfPos, newState);
        class_2586 blockEntity = level.method_8321(selfPos);
        if (blockEntity == null || !(blockEntity instanceof CableBlockEntity)) {
            return;
        }
        CableBlockEntity.updateConnections(level, selfPos, newState, (CableBlockEntity)blockEntity);
    }

    private boolean shouldConnectTo(class_1937 level, class_2338 selfPos, class_2350 direction) {
        CableBlockEntity cableBlockEntity;
        class_2338 toPos = selfPos.method_10093(direction);
        class_2586 blockEntity = level.method_8321(toPos);
        if (blockEntity == null) {
            return false;
        }
        if (blockEntity instanceof CableBlockEntity && (cableBlockEntity = (CableBlockEntity)blockEntity).getTier() != this.getTier()) {
            return false;
        }
        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, toPos, (Object)direction.method_10153());
        return energyStorage != null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 state) {
        return new CableBlockEntity(blockPos, state, this.tier);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return CableBlock.method_31618(type, CableBlockEntity.getEntityTypeFromTier(this.tier), CableBlockEntity::tick);
    }

    public static enum Tier {
        TIER_TIN("tin_cable", ModConfigs.COMMON_TIN_CABLE_TRANSFER_RATE.getValue(), FabricBlockSettings.create().mapColor(class_3620.field_15978).strength(0.5f).sounds(class_2498.field_11543)),
        TIER_COPPER("copper_cable", ModConfigs.COMMON_COPPER_CABLE_TRANSFER_RATE.getValue(), FabricBlockSettings.create().mapColor(class_3620.field_15978).strength(0.5f).sounds(class_2498.field_11543)),
        TIER_GOLD("gold_cable", ModConfigs.COMMON_GOLD_CABLE_TRANSFER_RATE.getValue(), FabricBlockSettings.create().mapColor(class_3620.field_15978).strength(0.5f).sounds(class_2498.field_11543)),
        TIER_ENERGIZED_COPPER("energized_copper_cable", ModConfigs.COMMON_ENERGIZED_COPPER_CABLE_TRANSFER_RATE.getValue(), FabricBlockSettings.create().mapColor(class_3620.field_15978).strength(0.5f).sounds(class_2498.field_11543)),
        TIER_ENERGIZED_GOLD("energized_gold_cable", ModConfigs.COMMON_ENERGIZED_GOLD_CABLE_TRANSFER_RATE.getValue(), FabricBlockSettings.create().mapColor(class_3620.field_15978).strength(0.5f).sounds(class_2498.field_11543)),
        TIER_ENERGIZED_CRYSTAL_MATRIX("energized_crystal_matrix_cable", ModConfigs.COMMON_ENERGIZED_CRYSTAL_MATRIX_CABLE_TRANSFER_RATE.getValue(), FabricBlockSettings.create().mapColor(class_3620.field_15978).strength(0.5f).sounds(class_2498.field_11543));

        private final String resourceId;
        private final long maxTransfer;
        private final FabricBlockSettings props;

        private Tier(String resourceId, long maxTransfer, FabricBlockSettings props) {
            this.resourceId = resourceId;
            this.maxTransfer = maxTransfer;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public long getMaxTransfer() {
            return this.maxTransfer;
        }

        public FabricBlockSettings getProperties() {
            return this.props;
        }
    }

    public static enum EnergyExtractionMode {
        PUSH,
        PULL,
        BOTH;


        public boolean isPush() {
            return this == PUSH || this == BOTH;
        }

        public boolean isPull() {
            return this == PULL || this == BOTH;
        }
    }

    public static class Item
    extends class_1747 {
        private final Tier tier;

        public Item(class_2248 block, FabricItemSettings props, Tier tier) {
            super(block, (class_1792.class_1793)props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.cable.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxTransfer())}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.cable.txt.shift.2").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
            }
        }
    }
}

