/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.FluidTankBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlock
extends class_2237 {
    public static final MapCodec<FluidTankBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_41759.xmap(Tier::valueOf, Enum::toString).fieldOf("tier").forGetter(FluidTankBlock::getTier)).apply((Applicative)instance, FluidTankBlock::new));
    public static final class_2753 FACING = class_2741.field_12481;
    private final Tier tier;

    public static class_2248 getBlockFromTier(Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case Tier.SMALL -> ModBlocks.FLUID_TANK_SMALL;
            case Tier.MEDIUM -> ModBlocks.FLUID_TANK_MEDIUM;
            case Tier.LARGE -> ModBlocks.FLUID_TANK_LARGE;
        };
    }

    public FluidTankBlock(Tier tier) {
        super((class_4970.class_2251)tier.getProperties());
        this.tier = tier;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public Tier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 state) {
        return new FluidTankBlockEntity(blockPos, state, this.tier);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 blockPos) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof FluidTankBlockEntity)) {
            return super.method_9572(state, level, blockPos);
        }
        FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
        return fluidTankBlockEntity.getRedstoneOutput();
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 handItem, class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof FluidTankBlockEntity) || ((FluidTankBlockEntity)blockEntity).getTier() != this.tier) {
            throw new IllegalStateException("Container is invalid");
        }
        player.method_17355((class_3908)((FluidTankBlockEntity)blockEntity));
        return class_1269.field_5812;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return FluidTankBlock.method_31618(type, FluidTankBlockEntity.getEntityTypeFromTier(this.tier), FluidTankBlockEntity::tick);
    }

    public static enum Tier {
        SMALL("fluid_tank_small", FluidUtils.convertMilliBucketsToDroplets(1000L * ModConfigs.COMMON_FLUID_TANK_SMALL_TANK_CAPACITY.getValue()), FabricBlockSettings.create().requiresTool().strength(4.0f, 5.0f).sounds(class_2498.field_11533)),
        MEDIUM("fluid_tank_medium", FluidUtils.convertMilliBucketsToDroplets(1000L * ModConfigs.COMMON_FLUID_TANK_MEDIUM_TANK_CAPACITY.getValue()), FabricBlockSettings.create().requiresTool().strength(4.0f, 5.0f).sounds(class_2498.field_11533)),
        LARGE("fluid_tank_large", FluidUtils.convertMilliBucketsToDroplets(1000L * ModConfigs.COMMON_FLUID_TANK_LARGE_TANK_CAPACITY.getValue()), FabricBlockSettings.create().requiresTool().strength(4.0f, 5.0f).sounds(class_2498.field_11533));

        private final String resourceId;
        private final long tankCapacity;
        private final FabricBlockSettings props;

        private Tier(String resourceId, long tankCapacity, FabricBlockSettings props) {
            this.resourceId = resourceId;
            this.tankCapacity = tankCapacity;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public long getTankCapacity() {
            return this.tankCapacity;
        }

        public FabricBlockSettings getProperties() {
            return this.props;
        }
    }

    public static class Item
    extends class_1747 {
        private final Tier tier;

        public Item(class_2248 block, FabricItemSettings props, Tier tier) {
            super(block, (class_1792.class_1793)props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
            if (class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.tank_capacity.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(this.tier.getTankCapacity()))}).method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
            }
        }
    }
}

