/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.AdvancedAutoCrafterBlock;
import me.jddev0.ep.block.entity.AutoCrafterBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.AdvancedAutoCrafterMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.ItemStackUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class AdvancedAutoCrafterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate,
CheckboxUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    public static final long CAPACITY = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_TRANSFER_RATE.getValue();
    public static final long ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue().intValue();
    final CachedSidedInventoryStorage<AutoCrafterBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    private boolean secondaryExtractMode = false;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    private final class_1277[] patternSlots = new class_1277[]{new class_1277(9){

        public int method_5444() {
            return 1;
        }
    }, new class_1277(9){

        public int method_5444() {
            return 1;
        }
    }, new class_1277(9){

        public int method_5444() {
            return 1;
        }
    }};
    private final class_1277[] patternResultSlots = new class_1277[]{new class_1277(1), new class_1277(1), new class_1277(1)};
    private final class_1265[] updatePatternListener = new class_1265[]{container -> this.updateRecipe(0), container -> this.updateRecipe(1), container -> this.updateRecipe(2)};
    private final boolean[] hasRecipeLoaded = new boolean[]{false, false, false};
    private final class_2960[] recipeIdForSetRecipe = new class_2960[]{null, null, null};
    private final class_8786<class_3955>[] craftingRecipe = new class_8786[]{null, null, null};
    private final class_1715[] oldCopyOfRecipe = new class_1715[]{null, null, null};
    private final class_1703 dummyContainerMenu = new class_1703(null, -1){

        public class_1799 method_7601(class_1657 player, int index) {
            return null;
        }

        public boolean method_7597(class_1657 player) {
            return false;
        }

        public void method_7609(class_1263 container) {
        }
    };
    protected final class_3913 data;
    private final int[] progress = new int[]{0, 0, 0};
    private static final int MAX_PROGRESS = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private final int[] maxProgress = new int[]{MAX_PROGRESS, MAX_PROGRESS, MAX_PROGRESS};
    private final long[] energyConsumptionLeft = new long[]{-1L, -1L, -1L};
    private final boolean[] hasEnoughEnergy = new boolean[]{false, false, false};
    private final boolean[] ignoreNBT = new boolean[]{false, false, false};
    private int currentRecipeIndex = 0;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public AdvancedAutoCrafterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_AUTO_CRAFTER_ENTITY, blockPos, blockState);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.patternSlots[i2].method_5489(this.updatePatternListener[i2]);
        }
        this.internalInventory = new class_1277(27){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot < 0 || slot >= 27) {
                    return super.method_5437(slot, stack);
                }
                return slot >= 5;
            }

            public void method_5431() {
                super.method_5431();
                AdvancedAutoCrafterBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 27).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i >= 5, i -> this.secondaryExtractMode ? !this.isInput(this.internalInventory.method_5438(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.internalInventory.method_5438(i.intValue())));
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                AdvancedAutoCrafterBlockEntity.this.method_5431();
                if (AdvancedAutoCrafterBlockEntity.this.field_11863 != null && !AdvancedAutoCrafterBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(AdvancedAutoCrafterBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(AdvancedAutoCrafterBlockEntity.this.method_11016(), (class_3218)AdvancedAutoCrafterBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.progress[0], index);
                    case 2, 3 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.maxProgress[0], index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.progress[1], index - 4);
                    case 6, 7 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.maxProgress[1], index - 6);
                    case 8, 9 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.progress[2], index - 8);
                    case 10, 11 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.maxProgress[2], index - 10);
                    case 12, 13, 14, 15 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.energyConsumptionLeft[0], index - 12);
                    case 16, 17, 18, 19 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.energyConsumptionLeft[1], index - 16);
                    case 20, 21, 22, 23 -> ByteUtils.get2Bytes(AdvancedAutoCrafterBlockEntity.this.energyConsumptionLeft[2], index - 20);
                    case 24 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.hasEnoughEnergy[0]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 25 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.hasEnoughEnergy[1]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 26 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.hasEnoughEnergy[2]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 27 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.ignoreNBT[0]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 28 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.ignoreNBT[1]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 29 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.ignoreNBT[2]) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 30 -> {
                        if (AdvancedAutoCrafterBlockEntity.this.secondaryExtractMode) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 31 -> AdvancedAutoCrafterBlockEntity.this.currentRecipeIndex;
                    case 32 -> AdvancedAutoCrafterBlockEntity.this.redstoneMode.ordinal();
                    case 33 -> AdvancedAutoCrafterBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AdvancedAutoCrafterBlockEntity.this.progress[0] = ByteUtils.with2Bytes(AdvancedAutoCrafterBlockEntity.this.progress[0], (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AdvancedAutoCrafterBlockEntity.this.maxProgress[0] = ByteUtils.with2Bytes(AdvancedAutoCrafterBlockEntity.this.maxProgress[0], (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: {
                        AdvancedAutoCrafterBlockEntity.this.progress[1] = ByteUtils.with2Bytes(AdvancedAutoCrafterBlockEntity.this.progress[1], (short)value, index - 4);
                        break;
                    }
                    case 6: 
                    case 7: {
                        AdvancedAutoCrafterBlockEntity.this.maxProgress[1] = ByteUtils.with2Bytes(AdvancedAutoCrafterBlockEntity.this.maxProgress[1], (short)value, index - 6);
                        break;
                    }
                    case 8: 
                    case 9: {
                        AdvancedAutoCrafterBlockEntity.this.progress[2] = ByteUtils.with2Bytes(AdvancedAutoCrafterBlockEntity.this.progress[2], (short)value, index - 8);
                        break;
                    }
                    case 10: 
                    case 11: {
                        AdvancedAutoCrafterBlockEntity.this.maxProgress[2] = ByteUtils.with2Bytes(AdvancedAutoCrafterBlockEntity.this.maxProgress[2], (short)value, index - 10);
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        break;
                    }
                    case 27: {
                        AdvancedAutoCrafterBlockEntity.this.ignoreNBT[0] = value != 0;
                        break;
                    }
                    case 28: {
                        AdvancedAutoCrafterBlockEntity.this.ignoreNBT[1] = value != 0;
                        break;
                    }
                    case 29: {
                        AdvancedAutoCrafterBlockEntity.this.ignoreNBT[2] = value != 0;
                        break;
                    }
                    case 30: {
                        AdvancedAutoCrafterBlockEntity.this.secondaryExtractMode = value != 0;
                        break;
                    }
                    case 31: {
                        AdvancedAutoCrafterBlockEntity.this.currentRecipeIndex = value;
                        break;
                    }
                    case 32: {
                        AdvancedAutoCrafterBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 33: {
                        AdvancedAutoCrafterBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 34;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.advanced_auto_crafter");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new AdvancedAutoCrafterMenu(id, this, inventory, (class_1263)this.internalInventory, (class_1263[])this.patternSlots, (class_1263[])this.patternResultSlots, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    protected void method_11007(class_2487 nbt) {
        int i;
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("pattern." + i, this.savePatternContainer(i));
        }
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        for (i = 0; i < 3; ++i) {
            if (this.craftingRecipe[i] != null) {
                nbt.method_10566("recipe.id." + i, (class_2520)class_2519.method_23256((String)this.craftingRecipe[i].comp_1932().toString()));
            }
            nbt.method_10566("recipe.progress." + i, (class_2520)class_2497.method_23247((int)this.progress[i]));
            nbt.method_10566("recipe.energy_consumption_left." + i, (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft[i]));
            nbt.method_10556("ignore_nbt." + i, this.ignoreNBT[i]);
        }
        nbt.method_10556("secondary_extract_mode", this.secondaryExtractMode);
        nbt.method_10569("current_recipe_index", this.currentRecipeIndex);
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    private class_2520 savePatternContainer(int index) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.patternSlots[index].method_5439(); ++i) {
            if (this.patternSlots[index].method_5438(i).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            this.patternSlots[index].method_5438(i).method_7953(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        return nbtTagList;
    }

    public void method_11014(@NotNull class_2487 nbt) {
        int i;
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        for (i = 0; i < 3; ++i) {
            this.loadPatternContainer(i, nbt.method_10580("pattern." + i));
        }
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        for (i = 0; i < 3; ++i) {
            if (nbt.method_10545("recipe.id." + i)) {
                class_2520 tag = nbt.method_10580("recipe.id." + i);
                if (!(tag instanceof class_2519)) {
                    throw new IllegalArgumentException("Tag must be of type StringTag!");
                }
                class_2519 stringTag = (class_2519)tag;
                this.recipeIdForSetRecipe[i] = class_2960.method_12829((String)stringTag.method_10714());
            }
            this.progress[i] = nbt.method_10550("recipe.progress." + i);
            this.energyConsumptionLeft[i] = nbt.method_10537("recipe.energy_consumption_left." + i);
            this.ignoreNBT[i] = nbt.method_10577("ignore_nbt." + i);
        }
        this.secondaryExtractMode = nbt.method_10577("secondary_extract_mode");
        this.currentRecipeIndex = nbt.method_10550("current_recipe_index");
        if (this.currentRecipeIndex < 0 || this.currentRecipeIndex >= 3) {
            this.currentRecipeIndex = 0;
        }
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    private void loadPatternContainer(int index, class_2520 tag) {
        if (!(tag instanceof class_2499)) {
            throw new IllegalArgumentException("Tag must be of type ListTag!");
        }
        this.patternSlots[index].method_5488(this.updatePatternListener[index]);
        class_2499 tagList = (class_2499)tag;
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.patternSlots[index].method_5439()) continue;
            this.patternSlots[index].method_5447(slot, class_1799.method_7915((class_2487)itemTags));
        }
        this.patternSlots[index].method_5489(this.updatePatternListener[index]);
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedAutoCrafterBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AdvancedAutoCrafterBlock.POWERED))) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (!blockEntity.hasRecipeLoaded[i]) {
                blockEntity.updateRecipe(i);
                if (blockEntity.craftingRecipe[i] == null) {
                    blockEntity.resetProgress(i);
                }
            }
            int itemCount = 0;
            for (int j = 0; j < blockEntity.patternSlots[i].method_5439(); ++j) {
                if (blockEntity.patternSlots[i].method_5438(j).method_7960()) continue;
                ++itemCount;
            }
            if (itemCount == 0) continue;
            if (blockEntity.craftingRecipe[i] != null && (blockEntity.progress[i] > 0 || blockEntity.canInsertItemsIntoOutputSlots(i) && blockEntity.canExtractItemsFromInput(i))) {
                if (!blockEntity.canInsertItemsIntoOutputSlots(i) || !blockEntity.canExtractItemsFromInput(i)) continue;
                long energyConsumptionPerTick = (long)itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT;
                if (blockEntity.progress[i] == 0) {
                    if (!blockEntity.canExtractItemsFromInput(i)) continue;
                    blockEntity.energyConsumptionLeft[i] = energyConsumptionPerTick * (long)blockEntity.maxProgress[i];
                }
                if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0L || energyConsumptionPerTick < 0L) {
                    blockEntity.resetProgress(i);
                    AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                if (energyConsumptionPerTick <= blockEntity.internalEnergyStorage.amount) {
                    try (Transaction transaction = Transaction.openOuter();){
                        blockEntity.internalEnergyStorage.extract(energyConsumptionPerTick, (TransactionContext)transaction);
                        transaction.commit();
                    }
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        class_1277 patternSlotsForRecipe = blockEntity.ignoreNBT[i] ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots[i]) : blockEntity.patternSlots[i];
                        class_1715 copyOfPatternSlots = new class_1715(blockEntity.dummyContainerMenu, 3, 3);
                        for (int j = 0; j < patternSlotsForRecipe.method_5439(); ++j) {
                            copyOfPatternSlots.method_5447(j, patternSlotsForRecipe.method_5438(j));
                        }
                        blockEntity.extractItems(i);
                        blockEntity.craftItem(i, copyOfPatternSlots);
                    }
                    AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedAutoCrafterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(int index) {
        this.progress[index] = 0;
        this.energyConsumptionLeft[index] = -1L;
        this.hasEnoughEnergy[index] = true;
    }

    public void resetProgressAndMarkAsChanged(int index) {
        this.resetProgress(index);
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void cycleRecipe() {
        class_1277 patternSlotsForRecipe = this.ignoreNBT[this.currentRecipeIndex] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[this.currentRecipeIndex]) : this.patternSlots[this.currentRecipeIndex];
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        List<class_8786<class_3955>> recipes = this.getRecipesFor(copyOfPatternSlots, this.field_11863);
        if (recipes.isEmpty()) {
            this.updateRecipe(this.currentRecipeIndex);
            return;
        }
        if (this.recipeIdForSetRecipe[this.currentRecipeIndex] == null) {
            this.recipeIdForSetRecipe[this.currentRecipeIndex] = this.craftingRecipe[this.currentRecipeIndex] == null || this.craftingRecipe[this.currentRecipeIndex].comp_1932() == null ? recipes.get(0).comp_1932() : this.craftingRecipe[this.currentRecipeIndex].comp_1932();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).comp_1932(), this.recipeIdForSetRecipe[this.currentRecipeIndex])) continue;
            this.recipeIdForSetRecipe[this.currentRecipeIndex] = recipes.get((i + 1) % recipes.size()).comp_1932();
            break;
        }
        this.updateRecipe(this.currentRecipeIndex);
    }

    public void setRecipeIdForSetRecipe(class_2960 recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe[this.currentRecipeIndex] = recipeIdForSetRecipe;
        this.updateRecipe(this.currentRecipeIndex);
    }

    private void updateRecipe(int index) {
        if (this.field_11863 == null) {
            return;
        }
        class_8786<class_3955> oldRecipe = null;
        class_1799 oldResult = null;
        if (this.hasRecipeLoaded[index] && this.craftingRecipe[index] != null && this.oldCopyOfRecipe[index] != null) {
            oldRecipe = this.craftingRecipe[index];
            oldResult = this.craftingRecipe[index].comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe[index].comp_1933()).method_8116((class_1263)this.oldCopyOfRecipe[index], this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe[index].comp_1933()).method_8110(this.field_11863.method_30349());
        }
        this.hasRecipeLoaded[index] = true;
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        Optional<Pair<class_2960, class_8786<class_3955>>> recipe = this.getRecipeFor(copyOfPatternSlots, this.field_11863, this.recipeIdForSetRecipe[index]);
        if (recipe.isPresent()) {
            this.craftingRecipe[index] = (class_8786)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe[index] != null && !Objects.equals(this.craftingRecipe[index].comp_1932(), this.recipeIdForSetRecipe[index])) {
                this.recipeIdForSetRecipe[index] = this.craftingRecipe[index].comp_1932();
                this.resetProgress(index);
            }
            class_1799 resultItemStack = this.craftingRecipe[index].comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe[index].comp_1933()).method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe[index].comp_1933()).method_8110(this.field_11863.method_30349());
            this.patternResultSlots[index].method_5447(0, resultItemStack);
            if (!(oldRecipe == null || oldResult == null || this.oldCopyOfRecipe[index] == null || this.craftingRecipe[index] == oldRecipe && class_1799.method_7973((class_1799)resultItemStack, (class_1799)oldResult))) {
                this.resetProgress(index);
            }
            this.oldCopyOfRecipe[index] = new class_1715(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
                this.oldCopyOfRecipe[index].method_5447(i, copyOfPatternSlots.method_5438(i).method_7972());
            }
        } else {
            this.recipeIdForSetRecipe[index] = null;
            this.craftingRecipe[index] = null;
            this.patternResultSlots[index].method_5447(0, class_1799.field_8037);
            this.oldCopyOfRecipe[index] = null;
            this.resetProgress(index);
        }
    }

    private void extractItems(int index) {
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        ArrayList<class_1799> patternItemStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            if (patternSlotsForRecipe.method_5438(i).method_7960()) continue;
            patternItemStacks.add(patternSlotsForRecipe.method_5438(i));
        }
        List<class_1799> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (class_1799 itemStack : itemStacksExtract) {
            for (int i = 0; i < this.internalInventory.method_5439(); ++i) {
                class_1799 ret;
                class_1799 testItemStack = this.internalInventory.method_5438(i);
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (ret = this.internalInventory.method_5434(i, itemStack.method_7947())).method_7960()) continue;
                int amount = ret.method_7947();
                if (amount == itemStack.method_7947()) continue block1;
                itemStack.method_7934(amount);
            }
        }
    }

    private void craftItem(int index, class_1715 copyOfPatternSlots) {
        if (this.craftingRecipe[index] == null) {
            this.resetProgress(index);
            return;
        }
        ArrayList<class_1799> outputItemStacks = new ArrayList<class_1799>(10);
        class_1799 resultItemStack = this.craftingRecipe[index].comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe[index].comp_1933()).method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe[index].comp_1933()).method_8110(this.field_11863.method_30349());
        outputItemStacks.add(resultItemStack);
        for (class_1799 remainingItem : ((class_3955)this.craftingRecipe[index].comp_1933()).method_8111((class_1263)copyOfPatternSlots)) {
            if (remainingItem.method_7960()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<class_1799> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(27);
        block1: for (class_1799 itemStack : itemStacksInsert) {
            for (int i = 0; i < this.internalInventory.method_5439(); ++i) {
                int amount;
                class_1799 testItemStack = this.internalInventory.method_5438(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.method_7960()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack) || (amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947())) <= 0) continue;
                this.internalInventory.method_5447(i, this.internalInventory.method_5438(i).method_46651(testItemStack.method_7947() + amount));
                itemStack.method_7939(itemStack.method_7947() - amount);
                if (itemStack.method_7960()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.internalInventory.method_5447(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT[index]) {
            this.updateRecipe(index);
        }
        this.resetProgress(index);
    }

    private boolean canExtractItemsFromInput(int index) {
        if (this.craftingRecipe[index] == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        ArrayList<class_1799> patternItemStacks = new ArrayList<class_1799>(9);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            if (patternSlotsForRecipe.method_5438(i).method_7960()) continue;
            patternItemStacks.add(patternSlotsForRecipe.method_5438(i));
        }
        List<class_1799> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(27);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                class_1799 itemStack = itemStacks.get(i);
                for (int j = 0; j < this.internalInventory.method_5439(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    class_1799 testItemStack = this.internalInventory.method_5438(j);
                    if (testItemStack.method_7960()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                    int amount = Math.min(itemStack.method_7947(), testItemStack.method_7947());
                    checkedIndices.add(j);
                    if (amount != itemStack.method_7947()) {
                        itemStack.method_7934(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertItemsIntoOutputSlots(int index) {
        class_1799 resultItemStack;
        if (this.craftingRecipe[index] == null) {
            return false;
        }
        class_1277 patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.method_5439(); ++i) {
            copyOfPatternSlots.method_5447(i, patternSlotsForRecipe.method_5438(i));
        }
        ArrayList<class_1799> outputItemStacks = new ArrayList<class_1799>(10);
        class_1799 class_17992 = resultItemStack = this.craftingRecipe[index].comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe[index].comp_1933()).method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe[index].comp_1933()).method_8110(this.field_11863.method_30349());
        if (!resultItemStack.method_7960()) {
            outputItemStacks.add(resultItemStack);
        }
        for (class_1799 remainingItem : ((class_3955)this.craftingRecipe[index].comp_1933()).method_8111((class_1263)copyOfPatternSlots)) {
            if (remainingItem.method_7960()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<class_1799> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(27);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(27);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            class_1799 itemStack = itemStacks.get(i);
            for (int j = 0; j < this.internalInventory.method_5439(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                class_1799 testItemStack = this.internalInventory.method_5438(j);
                if (testItemStack.method_7960()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                int amount = Math.min(itemStack.method_7947(), testItemStack.method_7914() - testItemStack.method_7947());
                if (amount + testItemStack.method_7947() == testItemStack.method_7914()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.method_7947()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack.method_7934(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int emptyIndex = (Integer)emptyIndices.remove(0);
            if (itemStack.method_7947() == itemStack.method_7914()) {
                checkedIndices.add(emptyIndex);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(class_1799 itemStack) {
        for (int i = 0; i < 3; ++i) {
            class_1799 resultItemStack;
            if (this.craftingRecipe[i] == null) continue;
            class_1277 patternSlotsForRecipe = this.ignoreNBT[i] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[i]) : this.patternSlots[i];
            class_1715 copyOfPatternSlots = new class_1715(this.dummyContainerMenu, 3, 3);
            for (int j = 0; j < patternSlotsForRecipe.method_5439(); ++j) {
                copyOfPatternSlots.method_5447(j, patternSlotsForRecipe.method_5438(j));
            }
            class_1799 class_17992 = resultItemStack = this.craftingRecipe[i].comp_1933() instanceof class_1852 ? ((class_3955)this.craftingRecipe[i].comp_1933()).method_8116((class_1263)copyOfPatternSlots, this.field_11863.method_30349()) : ((class_3955)this.craftingRecipe[i].comp_1933()).method_8110(this.field_11863.method_30349());
            if (class_1799.method_7984((class_1799)itemStack, (class_1799)resultItemStack) && class_1799.method_31577((class_1799)itemStack, (class_1799)resultItemStack)) {
                return true;
            }
            for (class_1799 remainingItem : ((class_3955)this.craftingRecipe[i].comp_1933()).method_8111((class_1263)copyOfPatternSlots)) {
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)remainingItem) || !class_1799.method_31577((class_1799)itemStack, (class_1799)remainingItem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInput(class_1799 itemStack) {
        for (int i = 0; i < 3; ++i) {
            if (this.craftingRecipe[i] == null) continue;
            for (int j = 0; j < this.patternSlots[i].method_5439(); ++j) {
                if (!(this.ignoreNBT[i] ? class_1799.method_7984((class_1799)itemStack, (class_1799)this.patternSlots[i].method_5438(j)) : class_1799.method_7984((class_1799)itemStack, (class_1799)this.patternSlots[i].method_5438(j)) && class_1799.method_31577((class_1799)itemStack, (class_1799)this.patternSlots[i].method_5438(j)))) continue;
                return true;
            }
        }
        return false;
    }

    private class_1277 replaceCraftingPatternWithCurrentNBTItems(class_1277 container) {
        class_1277 copyOfContainer = new class_1277(container.method_5439());
        for (int i = 0; i < container.method_5439(); ++i) {
            copyOfContainer.method_5447(i, container.method_5438(i).method_7972());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.method_5439(); ++i) {
            int usedCount;
            class_1799 testItemStack;
            int j;
            class_1799 itemStack = copyOfContainer.method_5438(i);
            if (itemStack.method_7960()) continue;
            for (j = 0; j < this.internalInventory.method_5439(); ++j) {
                testItemStack = this.internalInventory.method_5438(j).method_7972();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.method_7939(testItemStack.method_7947() - usedCount);
                if (testItemStack.method_7947() <= 0 || !class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack) || !class_1799.method_31577((class_1799)itemStack, (class_1799)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.internalInventory.method_5439(); ++j) {
                testItemStack = this.internalInventory.method_5438(j).method_7972();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.method_7939(testItemStack.method_7947() - usedCount);
                if (testItemStack.method_7947() <= 0 || !class_1799.method_7984((class_1799)itemStack, (class_1799)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.method_5447(i, testItemStack.method_46651(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<class_8786<class_3955>> getRecipesFor(class_1715 patternSlots, class_1937 level) {
        return level.method_8433().method_30027(class_3956.field_17545).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.comp_1932())).filter(recipe -> ((class_3955)recipe.comp_1933()).method_8115((class_1263)patternSlots, level)).sorted(Comparator.comparing(recipe -> ((class_3955)recipe.comp_1933()).method_8110(level.method_30349()).method_7922())).toList();
    }

    private Optional<Pair<class_2960, class_8786<class_3955>>> getRecipeFor(class_1715 patternSlots, class_1937 level, class_2960 recipeId) {
        List<class_8786<class_3955>> recipes = this.getRecipesFor(patternSlots, level);
        Optional<class_8786> recipe = recipes.stream().filter(r -> r.comp_1932().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.comp_1932(), (Object)r));
    }

    public void setCurrentRecipeIndex(int currentRecipeIndex) {
        if (currentRecipeIndex < 0 || currentRecipeIndex >= 3) {
            currentRecipeIndex = 0;
        }
        this.currentRecipeIndex = currentRecipeIndex;
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT[this.currentRecipeIndex] = ignoreNBT;
        this.updateRecipe(this.currentRecipeIndex);
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AdvancedAutoCrafterBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
                break;
            }
            case 1: {
                this.setSecondaryExtractMode(checked);
            }
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

