/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.AdvancedBatteryBoxMenu;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class AdvancedBatteryBoxBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_ADVANCED_BATTERY_BOX_CAPACITY.getValue();
    public static final long MAX_TRANSFER = ModConfigs.COMMON_ADVANCED_BATTERY_BOX_TRANSFER_RATE.getValue();
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

        protected void onFinalCommit() {
            AdvancedBatteryBoxBlockEntity.this.method_5431();
            if (AdvancedBatteryBoxBlockEntity.this.field_11863 != null && !AdvancedBatteryBoxBlockEntity.this.field_11863.method_8608()) {
                class_2540 buffer = PacketByteBufs.create();
                buffer.method_52974(this.amount);
                buffer.method_52974(this.capacity);
                buffer.method_10807(AdvancedBatteryBoxBlockEntity.this.method_11016());
                ModMessages.sendServerPacketToPlayersWithinXBlocks(AdvancedBatteryBoxBlockEntity.this.method_11016(), (class_3218)AdvancedBatteryBoxBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
            }
        }
    };

    public AdvancedBatteryBoxBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_BATTERY_BOX_ENTITY, blockPos, blockState);
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_TRANSFER, MAX_TRANSFER);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.advanced_battery_box");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new AdvancedBatteryBoxMenu(id, this, inventory);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        return EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedBatteryBoxBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        AdvancedBatteryBoxBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedBatteryBoxBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        LinkedList<EnergyStorage> consumerItems = new LinkedList<EnergyStorage>();
        LinkedList<Long> consumerEnergyValues = new LinkedList<Long>();
        int consumptionSum = 0;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage energyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !energyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = energyStorage.insert(Math.min(MAX_TRANSFER, blockEntity.internalEnergyStorage.amount), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum = (int)((long)consumptionSum + received);
                consumerItems.add(energyStorage);
                consumerEnergyValues.add(received);
            }
        }
        LinkedList<Long> consumerEnergyDistributed = new LinkedList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(MAX_TRANSFER, Math.min(blockEntity.internalEnergyStorage.amount, (long)consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

