/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.AdvancedChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.screen.AdvancedChargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class AdvancedChargerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT.getValue() * 3L;
    public static final long MAX_RECEIVE_PER_SLOT = ModConfigs.COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT.getValue();
    public static final long MAX_RECEIVE = MAX_RECEIVE_PER_SLOT * 3L;
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    final CachedSidedInventoryStorage<AdvancedChargerBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private long[] energyConsumptionLeft = new long[]{-1L, -1L, -1L};
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public AdvancedChargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_CHARGER_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(3){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (AdvancedChargerBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(AdvancedChargerBlockEntity.this.field_11863, ChargerRecipe.Type.INSTANCE, stack)) {
                    return true;
                }
                if (slot >= 0 && slot < 3) {
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                        return false;
                    }
                    EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                    if (energyStorage == null) {
                        return false;
                    }
                    return energyStorage.supportsInsertion();
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || EnergyStorageUtil.isEnergyStorage((class_1799)stack) && EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)))) {
                        AdvancedChargerBlockEntity.this.resetProgress(slot);
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AdvancedChargerBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 3).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> true, i -> {
            if (i < 0 || i > 2) {
                return false;
            }
            class_1799 itemStack = this.internalInventory.method_5438(i.intValue());
            if (this.field_11863 != null && RecipeUtils.isResultOfAny(this.field_11863, ChargerRecipe.Type.INSTANCE, itemStack)) {
                return true;
            }
            if (this.field_11863 == null || RecipeUtils.isIngredientOfAny(this.field_11863, ChargerRecipe.Type.INSTANCE, itemStack)) {
                return false;
            }
            if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack)) {
                return true;
            }
            EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.internalInventory, null).getSlots().get((int)i))));
            if (energyStorage == null) {
                return true;
            }
            if (!energyStorage.supportsInsertion()) {
                return true;
            }
            return energyStorage.getAmount() == energyStorage.getCapacity();
        });
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                AdvancedChargerBlockEntity.this.method_5431();
                if (AdvancedChargerBlockEntity.this.field_11863 != null && !AdvancedChargerBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(AdvancedChargerBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(AdvancedChargerBlockEntity.this.method_11016(), (class_3218)AdvancedChargerBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1, 2, 3 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[0], index);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[1], index - 4);
                    case 8, 9, 10, 11 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[2], index - 8);
                    case 12 -> AdvancedChargerBlockEntity.this.redstoneMode.ordinal();
                    case 13 -> AdvancedChargerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 12: {
                        AdvancedChargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 13: {
                        AdvancedChargerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 14;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.advanced_charger");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new AdvancedChargerMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        for (int i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.energy_consumption_left." + i, (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft[i]));
        }
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        for (int i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.method_10537("recipe.energy_consumption_left." + i);
        }
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedChargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AdvancedChargerBlock.POWERED))) {
            return;
        }
        long maxReceivePerSlot = (long)Math.min((double)MAX_RECEIVE_PER_SLOT, Math.ceil((double)blockEntity.internalEnergyStorage.amount / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                long energyConsumptionPerTick;
                class_1799 stack = blockEntity.internalInventory.method_5438(i);
                class_1277 inventory = new class_1277(1);
                inventory.method_5447(0, blockEntity.internalInventory.method_5438(i));
                Optional recipe = level.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_1263)inventory, level);
                if (recipe.isPresent()) {
                    if (blockEntity.energyConsumptionLeft[i] == -1L) {
                        blockEntity.energyConsumptionLeft[i] = (long)((float)((ChargerRecipe)((class_8786)recipe.get()).comp_1933()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                    }
                    if (blockEntity.internalEnergyStorage.amount == 0L) {
                        AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, blockEntity.internalEnergyStorage.amount));
                } else {
                    EnergyStorage energyStorage;
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack) || (energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.internalInventory, null).getSlots().get(i))))) == null || !energyStorage.supportsInsertion()) continue;
                    blockEntity.energyConsumptionLeft[i] = energyStorage.getCapacity() - energyStorage.getAmount();
                    if (blockEntity.internalEnergyStorage.amount == 0L) {
                        AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    try (Transaction transaction = Transaction.openOuter();){
                        energyConsumptionPerTick = energyStorage.insert(Math.min(maxReceivePerSlot, blockEntity.internalEnergyStorage.amount), (TransactionContext)transaction);
                        transaction.commit();
                    }
                }
                if (blockEntity.energyConsumptionLeft[i] < 0L || energyConsumptionPerTick < 0L) {
                    blockEntity.resetProgress(i);
                    AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    energyConsumptionPerTick = blockEntity.internalEnergyStorage.extract(energyConsumptionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                int n = i;
                blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                if (blockEntity.energyConsumptionLeft[i] <= 0L) {
                    int index = i;
                    recipe.ifPresent(advancedChargerRecipe -> blockEntity.internalInventory.method_5447(index, ((ChargerRecipe)advancedChargerRecipe.comp_1933()).method_8110(level.method_30349()).method_46651(1)));
                    blockEntity.resetProgress(i);
                }
                AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(int index) {
        this.energyConsumptionLeft[index] = -1L;
    }

    private boolean hasRecipe(int index) {
        Optional recipe;
        class_1799 stack = this.internalInventory.method_5438(index);
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, this.internalInventory.method_5438(index));
        Optional optional = recipe = this.field_11863 == null ? Optional.empty() : this.field_11863.method_8433().method_8132((class_3956)ChargerRecipe.Type.INSTANCE, (class_1263)inventory, this.field_11863);
        if (recipe.isPresent()) {
            return true;
        }
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

