/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.AdvancedMinecartChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.entity.AbstractMinecartBatteryBox;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.AdvancedMinecartChargerMenu;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5575;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class AdvancedMinecartChargerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_ADVANCED_MINECART_CHARGER_CAPACITY.getValue();
    public static final long MAX_TRANSFER = ModConfigs.COMMON_ADVANCED_MINECART_CHARGER_TRANSFER_RATE.getValue();
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

        protected void onFinalCommit() {
            AdvancedMinecartChargerBlockEntity.this.method_5431();
            if (AdvancedMinecartChargerBlockEntity.this.field_11863 != null && !AdvancedMinecartChargerBlockEntity.this.field_11863.method_8608()) {
                class_2540 buffer = PacketByteBufs.create();
                buffer.method_52974(this.amount);
                buffer.method_52974(this.capacity);
                buffer.method_10807(AdvancedMinecartChargerBlockEntity.this.method_11016());
                ModMessages.sendServerPacketToPlayersWithinXBlocks(AdvancedMinecartChargerBlockEntity.this.method_11016(), (class_3218)AdvancedMinecartChargerBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
            }
        }
    };
    private boolean hasMinecartOld = true;
    private boolean hasMinecart = false;

    public AdvancedMinecartChargerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_MINECART_CHARGER_ENTITY, blockPos, blockState);
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_TRANSFER, 0L);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.advanced_minecart_charger");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new AdvancedMinecartChargerMenu(id, this, inventory);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        class_2338 blockPosFacing = this.method_11016().method_10093((class_2350)this.method_11010().method_11654((class_2769)AdvancedMinecartChargerBlock.FACING));
        List minecarts = this.field_11863.method_18023(class_5575.method_31795(AbstractMinecartBatteryBox.class), new class_238((double)blockPosFacing.method_10263(), (double)blockPosFacing.method_10264(), (double)blockPosFacing.method_10260(), (double)(blockPosFacing.method_10263() + 1), (double)(blockPosFacing.method_10264() + 1), (double)(blockPosFacing.method_10260() + 1)), class_1301.field_6154);
        if (minecarts.isEmpty()) {
            return 0;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        long minecartEnergy = minecart.getEnergy();
        boolean isEmptyFlag = minecartEnergy == 0L;
        return Math.min(class_3532.method_15375((float)((float)minecartEnergy / (float)minecart.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedMinecartChargerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.hasMinecartOld != blockEntity.hasMinecart) {
            AdvancedMinecartChargerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
        blockEntity.hasMinecartOld = blockEntity.hasMinecart;
        class_2338 blockPosFacing = blockEntity.method_11016().method_10093((class_2350)blockEntity.method_11010().method_11654((class_2769)AdvancedMinecartChargerBlock.FACING));
        List minecarts = level.method_18023(class_5575.method_31795(AbstractMinecartBatteryBox.class), new class_238((double)blockPosFacing.method_10263(), (double)blockPosFacing.method_10264(), (double)blockPosFacing.method_10260(), (double)(blockPosFacing.method_10263() + 1), (double)(blockPosFacing.method_10264() + 1), (double)(blockPosFacing.method_10260() + 1)), class_1301.field_6154);
        boolean bl = blockEntity.hasMinecart = !minecarts.isEmpty();
        if (!blockEntity.hasMinecart) {
            return;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        long transferred = Math.min(Math.min(blockEntity.energyStorage.getAmount(), MAX_TRANSFER), Math.min(minecart.getTransferRate(), minecart.getCapacity() - minecart.getEnergy()));
        minecart.setEnergy(minecart.getEnergy() + transferred);
        if (transferred < 0L) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.extract(transferred, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

