/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.AdvancedPoweredFurnaceBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.AdvancedPoweredFurnaceMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3861;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class AdvancedPoweredFurnaceBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    public static final long CAPACITY = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_TRANSFER_RATE.getValue();
    private static final long ENERGY_USAGE_PER_INPUT_PER_TICK = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_INPUT_PER_TICK.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    final CachedSidedInventoryStorage<AdvancedPoweredFurnaceBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private int[] progress = new int[]{0, 0, 0};
    private int[] maxProgress = new int[]{0, 0, 0};
    private long[] energyConsumptionLeft = new long[]{-1L, -1L, -1L};
    private boolean[] hasEnoughEnergy = new boolean[]{false, false, false};
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public AdvancedPoweredFurnaceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ADVANCED_POWERED_FURNACE_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(6){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(AdvancedPoweredFurnaceBlockEntity.this.field_11863, class_3956.field_17546, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3, 4, 5 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 3) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(AdvancedPoweredFurnaceBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        AdvancedPoweredFurnaceBlockEntity.this.resetProgress(slot, AdvancedPoweredFurnaceBlockEntity.this.field_11867, AdvancedPoweredFurnaceBlockEntity.this.field_11863.method_8320(AdvancedPoweredFurnaceBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AdvancedPoweredFurnaceBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 6).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i >= 0 && i < 3, i -> i >= 3 && i < 6);
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                AdvancedPoweredFurnaceBlockEntity.this.method_5431();
                if (AdvancedPoweredFurnaceBlockEntity.this.field_11863 != null && !AdvancedPoweredFurnaceBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(AdvancedPoweredFurnaceBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(AdvancedPoweredFurnaceBlockEntity.this.method_11016(), (class_3218)AdvancedPoweredFurnaceBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1, 2, 3 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[0], index);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[1], index - 4);
                    case 8, 9, 10, 11 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.energyConsumptionLeft[2], index - 8);
                    case 12, 13 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[0], index - 12);
                    case 14, 15 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0], index - 14);
                    case 16, 17 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[1], index - 16);
                    case 18, 19 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1], index - 18);
                    case 20, 21 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[2], index - 20);
                    case 22, 23 -> ByteUtils.get2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2], index - 22);
                    case 24 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[0]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 25 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[1]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 26 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.hasEnoughEnergy[2]) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 27 -> AdvancedPoweredFurnaceBlockEntity.this.redstoneMode.ordinal();
                    case 28 -> AdvancedPoweredFurnaceBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 12: 
                    case 13: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[0] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[0], (short)value, index - 12);
                        break;
                    }
                    case 14: 
                    case 15: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[0], (short)value, index - 14);
                        break;
                    }
                    case 16: 
                    case 17: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[1] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[1], (short)value, index - 16);
                        break;
                    }
                    case 18: 
                    case 19: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[1], (short)value, index - 18);
                        break;
                    }
                    case 20: 
                    case 21: {
                        AdvancedPoweredFurnaceBlockEntity.this.progress[2] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.progress[2], (short)value, index - 20);
                        break;
                    }
                    case 22: 
                    case 23: {
                        AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2] = ByteUtils.with2Bytes(AdvancedPoweredFurnaceBlockEntity.this.maxProgress[2], (short)value, index - 22);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: 
                    case 25: 
                    case 26: {
                        break;
                    }
                    case 27: {
                        AdvancedPoweredFurnaceBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 28: {
                        AdvancedPoweredFurnaceBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 29;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.advanced_powered_furnace");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new AdvancedPoweredFurnaceMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        int i;
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.progress." + i, (class_2520)class_2497.method_23247((int)this.progress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.max_progress." + i, (class_2520)class_2497.method_23247((int)this.maxProgress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.method_10566("recipe.energy_consumption_left." + i, (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft[i]));
        }
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        int i;
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        for (i = 0; i < 3; ++i) {
            this.progress[i] = nbt.method_10550("recipe.progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.maxProgress[i] = nbt.method_10550("recipe.max_progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.method_10537("recipe.energy_consumption_left." + i);
        }
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AdvancedPoweredFurnaceBlock.POWERED))) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (AdvancedPoweredFurnaceBlockEntity.hasRecipe(i, blockEntity)) {
                class_1277 inventory = new class_1277(2);
                inventory.method_5447(0, blockEntity.internalInventory.method_5438(i));
                inventory.method_5447(1, blockEntity.internalInventory.method_5438(3 + i));
                Optional<class_8786<class_3861>> recipe = blockEntity.getRecipeFor((class_1263)inventory, level);
                if (recipe.isEmpty()) continue;
                int cookingTime = ((class_3861)recipe.get().comp_1933()).method_8167();
                if (blockEntity.maxProgress[i] == 0) {
                    blockEntity.maxProgress[i] = (int)Math.ceil((float)cookingTime * RECIPE_DURATION_MULTIPLIER / 12.0f);
                }
                if (blockEntity.energyConsumptionLeft[i] < 0L) {
                    blockEntity.energyConsumptionLeft[i] = ENERGY_USAGE_PER_INPUT_PER_TICK * (long)blockEntity.maxProgress[i];
                }
                if (ENERGY_USAGE_PER_INPUT_PER_TICK <= blockEntity.internalEnergyStorage.amount) {
                    if (!level.method_8320(blockPos).method_28498((class_2769)AdvancedPoweredFurnaceBlock.LIT) || !((Boolean)level.method_8320(blockPos).method_11654((class_2769)AdvancedPoweredFurnaceBlock.LIT)).booleanValue()) {
                        blockEntity.hasEnoughEnergy[i] = true;
                        level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)AdvancedPoweredFurnaceBlock.LIT, (Comparable)Boolean.TRUE), 3);
                    }
                    if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0L) {
                        blockEntity.resetProgress(i, blockPos, state);
                        AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        continue;
                    }
                    try (Transaction transaction = Transaction.openOuter();){
                        blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_INPUT_PER_TICK, (TransactionContext)transaction);
                        transaction.commit();
                    }
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - ENERGY_USAGE_PER_INPUT_PER_TICK;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        AdvancedPoweredFurnaceBlockEntity.craftItem(i, blockPos, state, blockEntity);
                    }
                    AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                continue;
            }
            blockEntity.resetProgress(i, blockPos, state);
            AdvancedPoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(int index, class_2338 blockPos, class_2680 state) {
        this.progress[index] = 0;
        this.maxProgress[index] = 0;
        this.energyConsumptionLeft[index] = -1L;
        this.hasEnoughEnergy[index] = true;
        for (int i = 0; i < this.energyConsumptionLeft.length; ++i) {
            if (this.energyConsumptionLeft[0] <= -1L) continue;
            return;
        }
        this.field_11863.method_8652(blockPos, (class_2680)state.method_11657((class_2769)AdvancedPoweredFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
    }

    private static void craftItem(int index, class_2338 blockPos, class_2680 state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        class_1277 inventory = new class_1277(2);
        inventory.method_5447(0, blockEntity.internalInventory.method_5438(index));
        inventory.method_5447(1, blockEntity.internalInventory.method_5438(3 + index));
        Optional<class_8786<class_3861>> recipe = blockEntity.getRecipeFor((class_1263)inventory, level);
        if (!AdvancedPoweredFurnaceBlockEntity.hasRecipe(index, blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.internalInventory.method_5434(index, 1);
        blockEntity.internalInventory.method_5447(3 + index, ((class_3861)recipe.get().comp_1933()).method_8110(level.method_30349()).method_46651(blockEntity.internalInventory.method_5438(3 + index).method_7947() + ((class_3861)recipe.get().comp_1933()).method_8110(level.method_30349()).method_7947()));
        blockEntity.resetProgress(index, blockPos, state);
    }

    private static boolean hasRecipe(int index, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        class_1277 inventory = new class_1277(2);
        inventory.method_5447(0, blockEntity.internalInventory.method_5438(index));
        inventory.method_5447(1, blockEntity.internalInventory.method_5438(3 + index));
        Optional<class_8786<class_3861>> recipe = blockEntity.getRecipeFor((class_1263)inventory, level);
        return recipe.isPresent() && AdvancedPoweredFurnaceBlockEntity.canInsertItemIntoOutputSlot(index, blockEntity.internalInventory, ((class_3861)recipe.get().comp_1933()).method_8110(level.method_30349()));
    }

    private static boolean canInsertItemIntoOutputSlot(int index, class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(3 + index);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    private Optional<class_8786<class_3861>> getRecipeFor(class_1263 container, class_1937 level) {
        return level.method_8433().method_30027(class_3956.field_17546).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.comp_1932())).filter(recipe -> ((class_3861)recipe.comp_1933()).method_8115(container, level)).findFirst();
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

