/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.recipe.AssemblingMachineRecipe;
import me.jddev0.ep.screen.AssemblingMachineMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class AssemblingMachineBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    private static final long CAPACITY = ModConfigs.COMMON_ASSEMBLING_MACHINE_CAPACITY.getValue();
    private static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_ASSEMBLING_MACHINE_ENERGY_CONSUMPTION_PER_TICK.getValue();
    final CachedSidedInventoryStorage<AssemblingMachineBlockEntity> cachedSidedInventoryStorageTopBottom;
    final InputOutputItemHandler sidedInventoryTopBottom;
    final CachedSidedInventoryStorage<AssemblingMachineBlockEntity> cachedSidedInventoryStorageFront;
    final InputOutputItemHandler sidedInventoryFront;
    final CachedSidedInventoryStorage<AssemblingMachineBlockEntity> cachedSidedInventoryStorageBack;
    final InputOutputItemHandler sidedInventoryBack;
    final CachedSidedInventoryStorage<AssemblingMachineBlockEntity> cachedSidedInventoryStorageLeft;
    final InputOutputItemHandler sidedInventoryLeft;
    final CachedSidedInventoryStorage<AssemblingMachineBlockEntity> cachedSidedInventoryStorageRight;
    final InputOutputItemHandler sidedInventoryRight;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_ASSEMBLING_MACHINE_RECIPE_DURATION.getValue();
    private long energyConsumptionLeft = -1L;
    private boolean hasEnoughEnergy;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public AssemblingMachineBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ASSEMBLING_MACHINE_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(5){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1, 2, 3 -> {
                        if (AssemblingMachineBlockEntity.this.field_11863 == null || AssemblingMachineBlockEntity.this.field_11863.method_8433().method_30027((class_3956)AssemblingMachineRecipe.Type.INSTANCE).stream().map(class_8786::comp_1933).map(AssemblingMachineRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(AssemblingMachineRecipe.IngredientWithCount::input).anyMatch(ingredient -> ingredient.method_8093(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot >= 0 && slot < 4) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(AssemblingMachineBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        AssemblingMachineBlockEntity.this.resetProgress(AssemblingMachineBlockEntity.this.field_11867, AssemblingMachineBlockEntity.this.field_11863.method_8320(AssemblingMachineBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                AssemblingMachineBlockEntity.this.method_5431();
            }
        };
        this.sidedInventoryTopBottom = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 5).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i >= 0 && i < 4, i -> i == 4);
        this.cachedSidedInventoryStorageTopBottom = new CachedSidedInventoryStorage(this.sidedInventoryTopBottom);
        this.sidedInventoryFront = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 5).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 3, i -> i == 4);
        this.cachedSidedInventoryStorageFront = new CachedSidedInventoryStorage(this.sidedInventoryFront);
        this.sidedInventoryBack = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 5).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 0, i -> i == 4);
        this.cachedSidedInventoryStorageBack = new CachedSidedInventoryStorage(this.sidedInventoryBack);
        this.sidedInventoryLeft = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 5).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 1, i -> i == 4);
        this.cachedSidedInventoryStorageLeft = new CachedSidedInventoryStorage(this.sidedInventoryLeft);
        this.sidedInventoryRight = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 5).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 2, i -> i == 4);
        this.cachedSidedInventoryStorageRight = new CachedSidedInventoryStorage(this.sidedInventoryRight);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                AssemblingMachineBlockEntity.this.method_5431();
                if (AssemblingMachineBlockEntity.this.field_11863 != null && !AssemblingMachineBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(AssemblingMachineBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(AssemblingMachineBlockEntity.this.method_11016(), (class_3218)AssemblingMachineBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, ModConfigs.COMMON_ASSEMBLING_MACHINE_TRANSFER_RATE.getValue().longValue(), 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AssemblingMachineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(AssemblingMachineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(AssemblingMachineBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (AssemblingMachineBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> AssemblingMachineBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> AssemblingMachineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AssemblingMachineBlockEntity.this.progress = ByteUtils.with2Bytes(AssemblingMachineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AssemblingMachineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(AssemblingMachineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        AssemblingMachineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        AssemblingMachineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    public Storage<ItemVariant> getInventoryStorageForDirection(class_2350 side) {
        if (side == null) {
            return null;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)AssemblingMachineBlock.FACING);
        if (facing == side) {
            return this.cachedSidedInventoryStorageFront.apply(side);
        }
        if (facing.method_10153() == side) {
            return this.cachedSidedInventoryStorageBack.apply(side);
        }
        if (facing.method_10170() == side) {
            return this.cachedSidedInventoryStorageLeft.apply(side);
        }
        if (facing.method_10160() == side) {
            return this.cachedSidedInventoryStorageRight.apply(side);
        }
        return this.cachedSidedInventoryStorageTopBottom.apply(side);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.assembling_machine");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new AssemblingMachineMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.progress = nbt.method_10550("recipe.progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, AssemblingMachineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)AssemblingMachineBlock.POWERED))) {
            return;
        }
        if (AssemblingMachineBlockEntity.hasRecipe(blockEntity)) {
            Optional recipe = level.method_8433().method_8132((class_3956)AssemblingMachineRecipe.Type.INSTANCE, (class_1263)blockEntity.internalInventory, level);
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * (long)blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.internalEnergyStorage.amount) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    AssemblingMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_TICK, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    AssemblingMachineBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                AssemblingMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                AssemblingMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            AssemblingMachineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = true;
    }

    private static void craftItem(class_2338 blockPos, class_2680 state, AssemblingMachineBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional recipe = level.method_8433().method_8132((class_3956)AssemblingMachineRecipe.Type.INSTANCE, (class_1263)blockEntity.internalInventory, level);
        if (!AssemblingMachineBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        AssemblingMachineRecipe.IngredientWithCount[] inputs = ((AssemblingMachineRecipe)((class_8786)recipe.get()).comp_1933()).getInputs();
        boolean[] usedIndices = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            usedIndices[i] = blockEntity.internalInventory.method_5438(i).method_7960();
        }
        int len = Math.min(inputs.length, 4);
        for (int i = 0; i < len; ++i) {
            AssemblingMachineRecipe.IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                if (usedIndices[j]) continue;
                class_1799 item = blockEntity.internalInventory.method_5438(j);
                if (indexMinCount != -1 && item.method_7947() >= minCount || !input.input().method_8093(item) || item.method_7947() < input.count()) continue;
                indexMinCount = j;
                minCount = item.method_7947();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            blockEntity.internalInventory.method_5434(indexMinCount, input.count());
        }
        blockEntity.internalInventory.method_5447(4, ((AssemblingMachineRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(level.method_30349()).method_46651(blockEntity.internalInventory.method_5438(4).method_7947() + ((AssemblingMachineRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(level.method_30349()).method_7947()));
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(AssemblingMachineBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional recipe = level.method_8433().method_8132((class_3956)AssemblingMachineRecipe.Type.INSTANCE, (class_1263)blockEntity.internalInventory, level);
        return recipe.isPresent() && AssemblingMachineBlockEntity.canInsertItemIntoOutputSlot(blockEntity.internalInventory, ((AssemblingMachineRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(level.method_30349()));
    }

    private static boolean canInsertItemIntoOutputSlot(class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(4);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

