/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.stream.IntStream;
import me.jddev0.ep.block.BlockPlacerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.BlockPlacerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class BlockPlacerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate,
CheckboxUpdate {
    private static final List<@NotNull class_2960> PLACEMENT_BLACKLIST = ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_BLACKLIST.getValue();
    public static final long CAPACITY = ModConfigs.COMMON_BLOCK_PLACER_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_BLOCK_PLACER_TRANSFER_RATE.getValue();
    private static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_BLOCK_PLACER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    final CachedSidedInventoryStorage<BlockPlacerBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_DURATION.getValue();
    private long energyConsumptionLeft = -1L;
    private boolean hasEnoughEnergy;
    private boolean inverseRotation;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public BlockPlacerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.BLOCK_PLACER_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(1){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return stack.method_7909() instanceof class_1747;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(BlockPlacerBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        BlockPlacerBlockEntity.this.resetProgress(BlockPlacerBlockEntity.this.field_11867, BlockPlacerBlockEntity.this.field_11863.method_8320(BlockPlacerBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                BlockPlacerBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 1).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> true, i -> false);
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                BlockPlacerBlockEntity.this.method_5431();
                if (BlockPlacerBlockEntity.this.field_11863 != null && !BlockPlacerBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(BlockPlacerBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(BlockPlacerBlockEntity.this.method_11016(), (class_3218)BlockPlacerBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (BlockPlacerBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> {
                        if (BlockPlacerBlockEntity.this.inverseRotation) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 10 -> BlockPlacerBlockEntity.this.redstoneMode.ordinal();
                    case 11 -> BlockPlacerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        BlockPlacerBlockEntity.this.progress = ByteUtils.with2Bytes(BlockPlacerBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        BlockPlacerBlockEntity.this.maxProgress = ByteUtils.with2Bytes(BlockPlacerBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        BlockPlacerBlockEntity.this.inverseRotation = value != 0;
                        break;
                    }
                    case 10: {
                        BlockPlacerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 11: {
                        BlockPlacerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 12;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.block_placer");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new BlockPlacerMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
        nbt.method_10556("inverse_rotation", this.inverseRotation);
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.progress = nbt.method_10550("recipe.progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
        this.inverseRotation = nbt.method_10577("inverse_rotation");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, BlockPlacerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)BlockPlacerBlock.POWERED))) {
            return;
        }
        if (BlockPlacerBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * (long)blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.internalEnergyStorage.amount) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    BlockPlacerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_TICK, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                if (blockEntity.progress < blockEntity.maxProgress) {
                    ++blockEntity.progress;
                }
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    class_2350 direction;
                    class_1799 itemStack = blockEntity.internalInventory.method_5438(0);
                    if (itemStack.method_7960()) {
                        blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK;
                        BlockPlacerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        return;
                    }
                    class_2338 blockPosPlacement = blockEntity.method_11016().method_10093((class_2350)blockEntity.method_11010().method_11654((class_2769)BlockPlacerBlock.FACING));
                    class_1747 blockItem = (class_1747)itemStack.method_7909();
                    if (blockEntity.inverseRotation) {
                        direction = switch ((class_2350)state.method_11654((class_2769)BlockPlacerBlock.FACING)) {
                            default -> throw new IncompatibleClassChangeError();
                            case class_2350.field_11033 -> class_2350.field_11036;
                            case class_2350.field_11036 -> class_2350.field_11033;
                            case class_2350.field_11043 -> class_2350.field_11035;
                            case class_2350.field_11035 -> class_2350.field_11043;
                            case class_2350.field_11039 -> class_2350.field_11034;
                            case class_2350.field_11034 -> class_2350.field_11039;
                        };
                    } else {
                        direction = (class_2350)state.method_11654((class_2769)BlockPlacerBlock.FACING);
                    }
                    class_1269 result = blockItem.method_7712((class_1750)new class_2968(level, blockPosPlacement, direction, itemStack, direction){

                        @NotNull
                        public class_2350 method_7715() {
                            return direction;
                        }

                        @NotNull
                        public @NotNull class_2350 @NotNull [] method_7718() {
                            class_2350[] class_2350Array;
                            switch (direction) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case field_11033: {
                                    class_2350[] class_2350Array2 = new class_2350[6];
                                    class_2350Array2[0] = class_2350.field_11033;
                                    class_2350Array2[1] = class_2350.field_11043;
                                    class_2350Array2[2] = class_2350.field_11034;
                                    class_2350Array2[3] = class_2350.field_11035;
                                    class_2350Array2[4] = class_2350.field_11039;
                                    class_2350Array = class_2350Array2;
                                    class_2350Array2[5] = class_2350.field_11036;
                                    break;
                                }
                                case field_11036: {
                                    class_2350[] class_2350Array3 = new class_2350[6];
                                    class_2350Array3[0] = class_2350.field_11036;
                                    class_2350Array3[1] = class_2350.field_11033;
                                    class_2350Array3[2] = class_2350.field_11043;
                                    class_2350Array3[3] = class_2350.field_11034;
                                    class_2350Array3[4] = class_2350.field_11035;
                                    class_2350Array = class_2350Array3;
                                    class_2350Array3[5] = class_2350.field_11039;
                                    break;
                                }
                                case field_11043: {
                                    class_2350[] class_2350Array4 = new class_2350[6];
                                    class_2350Array4[0] = class_2350.field_11043;
                                    class_2350Array4[1] = class_2350.field_11034;
                                    class_2350Array4[2] = class_2350.field_11039;
                                    class_2350Array4[3] = class_2350.field_11036;
                                    class_2350Array4[4] = class_2350.field_11033;
                                    class_2350Array = class_2350Array4;
                                    class_2350Array4[5] = class_2350.field_11035;
                                    break;
                                }
                                case field_11035: {
                                    class_2350[] class_2350Array5 = new class_2350[6];
                                    class_2350Array5[0] = class_2350.field_11035;
                                    class_2350Array5[1] = class_2350.field_11034;
                                    class_2350Array5[2] = class_2350.field_11039;
                                    class_2350Array5[3] = class_2350.field_11036;
                                    class_2350Array5[4] = class_2350.field_11033;
                                    class_2350Array = class_2350Array5;
                                    class_2350Array5[5] = class_2350.field_11043;
                                    break;
                                }
                                case field_11039: {
                                    class_2350[] class_2350Array6 = new class_2350[6];
                                    class_2350Array6[0] = class_2350.field_11039;
                                    class_2350Array6[1] = class_2350.field_11035;
                                    class_2350Array6[2] = class_2350.field_11036;
                                    class_2350Array6[3] = class_2350.field_11033;
                                    class_2350Array6[4] = class_2350.field_11043;
                                    class_2350Array = class_2350Array6;
                                    class_2350Array6[5] = class_2350.field_11034;
                                    break;
                                }
                                case field_11034: {
                                    class_2350[] class_2350Array7 = new class_2350[6];
                                    class_2350Array7[0] = class_2350.field_11034;
                                    class_2350Array7[1] = class_2350.field_11035;
                                    class_2350Array7[2] = class_2350.field_11036;
                                    class_2350Array7[3] = class_2350.field_11033;
                                    class_2350Array7[4] = class_2350.field_11043;
                                    class_2350Array = class_2350Array7;
                                    class_2350Array7[5] = class_2350.field_11039;
                                }
                            }
                            return class_2350Array;
                        }

                        public boolean method_7717() {
                            return false;
                        }
                    });
                    if (result == class_1269.field_5814) {
                        blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK;
                        BlockPlacerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                        return;
                    }
                    blockEntity.internalInventory.method_5447(0, itemStack);
                    blockEntity.resetProgress(blockPos, state);
                }
                BlockPlacerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                BlockPlacerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            BlockPlacerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = true;
    }

    private static boolean hasRecipe(BlockPlacerBlockEntity blockEntity) {
        class_1799 itemStack = blockEntity.internalInventory.method_5438(0);
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItemStack = (class_1747)class_17922;
        return !PLACEMENT_BLACKLIST.contains(class_7923.field_41175.method_10221((Object)blockItemStack.method_7711()));
    }

    public void setInverseRotation(boolean inverseRotation) {
        this.inverseRotation = inverseRotation;
        BlockPlacerBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setInverseRotation(checked);
            }
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

