/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.ChargingStationMenu;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_5575;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class ChargingStationBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_CHARGING_STATION_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_CHARGING_STATION_TRANSFER_RATE.getValue();
    public static final int MAX_CHARGING_DISTANCE = ModConfigs.COMMON_CHARGING_STATION_MAX_CHARGING_DISTANCE.getValue();
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

        protected void onFinalCommit() {
            ChargingStationBlockEntity.this.method_5431();
            if (ChargingStationBlockEntity.this.field_11863 != null && !ChargingStationBlockEntity.this.field_11863.method_8608()) {
                class_2540 buffer = PacketByteBufs.create();
                buffer.method_52974(this.amount);
                buffer.method_52974(this.capacity);
                buffer.method_10807(ChargingStationBlockEntity.this.method_11016());
                ModMessages.sendServerPacketToPlayersWithinXBlocks(ChargingStationBlockEntity.this.method_11016(), (class_3218)ChargingStationBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
            }
        }
    };

    public ChargingStationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.CHARGING_STATION_ENTITY, blockPos, blockState);
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.charging_station");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new ChargingStationMenu(id, this, inventory);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ChargingStationBlockEntity blockEntity) {
        long energyPerTick;
        if (level.method_8608()) {
            return;
        }
        List players = level.method_18023(class_5575.method_31795(class_1657.class), class_238.method_19316((class_3341)class_3341.method_34390((class_2382)new class_2382(blockPos.method_10263() - MAX_CHARGING_DISTANCE, blockPos.method_10264() - MAX_CHARGING_DISTANCE, blockPos.method_10260() - MAX_CHARGING_DISTANCE), (class_2382)new class_2382(blockPos.method_10263() + MAX_CHARGING_DISTANCE, blockPos.method_10264() + MAX_CHARGING_DISTANCE, blockPos.method_10260() + MAX_CHARGING_DISTANCE))), class_1301.field_6155.and(entity -> entity.method_5707(blockPos.method_46558()) <= (double)(MAX_CHARGING_DISTANCE * MAX_CHARGING_DISTANCE)));
        long energyPerTickLeft = energyPerTick = Math.min(MAX_RECEIVE, blockEntity.internalEnergyStorage.amount);
        block10: for (class_1657 player : players) {
            if (player.method_29504()) continue;
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                EnergyStorage energyStorage;
                class_1799 itemStack = inventory.method_5438(i);
                if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack) || (energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofPlayerSlot((class_1657)inventory.field_7546, (SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(i))))) == null || !energyStorage.supportsInsertion()) continue;
                try (Transaction transaction = Transaction.openOuter();){
                    energyPerTickLeft -= energyStorage.insert(energyPerTickLeft, (TransactionContext)transaction);
                    transaction.commit();
                    if (energyPerTickLeft != 0L) continue;
                    break block10;
                }
            }
        }
        if (energyPerTickLeft == energyPerTick) {
            if (!level.method_8320(blockPos).method_28498((class_2769)ChargingStationBlock.CHARGING) || ((Boolean)level.method_8320(blockPos).method_11654((class_2769)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)ChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            if (!level.method_8320(blockPos).method_28498((class_2769)ChargingStationBlock.CHARGING) || !((Boolean)level.method_8320(blockPos).method_11654((class_2769)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)ChargingStationBlock.CHARGING, (Comparable)Boolean.TRUE), 3);
            }
            try (Transaction transaction = Transaction.openOuter();){
                blockEntity.internalEnergyStorage.extract(energyPerTick - energyPerTickLeft, (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

