/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import java.util.stream.IntStream;
import me.jddev0.ep.block.CoalEngineBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.CoalEngineMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class CoalEngineBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_COAL_ENGINE_CAPACITY.getValue();
    public static final long MAX_EXTRACT = ModConfigs.COMMON_COAL_ENGINE_TRANSFER_RATE.getValue();
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue();
    final CachedSidedInventoryStorage<CoalEngineBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress;
    private long energyProductionLeft = -1L;
    private boolean hasEnoughCapacityForProduction;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public CoalEngineBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.COAL_ENGINE_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(1){

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
                    return burnTime != null && burnTime > 0;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                CoalEngineBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 1).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 item = this.internalInventory.method_5438(i.intValue());
            Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
            return burnTime == null || burnTime <= 0;
        });
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                CoalEngineBlockEntity.this.method_5431();
                if (CoalEngineBlockEntity.this.field_11863 != null && !CoalEngineBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(CoalEngineBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(CoalEngineBlockEntity.this.method_11016(), (class_3218)CoalEngineBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, 0L, MAX_EXTRACT);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(CoalEngineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(CoalEngineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(CoalEngineBlockEntity.this.energyProductionLeft, index - 4);
                    case 8 -> {
                        if (CoalEngineBlockEntity.this.hasEnoughCapacityForProduction) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> CoalEngineBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> CoalEngineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        CoalEngineBlockEntity.this.progress = ByteUtils.with2Bytes(CoalEngineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        CoalEngineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(CoalEngineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        CoalEngineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        CoalEngineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.coal_engine");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new CoalEngineMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.max_progress", (class_2520)class_2497.method_23247((int)this.maxProgress));
        nbt.method_10566("recipe.energy_production_left", (class_2520)class_2503.method_23251((long)this.energyProductionLeft));
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.progress = nbt.method_10550("recipe.progress");
        this.maxProgress = nbt.method_10550("recipe.max_progress");
        this.energyProductionLeft = nbt.method_10537("recipe.energy_production_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)CoalEngineBlock.POWERED))) {
            CoalEngineBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        CoalEngineBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.maxProgress > 0 || CoalEngineBlockEntity.hasRecipe(blockEntity)) {
            class_1799 item = blockEntity.internalInventory.method_5438(0);
            Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
            long energyProduction = burnTime == null ? -1L : (long)burnTime.intValue();
            energyProduction = (long)((double)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
            if (blockEntity.progress == 0) {
                blockEntity.energyProductionLeft = energyProduction;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = energyProduction / 100L <= MAX_EXTRACT ? 100 : (int)Math.ceil((double)energyProduction / (double)MAX_EXTRACT);
            }
            long energyProductionPerTick = (long)Math.ceil((double)blockEntity.energyProductionLeft / (double)(blockEntity.maxProgress - blockEntity.progress));
            if (blockEntity.progress == blockEntity.maxProgress - 1) {
                energyProductionPerTick = blockEntity.energyProductionLeft;
            }
            if (energyProductionPerTick <= blockEntity.energyStorage.getCapacity() - blockEntity.internalEnergyStorage.amount) {
                if (blockEntity.progress == 0) {
                    if (!item.getRecipeRemainder().method_7960()) {
                        blockEntity.internalInventory.method_5447(0, item.getRecipeRemainder());
                    } else {
                        blockEntity.internalInventory.method_5434(0, 1);
                    }
                }
                if (!level.method_8320(blockPos).method_28498((class_2769)CoalEngineBlock.LIT) || !((Boolean)level.method_8320(blockPos).method_11654((class_2769)CoalEngineBlock.LIT)).booleanValue()) {
                    blockEntity.hasEnoughCapacityForProduction = true;
                    level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)CoalEngineBlock.LIT, (Comparable)Boolean.TRUE), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyProductionLeft < 0L || energyProductionPerTick < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    blockEntity.internalEnergyStorage.insert(energyProductionPerTick, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyProductionLeft -= energyProductionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.resetProgress(blockPos, state);
                }
                CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughCapacityForProduction = false;
                CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            CoalEngineBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, CoalEngineBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        LinkedList<EnergyStorage> consumerItems = new LinkedList<EnergyStorage>();
        LinkedList<Long> consumerEnergyValues = new LinkedList<Long>();
        int consumptionSum = 0;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage energyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !energyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = energyStorage.insert(Math.min(MAX_EXTRACT, blockEntity.internalEnergyStorage.amount), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum = (int)((long)consumptionSum + received);
                consumerItems.add(energyStorage);
                consumerEnergyValues.add(received);
            }
        }
        LinkedList<Long> consumerEnergyDistributed = new LinkedList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(MAX_EXTRACT, Math.min(blockEntity.internalEnergyStorage.amount, (long)consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyProductionLeft = -1L;
        this.hasEnoughCapacityForProduction = true;
        this.field_11863.method_8652(blockPos, (class_2680)state.method_11657((class_2769)CoalEngineBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
    }

    private static boolean hasRecipe(CoalEngineBlockEntity blockEntity) {
        class_1799 item = blockEntity.internalInventory.method_5438(0);
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)item.method_7909());
        if (burnTime == null || burnTime <= 0) {
            return false;
        }
        return item.getRecipeRemainder().method_7960() || item.method_7947() == 1;
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

