/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.InfinityEnergyStorage;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.screen.CreativeBatteryBoxMenu;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class CreativeBatteryBoxBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
CheckboxUpdate {
    final InfinityEnergyStorage energyStorage = new InfinityEnergyStorage(){

        @Override
        public long extract(long maxAmount, TransactionContext transaction) {
            if (CreativeBatteryBoxBlockEntity.this.energyProduction) {
                return super.extract(maxAmount, transaction);
            }
            return 0L;
        }

        @Override
        public long insert(long maxAmount, TransactionContext transaction) {
            if (CreativeBatteryBoxBlockEntity.this.energyConsumption) {
                return super.insert(maxAmount, transaction);
            }
            return 0L;
        }
    };
    protected final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> {
                    if (CreativeBatteryBoxBlockEntity.this.energyProduction) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> {
                    if (CreativeBatteryBoxBlockEntity.this.energyConsumption) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CreativeBatteryBoxBlockEntity.this.energyProduction = value != 0;
                    break;
                }
                case 1: {
                    CreativeBatteryBoxBlockEntity.this.energyConsumption = value != 0;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private boolean energyProduction = true;
    private boolean energyConsumption;

    public CreativeBatteryBoxBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.CREATIVE_BATTERY_BOX_ENTITY, blockPos, blockState);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.creative_battery_box");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new CreativeBatteryBoxMenu(id, this, inventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("energy", (class_2520)new class_2487());
        nbt.method_10556("energy_production", this.energyProduction);
        nbt.method_10556("energy_consumption", this.energyConsumption);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        if (!(nbt.method_10580("energy") instanceof class_2487)) {
            throw new IllegalArgumentException("Tag must be of type IntTag!");
        }
        this.energyProduction = !nbt.method_10545("energy_production") || nbt.method_10577("energy_production");
        this.energyConsumption = nbt.method_10577("energy_consumption");
    }

    public void setEnergyProduction(boolean energyProduction) {
        this.energyProduction = energyProduction;
        CreativeBatteryBoxBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    public void setEnergyConsumption(boolean energyConsumption) {
        this.energyConsumption = energyConsumption;
        CreativeBatteryBoxBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setEnergyProduction(checked);
                break;
            }
            case 1: {
                this.setEnergyConsumption(checked);
            }
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        CreativeBatteryBoxBlockEntity.transferInfiniteEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferInfiniteEnergy(class_1937 level, class_2338 blockPos, class_2680 state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.energyProduction) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            long received;
            EnergyStorage energyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !energyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                received = energyStorage.insert(energyStorage.getCapacity(), (TransactionContext)transaction);
            }
            transaction = Transaction.openOuter();
            try {
                energyStorage.insert(received, (TransactionContext)transaction);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    public long getEnergy() {
        return Long.MAX_VALUE;
    }

    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    @Override
    public void setEnergy(long energy) {
    }

    @Override
    public void setCapacity(long capacity) {
    }
}

