/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Iterator;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.DrainMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.CauldronFluidContent;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
FluidStoragePacketUpdate {
    final SimpleFluidStorage fluidStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_DRAIN_DRAIN_DURATION.getValue();

    public DrainBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.DRAIN_ENTITY, blockPos, blockState);
        this.fluidStorage = new SimpleFluidStorage(FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_DRAIN_FLUID_TANK_CAPACITY.getValue() * 1000L)){

            protected void onFinalCommit() {
                DrainBlockEntity.this.method_5431();
                if (DrainBlockEntity.this.field_11863 != null && !DrainBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_53002(0);
                    this.getFluid().toPacket(buffer);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(DrainBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(DrainBlockEntity.this.method_11016(), (class_3218)DrainBlockEntity.this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
                }
            }
        };
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(DrainBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(DrainBlockEntity.this.maxProgress, index - 2);
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        DrainBlockEntity.this.progress = ByteUtils.with2Bytes(DrainBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        DrainBlockEntity.this.maxProgress = ByteUtils.with2Bytes(DrainBlockEntity.this.maxProgress, (short)value, index - 2);
                    }
                }
            }

            public int method_17389() {
                return 4;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.drain");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_53002(0);
        this.fluidStorage.getFluid().toPacket(buffer);
        buffer.method_52974(this.fluidStorage.getCapacity());
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.FLUID_SYNC_ID, buffer);
        return new DrainMenu(id, this, inventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        return FluidUtils.getRedstoneSignalFromFluidHandler((Storage<FluidVariant>)this.fluidStorage);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("fluid", (class_2520)this.fluidStorage.toNBT(new class_2487()));
        nbt.method_10566("drain.progress", (class_2520)class_2497.method_23247((int)this.progress));
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.fluidStorage.fromNBT(nbt.method_10562("fluid"));
        this.progress = nbt.method_10550("drain.progress");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, DrainBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (DrainBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                blockEntity.resetProgress(blockPos, state);
                DrainBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                return;
            }
            if (blockEntity.progress < blockEntity.maxProgress) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= blockEntity.maxProgress) {
                class_2338 aboveBlockPos = blockPos.method_10084();
                class_2680 aboveBlockState = level.method_8320(aboveBlockPos);
                class_2248 class_22482 = aboveBlockState.method_26204();
                if (class_22482 instanceof class_2263) {
                    class_2263 aboveBlock = (class_2263)class_22482;
                    class_1799 bucketItemStack = aboveBlock.method_9700(null, (class_1936)level, aboveBlockPos, aboveBlockState);
                    if (!bucketItemStack.method_7960()) {
                        Iterator iterator;
                        level.method_33596(null, class_5712.field_28167, aboveBlockPos);
                        Storage fluidStorage = (Storage)FluidStorage.ITEM.find(bucketItemStack, (Object)ContainerItemContext.withConstant((class_1799)bucketItemStack));
                        if (fluidStorage != null && (iterator = fluidStorage.iterator()).hasNext()) {
                            FluidVariant fluidVariant;
                            StorageView fluidView = (StorageView)iterator.next();
                            if (!iterator.hasNext() && !(fluidVariant = (FluidVariant)fluidView.getResource()).isBlank()) {
                                try (Transaction transaction = Transaction.openOuter();){
                                    blockEntity.fluidStorage.insert((TransferVariant)fluidVariant, fluidView.getAmount(), (TransactionContext)transaction);
                                    transaction.commit();
                                }
                            }
                        }
                    }
                } else {
                    class_3611 cauldronFluid;
                    CauldronFluidContent cauldronFluidContent = CauldronFluidContent.getForBlock((class_2248)aboveBlockState.method_26204());
                    if (cauldronFluidContent != null && (cauldronFluid = cauldronFluidContent.fluid) != class_3612.field_15906 && (blockEntity.fluidStorage.isEmpty() || blockEntity.fluidStorage.getFluid().getFluid() == cauldronFluid)) {
                        long cauldronAmountPerLevel = cauldronFluidContent.amountPerLevel;
                        class_2758 cauldronLevelProp = cauldronFluidContent.levelProperty;
                        long amountInsertable = blockEntity.fluidStorage.capacity - blockEntity.fluidStorage.amount;
                        long cauldronAmount = cauldronLevelProp != null && aboveBlockState.method_28498((class_2769)cauldronLevelProp) ? cauldronAmountPerLevel * (long)((Integer)aboveBlockState.method_11654((class_2769)cauldronLevelProp)).intValue() : cauldronAmountPerLevel;
                        if (cauldronAmount > 0L && cauldronAmount <= amountInsertable) {
                            long inserted;
                            try (Transaction transaction = Transaction.openOuter();){
                                inserted = blockEntity.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)cauldronFluid), cauldronAmount, (TransactionContext)transaction);
                                if (inserted == cauldronAmount) {
                                    transaction.commit();
                                }
                            }
                            if (inserted == cauldronAmount) {
                                level.method_8652(aboveBlockPos, class_2246.field_10593.method_9564(), 3);
                            }
                        }
                    }
                }
                blockEntity.resetProgress(blockPos, state);
            }
            DrainBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress(blockPos, state);
            DrainBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
    }

    private static boolean hasRecipe(DrainBlockEntity blockEntity) {
        class_3610 fluidState;
        class_2338 blockPos;
        class_2338 aboveBlockPos;
        class_1937 level = blockEntity.method_10997();
        class_2680 aboveBlockState = level.method_8320(aboveBlockPos = (blockPos = blockEntity.method_11016()).method_10084());
        if (aboveBlockState.method_26204() instanceof class_2263 && !(fluidState = level.method_8316(aboveBlockPos)).method_15769()) {
            try (Transaction transaction = Transaction.openOuter();){
                boolean bl = blockEntity.fluidStorage.insert((TransferVariant)FluidVariant.of((class_3611)fluidState.method_15772()), 81000L, (TransactionContext)transaction) == 81000L;
                return bl;
            }
        }
        CauldronFluidContent cauldronFluidContent = CauldronFluidContent.getForBlock((class_2248)aboveBlockState.method_26204());
        if (cauldronFluidContent == null) {
            return false;
        }
        class_3611 cauldronFluid = cauldronFluidContent.fluid;
        if (cauldronFluid == class_3612.field_15906 || !blockEntity.fluidStorage.isEmpty() && blockEntity.fluidStorage.getFluid().getFluid() != cauldronFluid) {
            return false;
        }
        long cauldronAmountPerLevel = cauldronFluidContent.amountPerLevel;
        class_2758 cauldronLevelProp = cauldronFluidContent.levelProperty;
        long amountInsertable = blockEntity.fluidStorage.capacity - blockEntity.fluidStorage.amount;
        long cauldronAmount = cauldronLevelProp != null && aboveBlockState.method_28498((class_2769)cauldronLevelProp) ? cauldronAmountPerLevel * (long)((Integer)aboveBlockState.method_11654((class_2769)cauldronLevelProp)).intValue() : cauldronAmountPerLevel;
        return cauldronAmount > 0L && cauldronAmount <= amountInsertable;
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public long getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, long capacity) {
    }
}

