/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.jddev0.ep.block.FiltrationPlantBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.UnchargerBlockEntity;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.fluid.ModFluids;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.item.ModItems;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.screen.FiltrationPlantMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class FiltrationPlantBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
FluidStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_FILTRATION_PLANT_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_FILTRATION_PLANT_TRANSFER_RATE.getValue();
    public static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FILTRATION_PLANT_CONSUMPTION_PER_TICK.getValue();
    public static final long TANK_CAPACITY = FluidUtils.convertMilliBucketsToDroplets(1000L * ModConfigs.COMMON_FILTRATION_PLANT_TANK_CAPACITY.getValue());
    public static final long DIRTY_WATER_CONSUMPTION_PER_RECIPE = FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_FILTRATION_PLANT_DIRTY_WATER_USAGE_PER_RECIPE.getValue());
    final CachedSidedInventoryStorage<UnchargerBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    final CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_FILTRATION_PLANT_RECIPE_DURATION.getValue();
    private long energyConsumptionLeft = -1L;
    private boolean hasEnoughEnergy;
    private class_2960 currentRecipeIdForLoad = null;
    private class_8786<FiltrationPlantRecipe> currentRecipe = null;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public FiltrationPlantBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.FILTRATION_PLANT_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(4){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0, 1 -> stack.method_31574(ModItems.CHARCOAL_FILTER);
                    case 2, 3 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5431() {
                super.method_5431();
                FiltrationPlantBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 4).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 0 || i == 1, i -> i == 2 || i == 3);
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                FiltrationPlantBlockEntity.this.method_5431();
                if (FiltrationPlantBlockEntity.this.field_11863 != null && !FiltrationPlantBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(FiltrationPlantBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(FiltrationPlantBlockEntity.this.method_11016(), (class_3218)FiltrationPlantBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.fluidStorage = new CombinedStorage(List.of(new SimpleFluidStorage(TANK_CAPACITY){

            protected void onFinalCommit() {
                FiltrationPlantBlockEntity.this.method_5431();
                if (FiltrationPlantBlockEntity.this.field_11863 != null && !FiltrationPlantBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_53002(0);
                    this.getFluid().toPacket(buffer);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(FiltrationPlantBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(FiltrationPlantBlockEntity.this.method_11016(), (class_3218)FiltrationPlantBlockEntity.this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
                }
            }

            private boolean isFluidValid(FluidVariant variant) {
                return variant.isOf((Object)ModFluids.DIRTY_WATER);
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        }, new SimpleFluidStorage(TANK_CAPACITY){

            protected void onFinalCommit() {
                FiltrationPlantBlockEntity.this.method_5431();
                if (FiltrationPlantBlockEntity.this.field_11863 != null && !FiltrationPlantBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_53002(1);
                    this.getFluid().toPacket(buffer);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(FiltrationPlantBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(FiltrationPlantBlockEntity.this.method_11016(), (class_3218)FiltrationPlantBlockEntity.this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
                }
            }

            private boolean isFluidValid(FluidVariant variant) {
                return variant.isOf((Object)class_3612.field_15910);
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        }));
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(FiltrationPlantBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(FiltrationPlantBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(FiltrationPlantBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (FiltrationPlantBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> FiltrationPlantBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> FiltrationPlantBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        FiltrationPlantBlockEntity.this.progress = ByteUtils.with2Bytes(FiltrationPlantBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        FiltrationPlantBlockEntity.this.maxProgress = ByteUtils.with2Bytes(FiltrationPlantBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        FiltrationPlantBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        FiltrationPlantBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.filtration_plant");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        for (int i = 0; i < 2; ++i) {
            buffer = PacketByteBufs.create();
            buffer.method_53002(i);
            ((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(i))).getFluid().toPacket(buffer);
            buffer.method_52974(((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(i))).getCapacity());
            buffer.method_10807(this.method_11016());
            ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.FLUID_SYNC_ID, buffer);
        }
        buffer = PacketByteBufs.create();
        buffer.method_10807(this.method_11016());
        if (this.currentRecipe == null) {
            buffer.method_52964(false);
        } else {
            buffer.method_52964(true);
            buffer.method_10812(this.currentRecipe.comp_1932());
            FiltrationPlantRecipe.Serializer.INSTANCE.write(buffer, (FiltrationPlantRecipe)this.currentRecipe.comp_1933());
        }
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.SYNC_FILTRATION_PLANT_CURRENT_RECIPE_ID, buffer);
        return new FiltrationPlantMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> FluidUtils.getRedstoneSignalFromFluidHandler(this.fluidStorage);
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        for (int i = 0; i < this.fluidStorage.parts.size(); ++i) {
            nbt.method_10566("fluid." + i, (class_2520)((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(i))).toNBT(new class_2487()));
        }
        if (this.currentRecipe != null) {
            nbt.method_10566("recipe.id", (class_2520)class_2519.method_23256((String)this.currentRecipe.comp_1932().toString()));
        }
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        for (int i = 0; i < this.fluidStorage.parts.size(); ++i) {
            ((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(i))).fromNBT(nbt.method_10562("fluid." + i));
        }
        if (nbt.method_10545("recipe.id")) {
            class_2520 tag = nbt.method_10580("recipe.id");
            if (!(tag instanceof class_2519)) {
                throw new IllegalArgumentException("Tag must be of type StringTag!");
            }
            class_2519 stringTag = (class_2519)tag;
            this.currentRecipeIdForLoad = class_2960.method_12829((String)stringTag.method_10714());
        }
        this.progress = nbt.method_10550("recipe.progress");
        this.energyConsumptionLeft = nbt.method_10550("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, FiltrationPlantBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.currentRecipeIdForLoad != null) {
            List recipes = level.method_8433().method_30027((class_3956)FiltrationPlantRecipe.Type.INSTANCE);
            blockEntity.currentRecipe = recipes.stream().filter(recipe -> recipe.comp_1932().equals((Object)blockEntity.currentRecipeIdForLoad)).findFirst().orElse(null);
            blockEntity.currentRecipeIdForLoad = null;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)FiltrationPlantBlock.POWERED))) {
            return;
        }
        if (FiltrationPlantBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.currentRecipe == null) {
                return;
            }
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * (long)blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.internalEnergyStorage.amount) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    FiltrationPlantBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_TICK, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem();
                }
                FiltrationPlantBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                FiltrationPlantBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            FiltrationPlantBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = true;
    }

    private void craftItem() {
        if (this.currentRecipe == null || !FiltrationPlantBlockEntity.hasRecipe(this)) {
            return;
        }
        FiltrationPlantRecipe recipe = (FiltrationPlantRecipe)this.currentRecipe.comp_1933();
        try (Transaction transaction = Transaction.openOuter();){
            this.fluidStorage.extract((Object)FluidVariant.of((class_3611)ModFluids.DIRTY_WATER), DIRTY_WATER_CONSUMPTION_PER_RECIPE, (TransactionContext)transaction);
            this.fluidStorage.insert((Object)FluidVariant.of((class_3611)class_3612.field_15910), DIRTY_WATER_CONSUMPTION_PER_RECIPE, (TransactionContext)transaction);
            transaction.commit();
        }
        for (int i = 0; i < 2; ++i) {
            class_1799 charcoalFilter = this.internalInventory.method_5438(i).method_7972();
            if (charcoalFilter.method_7960() && !charcoalFilter.method_31574(ModItems.CHARCOAL_FILTER)) continue;
            if (charcoalFilter.method_7970(1, this.field_11863.field_9229, null)) {
                this.internalInventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            this.internalInventory.method_5447(i, charcoalFilter);
        }
        class_1799[] outputs = recipe.generateOutputs(this.field_11863.field_9229);
        if (!outputs[0].method_7960()) {
            this.internalInventory.method_5447(2, outputs[0].method_46651(this.internalInventory.method_5438(2).method_7947() + outputs[0].method_7947()));
        }
        if (!outputs[1].method_7960()) {
            this.internalInventory.method_5447(3, outputs[1].method_46651(this.internalInventory.method_5438(3).method_7947() + outputs[1].method_7947()));
        }
        this.resetProgress(this.method_11016(), this.method_11010());
    }

    private static boolean hasRecipe(FiltrationPlantBlockEntity blockEntity) {
        if (blockEntity.currentRecipe == null) {
            return false;
        }
        FiltrationPlantRecipe recipe = (FiltrationPlantRecipe)blockEntity.currentRecipe.comp_1933();
        class_1799[] maxOutputs = recipe.getMaxOutputCounts();
        return !(((SimpleFluidStorage)((Object)blockEntity.fluidStorage.parts.get(0))).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || ((SimpleFluidStorage)((Object)blockEntity.fluidStorage.parts.get(1))).getCapacity() - ((SimpleFluidStorage)((Object)blockEntity.fluidStorage.parts.get(1))).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || !blockEntity.internalInventory.method_5438(0).method_31574(ModItems.CHARCOAL_FILTER) || !blockEntity.internalInventory.method_5438(1).method_31574(ModItems.CHARCOAL_FILTER) || !maxOutputs[0].method_7960() && !FiltrationPlantBlockEntity.canInsertItemIntoOutputSlot(blockEntity.internalInventory, maxOutputs[0]) || !maxOutputs[1].method_7960() && !FiltrationPlantBlockEntity.canInsertItemIntoSecondaryOutputSlot(blockEntity.internalInventory, maxOutputs[1]));
    }

    private static boolean canInsertItemIntoOutputSlot(class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(2);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    private static boolean canInsertItemIntoSecondaryOutputSlot(class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(3);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    public void changeRecipeIndex(boolean downUp) {
        if (this.field_11863.method_8608()) {
            return;
        }
        List recipes = this.field_11863.method_8433().method_30027((class_3956)FiltrationPlantRecipe.Type.INSTANCE);
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> ((FiltrationPlantRecipe)recipe.comp_1933()).method_8110(this.field_11863.method_30349()).method_7922())).collect(Collectors.toList());
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.comp_1932().equals((Object)((class_8786)recipes.get(i)).comp_1932())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : (class_8786)recipes.get(currentIndex);
        this.resetProgress(this.method_11016(), this.method_11010());
        FiltrationPlantBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10807(this.method_11016());
        if (this.currentRecipe == null) {
            buffer.method_52964(false);
        } else {
            buffer.method_52964(true);
            buffer.method_10812(this.currentRecipe.comp_1932());
            FiltrationPlantRecipe.Serializer.INSTANCE.write(buffer, (FiltrationPlantRecipe)this.currentRecipe.comp_1933());
        }
        ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, 32.0, ModMessages.SYNC_FILTRATION_PLANT_CURRENT_RECIPE_ID, buffer);
    }

    public void setCurrentRecipe(@Nullable class_8786<FiltrationPlantRecipe> currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    @Nullable
    public class_8786<FiltrationPlantRecipe> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public FluidStack getFluid(int tank) {
        return ((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(tank))).getFluid();
    }

    public long getTankCapacity(int tank) {
        return ((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(tank))).getCapacity();
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        ((SimpleFluidStorage)((Object)this.fluidStorage.parts.get(tank))).setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, long capacity) {
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        this.method_5431();
    }
}

