/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Iterator;
import java.util.stream.IntStream;
import me.jddev0.ep.block.FluidFillerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.UnchargerBlockEntity;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.FluidFillerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class FluidFillerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
FluidStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_FLUID_FILLER_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_FLUID_FILLER_TRANSFER_RATE.getValue();
    public static final long MAX_FLUID_FILLING_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_FLUID_ITEM_TRANSFER_RATE.getValue();
    public static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    final CachedSidedInventoryStorage<UnchargerBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    final SimpleFluidStorage fluidStorage;
    protected final class_3913 data;
    private long fluidFillingLeft = -1L;
    private long fluidFillingSumPending = 0L;
    private boolean forceAllowStackUpdateFlag = false;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public FluidFillerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.FLUID_FILLER_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(1){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(FluidFillerBlockEntity.this.forceAllowStackUpdateFlag || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null && ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) != null))) {
                        FluidFillerBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                FluidFillerBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 1).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 itemStack = this.internalInventory.method_5438(i.intValue());
            if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) == null) {
                return true;
            }
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.internalInventory, null).getSlots().get((int)i))));
            if (fluidStorage == null) {
                return true;
            }
            if (!fluidStorage.supportsInsertion()) {
                return true;
            }
            boolean isFluidValid = false;
            if (!this.fluidStorage.isEmpty()) {
                this.forceAllowStackUpdateFlag = true;
                try (Transaction transaction = Transaction.openNested((TransactionContext)Transaction.getCurrentUnsafe());){
                    long inserted = fluidStorage.insert((Object)((FluidVariant)this.fluidStorage.getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                    isFluidValid = inserted > 0L;
                    transaction.abort();
                }
                finally {
                    this.forceAllowStackUpdateFlag = false;
                }
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidView.getCapacity() <= fluidView.getAmount() || !this.fluidStorage.isEmpty() && (!fluidVariant.isBlank() || !isFluidValid) && !fluidVariant.equals(this.fluidStorage.getResource())) continue;
                return false;
            }
            return true;
        });
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                FluidFillerBlockEntity.this.method_5431();
                if (FluidFillerBlockEntity.this.field_11863 != null && !FluidFillerBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(FluidFillerBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(FluidFillerBlockEntity.this.method_11016(), (class_3218)FluidFillerBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.fluidStorage = new SimpleFluidStorage(FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_FLUID_FILLER_FLUID_TANK_CAPACITY.getValue() * 1000L)){

            protected void onFinalCommit() {
                FluidFillerBlockEntity.this.method_5431();
                if (FluidFillerBlockEntity.this.field_11863 != null && !FluidFillerBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_53002(0);
                    this.getFluid().toPacket(buffer);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(FluidFillerBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(FluidFillerBlockEntity.this.method_11016(), (class_3218)FluidFillerBlockEntity.this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
                }
            }
        };
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1, 2, 3 -> ByteUtils.get2Bytes(FluidFillerBlockEntity.this.fluidFillingLeft, index);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(FluidFillerBlockEntity.this.fluidFillingSumPending, index - 4);
                    case 8 -> FluidFillerBlockEntity.this.redstoneMode.ordinal();
                    case 9 -> FluidFillerBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 8: {
                        FluidFillerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 9: {
                        FluidFillerBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 10;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.fluid_filler");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        buffer = PacketByteBufs.create();
        buffer.method_53002(0);
        this.fluidStorage.getFluid().toPacket(buffer);
        buffer.method_52974(this.fluidStorage.getCapacity());
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.FLUID_SYNC_ID, buffer);
        return new FluidFillerMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> FluidUtils.getRedstoneSignalFromFluidHandler((Storage<FluidVariant>)this.fluidStorage);
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("fluid", (class_2520)this.fluidStorage.toNBT(new class_2487()));
        FluidUtils.writeFluidAmountInMilliBucketsWithLeftover(this.fluidFillingLeft, "recipe.fluid_filling_left", "recipe.fluid_filling_left_leftover_droplets", nbt);
        FluidUtils.writeFluidAmountInMilliBucketsWithLeftover(this.fluidFillingSumPending, "recipe.fluid_filling_sum_pending", "recipe.fluid_filling_sum_pending_leftover_droplets", nbt);
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.fluidStorage.fromNBT(nbt.method_10562("fluid"));
        this.fluidFillingLeft = FluidUtils.readFluidAmountInMilliBucketsWithLeftover("recipe.fluid_filling_left", "recipe.fluid_filling_left_leftover_droplets", nbt);
        this.fluidFillingSumPending = FluidUtils.readFluidAmountInMilliBucketsWithLeftover("recipe.fluid_filling_sum_pending", "recipe.fluid_filling_sum_pending_leftover_droplets", nbt);
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, FluidFillerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)FluidFillerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            Iterator transaction;
            class_1799 itemStack = blockEntity.internalInventory.method_5438(0);
            long fluidFillingSum = 0L;
            long fluidFillingLeftSum = 0L;
            if (blockEntity.fluidStorage.getAmount() - blockEntity.fluidFillingSumPending <= 0L) {
                return;
            }
            if (blockEntity.internalEnergyStorage.amount < ENERGY_USAGE_PER_TICK) {
                return;
            }
            if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) == null) {
                return;
            }
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.internalInventory, null).getSlots().get(0))));
            if (fluidStorage == null) {
                return;
            }
            boolean isFluidValid = false;
            if (!blockEntity.fluidStorage.isEmpty()) {
                blockEntity.forceAllowStackUpdateFlag = true;
                try {
                    transaction = Transaction.openOuter();
                    try {
                        long inserted = fluidStorage.insert((Object)((FluidVariant)blockEntity.fluidStorage.getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                        isFluidValid = inserted > 0L;
                        transaction.abort();
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                }
                finally {
                    blockEntity.forceAllowStackUpdateFlag = false;
                }
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidView.getCapacity() <= fluidView.getAmount() || !blockEntity.fluidStorage.isEmpty() && (!fluidVariant.isBlank() || !isFluidValid) && !fluidVariant.equals(blockEntity.fluidStorage.getResource())) continue;
                fluidFillingSum += Math.min(blockEntity.fluidStorage.getAmount() - blockEntity.fluidFillingSumPending - fluidFillingSum, Math.min(fluidView.getCapacity() - fluidView.getAmount(), FluidUtils.convertMilliBucketsToDroplets(MAX_FLUID_FILLING_PER_TICK) - fluidFillingSum));
                fluidFillingLeftSum += fluidView.getCapacity() - fluidView.getAmount();
            }
            if (fluidFillingSum == 0L) {
                return;
            }
            blockEntity.fluidFillingLeft = fluidFillingLeftSum;
            blockEntity.fluidFillingSumPending += fluidFillingSum;
            blockEntity.forceAllowStackUpdateFlag = true;
            try {
                transaction = Transaction.openOuter();
                try {
                    blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_TICK, (TransactionContext)transaction);
                    long fluidSumFillable = Math.min(blockEntity.fluidStorage.getAmount(), blockEntity.fluidFillingSumPending);
                    FluidVariant fluidVariantToFill = (FluidVariant)blockEntity.fluidStorage.getResource();
                    long fluidSumFilled = fluidStorage.insert((Object)fluidVariantToFill, fluidSumFillable, (TransactionContext)transaction);
                    if (fluidSumFilled > 0L) {
                        blockEntity.fluidStorage.extract((TransferVariant)fluidVariantToFill, fluidSumFilled, (TransactionContext)transaction);
                        blockEntity.fluidFillingSumPending -= fluidSumFilled;
                        blockEntity.fluidFillingLeft = fluidFillingLeftSum - fluidSumFilled;
                    }
                    transaction.commit();
                }
                finally {
                    if (transaction != null) {
                        transaction.close();
                    }
                }
            }
            finally {
                blockEntity.forceAllowStackUpdateFlag = false;
            }
            if (blockEntity.fluidFillingLeft <= 0L) {
                blockEntity.resetProgress();
            }
            FluidFillerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress();
            FluidFillerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress() {
        this.fluidFillingLeft = -1L;
        this.fluidFillingSumPending = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRecipe() {
        class_1799 itemStack = this.internalInventory.method_5438(0);
        if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) != null) {
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.internalInventory, null).getSlots().get(0))));
            if (fluidStorage == null) {
                return false;
            }
            boolean isFluidValid = false;
            if (!this.fluidStorage.isEmpty()) {
                this.forceAllowStackUpdateFlag = true;
                try (Transaction transaction = Transaction.openOuter();){
                    long inserted = fluidStorage.insert((Object)((FluidVariant)this.fluidStorage.getResource()), Long.MAX_VALUE, (TransactionContext)transaction);
                    isFluidValid = inserted > 0L;
                    transaction.abort();
                }
                finally {
                    this.forceAllowStackUpdateFlag = false;
                }
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidView.getCapacity() <= fluidView.getAmount() || !this.fluidStorage.isEmpty() && (!fluidVariant.isBlank() || !isFluidValid) && !fluidVariant.equals(this.fluidStorage.getResource())) continue;
                return true;
            }
        }
        return false;
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public long getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, long capacity) {
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        this.method_5431();
    }
}

