/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.jddev0.ep.block.FluidPipeBlock;
import me.jddev0.ep.block.ModBlockStateProperties;
import me.jddev0.ep.block.entity.ModBlockEntities;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;

public class FluidPipeBlockEntity
extends class_2586 {
    private final FluidPipeBlock.Tier tier;
    private final long maxTransfer;
    final Storage<FluidVariant> fluidStorage;
    private final Map<Pair<class_2338, class_2350>, Storage<FluidVariant>> producers = new HashMap<Pair<class_2338, class_2350>, Storage<FluidVariant>>();
    private final Map<Pair<class_2338, class_2350>, Storage<FluidVariant>> consumers = new HashMap<Pair<class_2338, class_2350>, Storage<FluidVariant>>();
    private final List<class_2338> pipeBlocks = new LinkedList<class_2338>();

    public static class_2591<FluidPipeBlockEntity> getEntityTypeFromTier(FluidPipeBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case FluidPipeBlock.Tier.IRON -> ModBlockEntities.IRON_FLUID_PIPE_ENTITY;
            case FluidPipeBlock.Tier.GOLDEN -> ModBlockEntities.GOLDEN_FLUID_PIPE_ENTITY;
        };
    }

    public FluidPipeBlockEntity(class_2338 blockPos, class_2680 blockState, FluidPipeBlock.Tier tier) {
        super(FluidPipeBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.maxTransfer = tier.getTransferRate();
        this.fluidStorage = Storage.empty();
    }

    public FluidPipeBlock.Tier getTier() {
        return this.tier;
    }

    public Map<Pair<class_2338, class_2350>, Storage<FluidVariant>> getProducers() {
        return this.producers;
    }

    public Map<Pair<class_2338, class_2350>, Storage<FluidVariant>> getConsumers() {
        return this.consumers;
    }

    public List<class_2338> getPipeBlocks() {
        return this.pipeBlocks;
    }

    public static void updateConnections(class_1937 level, class_2338 blockPos, class_2680 state, FluidPipeBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        blockEntity.producers.clear();
        blockEntity.consumers.clear();
        blockEntity.pipeBlocks.clear();
        for (class_2350 direction : class_2350.values()) {
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null) continue;
            if (testBlockEntity instanceof FluidPipeBlockEntity) {
                FluidPipeBlockEntity fluidPipeBlockEntity = (FluidPipeBlockEntity)testBlockEntity;
                if (fluidPipeBlockEntity.getTier() != blockEntity.getTier()) continue;
                blockEntity.pipeBlocks.add(testPos);
                continue;
            }
            Storage fluidStorage = (Storage)FluidStorage.SIDED.find(level, testPos, (Object)direction.method_10153());
            if (fluidStorage == null || !fluidStorage.iterator().hasNext()) continue;
            ModBlockStateProperties.PipeConnection pipeConnection = (ModBlockStateProperties.PipeConnection)((Object)state.method_11654(FluidPipeBlock.getPipeConnectionPropertyFromDirection(direction)));
            if (pipeConnection.isExtract()) {
                blockEntity.producers.put((Pair<class_2338, class_2350>)Pair.of((Object)testPos, (Object)direction.method_10153()), (Storage<FluidVariant>)fluidStorage);
                continue;
            }
            if (!pipeConnection.isInsert()) continue;
            blockEntity.consumers.put((Pair<class_2338, class_2350>)Pair.of((Object)testPos, (Object)direction.method_10153()), (Storage<FluidVariant>)fluidStorage);
        }
    }

    public static List<Storage<FluidVariant>> getConnectedConsumers(class_1937 level, class_2338 blockPos, List<class_2338> checkedPipes) {
        LinkedList<Storage<FluidVariant>> consumers = new LinkedList<Storage<FluidVariant>>();
        LinkedList<class_2338> pipeBlocksLeft = new LinkedList<class_2338>();
        pipeBlocksLeft.add(blockPos);
        checkedPipes.add(blockPos);
        while (pipeBlocksLeft.size() > 0) {
            class_2338 checkPos = (class_2338)pipeBlocksLeft.pop();
            class_2586 blockEntity = level.method_8321(checkPos);
            if (!(blockEntity instanceof FluidPipeBlockEntity)) continue;
            FluidPipeBlockEntity fluidPipeBlockEntity = (FluidPipeBlockEntity)blockEntity;
            fluidPipeBlockEntity.getPipeBlocks().forEach(pos -> {
                if (!checkedPipes.contains(pos)) {
                    checkedPipes.add((class_2338)pos);
                    pipeBlocksLeft.add((class_2338)pos);
                }
            });
            consumers.addAll(fluidPipeBlockEntity.getConsumers().values());
        }
        return consumers;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, FluidPipeBlockEntity blockEntity) {
        long consumptionSum;
        LinkedList<Long> fluidConsumptionValues;
        LinkedList<Storage> fluidConsumption;
        long productionSum;
        LinkedList<Long> fluidProductionValues;
        FluidVariant extractedFluidType;
        LinkedList<Storage<FluidVariant>> fluidProduction;
        if (level.method_8608()) {
            return;
        }
        FluidPipeBlockEntity.updateConnections(level, blockPos, state, blockEntity);
        List<Storage<FluidVariant>> consumers = null;
        LinkedList<FluidVariant> alreadyCheckedFluidTypes = new LinkedList<FluidVariant>();
        while (true) {
            fluidProduction = new LinkedList<Storage<FluidVariant>>();
            extractedFluidType = FluidVariant.blank();
            fluidProductionValues = new LinkedList<Long>();
            productionSum = 0L;
            for (Storage<FluidVariant> storage : blockEntity.producers.values()) {
                boolean extractedAnything = false;
                int fluidProductionValuesIndex = -1;
                block32: for (StorageView fluidView : storage) {
                    long extracted;
                    FluidVariant fluidVariantInTank = (FluidVariant)fluidView.getResource();
                    if (fluidVariantInTank.isBlank()) continue;
                    boolean wasExtractedFluidTypeEmpty = extractedFluidType.isBlank();
                    if (wasExtractedFluidTypeEmpty) {
                        for (FluidVariant alreadyCheckedFluidType : alreadyCheckedFluidTypes) {
                            if (!alreadyCheckedFluidType.equals(fluidVariantInTank)) continue;
                            continue block32;
                        }
                        extractedFluidType = FluidVariant.of((class_3611)fluidVariantInTank.getFluid(), (class_2487)fluidVariantInTank.copyNbt());
                    }
                    if (!fluidVariantInTank.equals(extractedFluidType)) continue;
                    try (Transaction transaction = Transaction.openOuter();){
                        extracted = storage.extract((Object)extractedFluidType, blockEntity.maxTransfer, (TransactionContext)transaction);
                    }
                    if (extracted <= 0L) {
                        if (!wasExtractedFluidTypeEmpty) continue;
                        extractedFluidType = FluidVariant.blank();
                        continue;
                    }
                    extractedAnything = true;
                    if (fluidProductionValuesIndex == -1) {
                        fluidProductionValuesIndex = fluidProductionValues.size();
                        fluidProductionValues.add(extracted);
                    } else {
                        fluidProductionValues.set(fluidProductionValuesIndex, (Long)fluidProductionValues.get(fluidProductionValuesIndex) + extracted);
                    }
                    productionSum += extracted;
                }
                if (!extractedAnything) continue;
                fluidProduction.add(storage);
            }
            if (productionSum <= 0L || extractedFluidType.isBlank()) {
                return;
            }
            fluidConsumption = new LinkedList<Storage>();
            fluidConsumptionValues = new LinkedList<Long>();
            consumptionSum = 0L;
            if (consumers == null) {
                consumers = FluidPipeBlockEntity.getConnectedConsumers(level, blockPos, new LinkedList<class_2338>());
            }
            for (Storage storage : consumers) {
                boolean receivedAnything = false;
                int fluidConsumptionValuesIndex = -1;
                for (StorageView fluidView : storage) {
                    long received;
                    try (Transaction transaction = Transaction.openOuter();){
                        received = storage.insert((Object)extractedFluidType, Math.min(blockEntity.maxTransfer, productionSum), (TransactionContext)transaction);
                    }
                    if (received <= 0L) continue;
                    receivedAnything = true;
                    if (fluidConsumptionValuesIndex == -1) {
                        fluidConsumptionValuesIndex = fluidConsumptionValues.size();
                        fluidConsumptionValues.add(received);
                    } else {
                        fluidConsumptionValues.set(fluidConsumptionValuesIndex, (Long)fluidConsumptionValues.get(fluidConsumptionValuesIndex) + received);
                    }
                    consumptionSum += received;
                }
                if (!receivedAnything) continue;
                fluidConsumption.add(storage);
            }
            if (consumptionSum > 0L) break;
            alreadyCheckedFluidTypes.add(extractedFluidType);
        }
        long transferLeft = Math.min(productionSum, consumptionSum);
        LinkedList<Long> fluidProductionDistributed = new LinkedList<Long>();
        for (int i = 0; i < fluidProduction.size(); ++i) {
            fluidProductionDistributed.add(0L);
        }
        long productionLeft = transferLeft;
        int divisor = fluidProduction.size();
        block37: while (productionLeft > 0L) {
            long productionPerProducer = productionLeft / (long)divisor;
            if (productionPerProducer == 0L) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / (long)divisor;
            }
            for (int i = 0; i < fluidProductionValues.size(); ++i) {
                long productionDistributed = (Long)fluidProductionDistributed.get(i);
                long productionOfProducerLeft = (Long)fluidProductionValues.get(i) - productionDistributed;
                long productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                fluidProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0L) break block37;
            }
        }
        long realProduction = 0L;
        long realProductionAmountMissing = 0L;
        for (int i = 0; i < fluidProduction.size(); ++i) {
            long realExtract;
            long amount = (Long)fluidProductionDistributed.get(i) + realProductionAmountMissing;
            if (amount <= 0L) continue;
            FluidVariant extract = FluidVariant.of((class_3611)extractedFluidType.getFluid(), (class_2487)extractedFluidType.copyNbt());
            try (Transaction transaction = Transaction.openOuter();){
                realExtract = ((Storage)fluidProduction.get(i)).extract((Object)extract, amount, (TransactionContext)transaction);
                transaction.commit();
            }
            realProduction += realExtract;
            realProductionAmountMissing = amount - realExtract;
        }
        if (realProductionAmountMissing > 0L) {
            for (Storage producer : fluidProduction) {
                long realExtract;
                FluidVariant extract = FluidVariant.of((class_3611)extractedFluidType.getFluid(), (class_2487)extractedFluidType.copyNbt());
                try (Transaction transaction = Transaction.openOuter();){
                    realExtract = producer.extract((Object)extract, realProductionAmountMissing, (TransactionContext)transaction);
                    transaction.commit();
                }
                realProduction += realExtract;
                if ((realProductionAmountMissing -= realExtract) != 0L) continue;
                break;
            }
        }
        LinkedList<Long> fluidConsumptionDistributed = new LinkedList<Long>();
        for (int i = 0; i < fluidConsumption.size(); ++i) {
            fluidConsumptionDistributed.add(0L);
        }
        long consumptionLeft = realProduction;
        divisor = fluidConsumption.size();
        block42: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < fluidConsumptionValues.size(); ++i) {
                long consumptionDistributed = (Long)fluidConsumptionDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)fluidConsumptionValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                fluidConsumptionDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block42;
            }
        }
        long realConsumptionAmountMissing = 0L;
        for (int i = 0; i < fluidConsumption.size(); ++i) {
            long realInsert;
            long amount = (Long)fluidConsumptionDistributed.get(i) + realConsumptionAmountMissing;
            if (amount <= 0L) continue;
            FluidVariant insert = FluidVariant.of((class_3611)extractedFluidType.getFluid(), (class_2487)extractedFluidType.copyNbt());
            try (Transaction transaction = Transaction.openOuter();){
                realInsert = ((Storage)fluidConsumption.get(i)).insert((Object)insert, amount, (TransactionContext)transaction);
                transaction.commit();
            }
            realConsumptionAmountMissing = amount - realInsert;
        }
        if (realConsumptionAmountMissing > 0L) {
            for (Storage consumer : fluidConsumption) {
                long realInsert;
                FluidVariant insert = FluidVariant.of((class_3611)extractedFluidType.getFluid(), (class_2487)extractedFluidType.copyNbt());
                try (Transaction transaction = Transaction.openOuter();){
                    realInsert = consumer.insert((Object)insert, realConsumptionAmountMissing, (TransactionContext)transaction);
                    transaction.commit();
                }
                if ((realConsumptionAmountMissing -= realInsert) != 0L) continue;
                break;
            }
        }
    }
}

