/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.FluidTankMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
FluidStoragePacketUpdate,
CheckboxUpdate {
    private final FluidTankBlock.Tier tier;
    final SimpleFluidStorage fluidStorage;
    protected final class_3913 data;
    private boolean ignoreNBT;
    private FluidStack fluidFilter = new FluidStack(FluidVariant.blank(), 1L);

    public static class_2591<FluidTankBlockEntity> getEntityTypeFromTier(FluidTankBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case FluidTankBlock.Tier.SMALL -> ModBlockEntities.FLUID_TANK_SMALL_ENTITY;
            case FluidTankBlock.Tier.MEDIUM -> ModBlockEntities.FLUID_TANK_MEDIUM_ENTITY;
            case FluidTankBlock.Tier.LARGE -> ModBlockEntities.FLUID_TANK_LARGE_ENTITY;
        };
    }

    public FluidTankBlockEntity(class_2338 blockPos, class_2680 blockState, FluidTankBlock.Tier tier) {
        super(FluidTankBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.fluidStorage = new SimpleFluidStorage(tier.getTankCapacity()){

            protected void onFinalCommit() {
                FluidTankBlockEntity.this.method_5431();
                if (FluidTankBlockEntity.this.field_11863 != null && !FluidTankBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_53002(0);
                    this.getFluid().toPacket(buffer);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(FluidTankBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(FluidTankBlockEntity.this.method_11016(), (class_3218)FluidTankBlockEntity.this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
                }
            }

            private boolean isFluidValid(FluidVariant variant) {
                return FluidTankBlockEntity.this.fluidFilter.isEmpty() || (FluidTankBlockEntity.this.ignoreNBT ? FluidTankBlockEntity.this.fluidFilter.getFluidVariant().isOf((Object)variant.getFluid()) && FluidTankBlockEntity.this.fluidFilter.getFluidVariant().nbtMatches(variant.getNbt()) : FluidTankBlockEntity.this.fluidFilter.getFluidVariant().isOf((Object)variant.getFluid()));
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        };
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> {
                        if (FluidTankBlockEntity.this.ignoreNBT) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidTankBlockEntity.this.ignoreNBT = value != 0;
                    }
                }
            }

            public int method_17389() {
                return 1;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)("container.energizedpower." + this.tier.getResourceId()));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_53002(0);
        this.fluidStorage.getFluid().toPacket(buffer);
        buffer.method_52974(this.fluidStorage.getCapacity());
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.FLUID_SYNC_ID, buffer);
        buffer = PacketByteBufs.create();
        buffer.method_53002(1);
        this.fluidFilter.toPacket(buffer);
        buffer.method_52974(0L);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.FLUID_SYNC_ID, buffer);
        return new FluidTankMenu(id, inventory, this, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public FluidTankBlock.Tier getTier() {
        return this.tier;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, FluidTankBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (level.method_8510() % 100L == 0L) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_53002(0);
            blockEntity.fluidStorage.getFluid().toPacket(buffer);
            buffer.method_52974(blockEntity.fluidStorage.getCapacity());
            buffer.method_10807(blockPos);
            ModMessages.sendServerPacketToPlayersWithinXBlocks(blockPos, (class_3218)level, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
        }
    }

    public int getRedstoneOutput() {
        return FluidUtils.getRedstoneSignalFromFluidHandler((Storage<FluidVariant>)this.fluidStorage);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("fluid", (class_2520)this.fluidStorage.toNBT(new class_2487()));
        nbt.method_10556("ignore_nbt", this.ignoreNBT);
        nbt.method_10566("fluid_filter", (class_2520)this.fluidFilter.toNBT(new class_2487()));
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.fluidStorage.fromNBT(nbt.method_10562("fluid"));
        this.ignoreNBT = nbt.method_10577("ignore_nbt");
        this.fluidFilter = FluidStack.fromNbt(nbt.method_10562("fluid_filter"));
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        FluidTankBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
            }
        }
    }

    public void setFluidFilter(FluidStack fluidFilter) {
        this.fluidFilter = new FluidStack(fluidFilter.getFluid(), fluidFilter.getFluidVariant().copyNbt(), fluidFilter.getDropletsAmount());
        FluidTankBlockEntity.method_31663((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_2680)this.method_11010());
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_53002(1);
        fluidFilter.toPacket(buffer);
        buffer.method_52974(0L);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
    }

    public FluidStack getFluid(int tank) {
        return switch (tank) {
            case 0 -> this.fluidStorage.getFluid();
            case 1 -> this.fluidFilter;
            default -> null;
        };
    }

    public long getTankCapacity(int tank) {
        if (tank != 0) {
            return 0L;
        }
        return this.fluidStorage.getCapacity();
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        switch (tank) {
            case 0: {
                this.fluidStorage.setFluid(fluidStack);
                break;
            }
            case 1: {
                this.fluidFilter = new FluidStack(fluidStack.getFluid(), fluidStack.getFluidVariant().copyNbt(), fluidStack.getDropletsAmount());
            }
        }
    }

    @Override
    public void setTankCapacity(int tank, long capacity) {
    }
}

