/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSplitterBlock;
import me.jddev0.ep.block.ModBlockStateProperties;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;

public class ItemConveyorBeltSplitterBlockEntity
extends class_2586 {
    private static final int TICKS_PER_ITEM = ModConfigs.COMMON_ITEM_CONVEYOR_BELT_SPLITTER_TICKS_PER_ITEM.getValue();
    private int currentOutputIndex;

    public ItemConveyorBeltSplitterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.ITEM_CONVEYOR_BELT_SPLITTER_ENTITY, blockPos, blockState);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("current_output_index", this.currentOutputIndex);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.currentOutputIndex = nbt.method_10550("current_output_index");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ItemConveyorBeltSplitterBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (level.method_8510() % (long)TICKS_PER_ITEM == 0L) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)ItemConveyorBeltSplitterBlock.FACING);
            class_2338 inputPos = blockPos.method_10093(facing);
            class_2680 inputBlockState = level.method_8320(inputPos);
            if (!inputBlockState.method_27852(ModBlocks.ITEM_CONVEYOR_BELT)) {
                return;
            }
            ModBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (ModBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.method_11654(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().method_10153() != facing) {
                return;
            }
            class_2586 inputBlockEntity = level.method_8321(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            Storage inputBeltItemStackStorage = (Storage)ItemStorage.SIDED.find(level, inputPos, (Object)facing.method_10153());
            if (inputBeltItemStackStorage == null || !inputBeltItemStackStorage.supportsExtraction()) {
                return;
            }
            class_1799 itemStackToSwitch = class_1799.field_8037;
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView itemView : inputBeltItemStackStorage) {
                    ItemVariant itemVariant;
                    long amount;
                    if (itemView.isResourceBlank() || (amount = inputBeltItemStackStorage.extract((Object)(itemVariant = (ItemVariant)itemView.getResource()), 1L, (TransactionContext)transaction)) <= 0L) continue;
                    itemStackToSwitch = itemVariant.toStack(1);
                    break;
                }
            }
            if (itemStackToSwitch.method_7960()) {
                return;
            }
            for (int j = 0; j < 3; ++j) {
                Storage outputBeltItemStackStorage;
                class_2586 outputBlockEntity;
                class_2350 outputDirection;
                int index = (blockEntity.currentOutputIndex + j) % 3;
                switch (index) {
                    case 0: {
                        class_2350 class_23502 = facing.method_10170();
                        break;
                    }
                    case 1: {
                        class_2350 class_23502 = facing.method_10153();
                        break;
                    }
                    case 2: {
                        class_2350 class_23502 = facing.method_10160();
                        break;
                    }
                    default: {
                        class_2350 class_23502 = outputDirection = null;
                    }
                }
                if (outputDirection == null) {
                    return;
                }
                class_2338 outputPos = blockPos.method_10093(outputDirection);
                class_2680 outputBlockState = level.method_8320(outputPos);
                if (!outputBlockState.method_27852(ModBlocks.ITEM_CONVEYOR_BELT) || !((outputBlockEntity = level.method_8321(outputPos)) instanceof ItemConveyorBeltBlockEntity) || (outputBeltItemStackStorage = (Storage)ItemStorage.SIDED.find(level, outputPos, (Object)outputDirection.method_10153())) == null || !outputBeltItemStackStorage.supportsInsertion()) continue;
                try (Transaction transaction = Transaction.openOuter();){
                    long amount = outputBeltItemStackStorage.insert((Object)ItemVariant.of((class_1799)itemStackToSwitch), 1L, (TransactionContext)transaction);
                    if (amount > 0L) {
                        inputBeltItemStackStorage.extract((Object)ItemVariant.of((class_1799)itemStackToSwitch), 1L, (TransactionContext)transaction);
                    }
                    transaction.commit();
                    if (amount <= 0L) continue;
                    blockEntity.currentOutputIndex = (index + 1) % 3;
                    ItemConveyorBeltSplitterBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
            }
        }
    }
}

