/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.PoweredFurnaceBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.PoweredFurnaceMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3861;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class PoweredFurnaceBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    private static final List<@NotNull class_2960> RECIPE_BLACKLIST = ModConfigs.COMMON_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    public static final long CAPACITY = ModConfigs.COMMON_POWERED_FURNACE_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_POWERED_FURNACE_TRANSFER_RATE.getValue();
    private static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_TICK.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    final CachedSidedInventoryStorage<PoweredFurnaceBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress;
    private long energyConsumptionLeft = -1L;
    private boolean hasEnoughEnergy;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public PoweredFurnaceBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.POWERED_FURNACE_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(2){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PoweredFurnaceBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(PoweredFurnaceBlockEntity.this.field_11863, class_3956.field_17546, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(PoweredFurnaceBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        PoweredFurnaceBlockEntity.this.resetProgress(PoweredFurnaceBlockEntity.this.field_11867, PoweredFurnaceBlockEntity.this.field_11863.method_8320(PoweredFurnaceBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                PoweredFurnaceBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 2).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 0, i -> i == 1);
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                PoweredFurnaceBlockEntity.this.method_5431();
                if (PoweredFurnaceBlockEntity.this.field_11863 != null && !PoweredFurnaceBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(PoweredFurnaceBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(PoweredFurnaceBlockEntity.this.method_11016(), (class_3218)PoweredFurnaceBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(PoweredFurnaceBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(PoweredFurnaceBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(PoweredFurnaceBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (PoweredFurnaceBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> PoweredFurnaceBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> PoweredFurnaceBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        PoweredFurnaceBlockEntity.this.progress = ByteUtils.with2Bytes(PoweredFurnaceBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        PoweredFurnaceBlockEntity.this.maxProgress = ByteUtils.with2Bytes(PoweredFurnaceBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        PoweredFurnaceBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        PoweredFurnaceBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.powered_furnace");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new PoweredFurnaceMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.max_progress", (class_2520)class_2497.method_23247((int)this.maxProgress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.progress = nbt.method_10550("recipe.progress");
        this.maxProgress = nbt.method_10550("recipe.max_progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, PoweredFurnaceBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)PoweredFurnaceBlock.POWERED))) {
            return;
        }
        if (PoweredFurnaceBlockEntity.hasRecipe(blockEntity)) {
            Optional<class_8786<class_3861>> recipe = blockEntity.getRecipeFor((class_1263)blockEntity.internalInventory, level);
            if (recipe.isEmpty()) {
                return;
            }
            int cookingTime = ((class_3861)recipe.get().comp_1933()).method_8167();
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = (int)Math.ceil((float)cookingTime * RECIPE_DURATION_MULTIPLIER / 6.0f);
            }
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * (long)blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.internalEnergyStorage.amount) {
                if (!level.method_8320(blockPos).method_28498((class_2769)PoweredFurnaceBlock.LIT) || !((Boolean)level.method_8320(blockPos).method_11654((class_2769)PoweredFurnaceBlock.LIT)).booleanValue()) {
                    blockEntity.hasEnoughEnergy = true;
                    level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)PoweredFurnaceBlock.LIT, (Comparable)Boolean.TRUE), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    PoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_TICK, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    PoweredFurnaceBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                PoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                PoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            PoweredFurnaceBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = true;
        this.field_11863.method_8652(blockPos, (class_2680)state.method_11657((class_2769)PoweredFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
    }

    private static void craftItem(class_2338 blockPos, class_2680 state, PoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional<class_8786<class_3861>> recipe = blockEntity.getRecipeFor((class_1263)blockEntity.internalInventory, level);
        if (!PoweredFurnaceBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.internalInventory.method_5434(0, 1);
        blockEntity.internalInventory.method_5447(1, ((class_3861)recipe.get().comp_1933()).method_8110(level.method_30349()).method_46651(blockEntity.internalInventory.method_5438(1).method_7947() + ((class_3861)recipe.get().comp_1933()).method_8110(level.method_30349()).method_7947()));
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(PoweredFurnaceBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional<class_8786<class_3861>> recipe = blockEntity.getRecipeFor((class_1263)blockEntity.internalInventory, level);
        return recipe.isPresent() && PoweredFurnaceBlockEntity.canInsertItemIntoOutputSlot(blockEntity.internalInventory, ((class_3861)recipe.get().comp_1933()).method_8110(level.method_30349()));
    }

    private static boolean canInsertItemIntoOutputSlot(class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(1);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    private Optional<class_8786<class_3861>> getRecipeFor(class_1263 container, class_1937 level) {
        return level.method_8433().method_30027(class_3956.field_17546).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.comp_1932())).filter(recipe -> ((class_3861)recipe.comp_1933()).method_8115(container, level)).findFirst();
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

