/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.PoweredLampBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class PoweredLampBlockEntity
extends class_2586
implements EnergyStoragePacketUpdate {
    public static final long MAX_RECEIVE = ModConfigs.COMMON_POWERED_LAMP_TRANSFER_RATE.getValue();
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage = new EnergizedPowerEnergyStorage(MAX_RECEIVE, MAX_RECEIVE, MAX_RECEIVE){

        protected void onFinalCommit() {
            PoweredLampBlockEntity.this.method_5431();
            if (PoweredLampBlockEntity.this.field_11863 != null && !PoweredLampBlockEntity.this.field_11863.method_8608()) {
                class_2540 buffer = PacketByteBufs.create();
                buffer.method_52974(this.amount);
                buffer.method_52974(this.capacity);
                buffer.method_10807(PoweredLampBlockEntity.this.method_11016());
                ModMessages.sendServerPacketToPlayersWithinXBlocks(PoweredLampBlockEntity.this.method_11016(), (class_3218)PoweredLampBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
            }
        }
    };

    public PoweredLampBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.POWERED_LAMP_ENTITY, blockPos, blockState);
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, PoweredLampBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        boolean isEmptyFlag = blockEntity.internalEnergyStorage.amount == 0L;
        int levelValue = Math.min(class_3532.method_15375((float)((float)blockEntity.internalEnergyStorage.amount / (float)blockEntity.energyStorage.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
        if ((Integer)state.method_11654((class_2769)PoweredLampBlock.LEVEL) != levelValue) {
            level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)PoweredLampBlock.LEVEL, (Comparable)Integer.valueOf(levelValue)), 3);
        }
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.extract(blockEntity.internalEnergyStorage.amount, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

