/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.SawmillBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.recipe.SawmillRecipe;
import me.jddev0.ep.screen.SawmillMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class SawmillBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    public static final long CAPACITY = ModConfigs.COMMON_SAWMILL_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_SAWMILL_TRANSFER_RATE.getValue();
    private static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_SAWMILL_ENERGY_CONSUMPTION_PER_TICK.getValue();
    final CachedSidedInventoryStorage<SawmillBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    protected final class_3913 data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_SAWMILL_RECIPE_DURATION.getValue();
    private long energyConsumptionLeft = -1L;
    private boolean hasEnoughEnergy;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.ITEM;

    public SawmillBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.SAWMILL_ENTITY, blockPos, blockState);
        this.internalInventory = new class_1277(3){

            public boolean method_5437(int slot, class_1799 stack) {
                return switch (slot) {
                    case 0 -> {
                        if (SawmillBlockEntity.this.field_11863 == null || RecipeUtils.isIngredientOfAny(SawmillBlockEntity.this.field_11863, SawmillRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1, 2 -> false;
                    default -> super.method_5437(slot, stack);
                };
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(SawmillBlockEntity.this.field_11863 == null || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && class_1799.method_31577((class_1799)stack, (class_1799)itemStack))) {
                        SawmillBlockEntity.this.resetProgress(SawmillBlockEntity.this.field_11867, SawmillBlockEntity.this.field_11863.method_8320(SawmillBlockEntity.this.field_11867));
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                SawmillBlockEntity.this.method_5431();
            }
        };
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 3).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> i == 0, i -> i == 1 || i == 2);
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                SawmillBlockEntity.this.method_5431();
                if (SawmillBlockEntity.this.field_11863 != null && !SawmillBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(SawmillBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(SawmillBlockEntity.this.method_11016(), (class_3218)SawmillBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
        this.data = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(SawmillBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(SawmillBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(SawmillBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (SawmillBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> SawmillBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> SawmillBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        SawmillBlockEntity.this.progress = ByteUtils.with2Bytes(SawmillBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        SawmillBlockEntity.this.maxProgress = ByteUtils.with2Bytes(SawmillBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        SawmillBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        SawmillBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.sawmill");
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> class_1703.method_7618((class_1263)this.internalInventory);
            case ComparatorMode.FLUID -> 0;
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new SawmillMenu(id, this, inventory, (class_1263)this.internalInventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("recipe.progress", (class_2520)class_2497.method_23247((int)this.progress));
        nbt.method_10566("recipe.energy_consumption_left", (class_2520)class_2503.method_23251((long)this.energyConsumptionLeft));
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.progress = nbt.method_10550("recipe.progress");
        this.energyConsumptionLeft = nbt.method_10537("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode"));
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, SawmillBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)SawmillBlock.POWERED))) {
            return;
        }
        if (SawmillBlockEntity.hasRecipe(blockEntity)) {
            Optional recipe = level.method_8433().method_8132((class_3956)SawmillRecipe.Type.INSTANCE, (class_1263)blockEntity.internalInventory, level);
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.energyConsumptionLeft < 0L) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * (long)blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.internalEnergyStorage.amount) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0L) {
                    blockEntity.resetProgress(blockPos, state);
                    SawmillBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                    return;
                }
                try (Transaction transaction = Transaction.openOuter();){
                    blockEntity.internalEnergyStorage.extract(ENERGY_USAGE_PER_TICK, (TransactionContext)transaction);
                    transaction.commit();
                }
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    SawmillBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                SawmillBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                SawmillBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            SawmillBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1L;
        this.hasEnoughEnergy = true;
    }

    private static void craftItem(class_2338 blockPos, class_2680 state, SawmillBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional recipe = level.method_8433().method_8132((class_3956)SawmillRecipe.Type.INSTANCE, (class_1263)blockEntity.internalInventory, level);
        if (!SawmillBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.internalInventory.method_5434(0, 1);
        blockEntity.internalInventory.method_5447(1, ((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(level.method_30349()).method_46651(blockEntity.internalInventory.method_5438(1).method_7947() + ((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(level.method_30349()).method_7947()));
        if (!((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).getSecondaryOutput().method_7960()) {
            blockEntity.internalInventory.method_5447(2, ((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).getSecondaryOutput().method_46651(blockEntity.internalInventory.method_5438(2).method_7947() + ((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).getSecondaryOutput().method_7947()));
        }
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(SawmillBlockEntity blockEntity) {
        class_1937 level = blockEntity.field_11863;
        Optional recipe = level.method_8433().method_8132((class_3956)SawmillRecipe.Type.INSTANCE, (class_1263)blockEntity.internalInventory, level);
        return recipe.isPresent() && SawmillBlockEntity.canInsertItemIntoOutputSlot(blockEntity.internalInventory, ((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(level.method_30349())) && (((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).getSecondaryOutput().method_7960() || SawmillBlockEntity.canInsertItemIntoSecondaryOutputSlot(blockEntity.internalInventory, ((SawmillRecipe)((class_8786)recipe.get()).comp_1933()).getSecondaryOutput()));
    }

    private static boolean canInsertItemIntoOutputSlot(class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(1);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    private static boolean canInsertItemIntoSecondaryOutputSlot(class_1277 inventory, class_1799 itemStack) {
        class_1799 inventoryItemStack = inventory.method_5438(2);
        return (inventoryItemStack.method_7960() || class_1799.method_31577((class_1799)inventoryItemStack, (class_1799)itemStack)) && inventoryItemStack.method_7914() >= inventoryItemStack.method_7947() + itemStack.method_7947();
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.FLUID);
        this.method_5431();
    }
}

