/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.SolarPanelBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.SolarPanelMenu;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class SolarPanelBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate {
    private final SolarPanelBlock.Tier tier;
    private final long maxTransfer;
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;

    public static class_2591<SolarPanelBlockEntity> getEntityTypeFromTier(SolarPanelBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case SolarPanelBlock.Tier.TIER_1 -> ModBlockEntities.SOLAR_PANEL_ENTITY_1;
            case SolarPanelBlock.Tier.TIER_2 -> ModBlockEntities.SOLAR_PANEL_ENTITY_2;
            case SolarPanelBlock.Tier.TIER_3 -> ModBlockEntities.SOLAR_PANEL_ENTITY_3;
            case SolarPanelBlock.Tier.TIER_4 -> ModBlockEntities.SOLAR_PANEL_ENTITY_4;
            case SolarPanelBlock.Tier.TIER_5 -> ModBlockEntities.SOLAR_PANEL_ENTITY_5;
            case SolarPanelBlock.Tier.TIER_6 -> ModBlockEntities.SOLAR_PANEL_ENTITY_6;
        };
    }

    public SolarPanelBlockEntity(class_2338 blockPos, class_2680 blockState, SolarPanelBlock.Tier tier) {
        super(SolarPanelBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.maxTransfer = tier.getMaxTransfer();
        long capacity = tier.getCapacity();
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(capacity, capacity, capacity){

            protected void onFinalCommit() {
                SolarPanelBlockEntity.this.method_5431();
                if (SolarPanelBlockEntity.this.field_11863 != null && !SolarPanelBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(SolarPanelBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(SolarPanelBlockEntity.this.method_11016(), (class_3218)SolarPanelBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, 0L, this.maxTransfer);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)("container.energizedpower." + this.tier.getResourceId()));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new SolarPanelMenu(id, this, inventory);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public SolarPanelBlock.Tier getTier() {
        return this.tier;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, SolarPanelBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        int i = 4 * (level.method_8314(class_1944.field_9284, blockPos) - level.method_8594());
        float f = level.method_8442(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * class_3532.method_15362((float)f));
        }
        i = class_3532.method_15340((int)i, (int)0, (int)60);
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.insert((long)((float)i / 60.0f * (float)blockEntity.getTier().getPeakFePerTick()), (TransactionContext)transaction);
            transaction.commit();
        }
        SolarPanelBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, SolarPanelBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        class_2338 testPos = blockPos.method_10093(class_2350.field_11033);
        class_2586 testBlockEntity = level.method_8321(testPos);
        if (testBlockEntity == null) {
            return;
        }
        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)class_2350.field_11033.method_10153());
        if (energyStorage == null) {
            return;
        }
        if (!energyStorage.supportsInsertion()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long amount = energyStorage.insert(Math.min(blockEntity.internalEnergyStorage.amount, blockEntity.maxTransfer), (TransactionContext)transaction);
            blockEntity.energyStorage.extract(amount, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

