/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.entity.BlockPlacerBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.CachedSidedInventoryStorage;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.block.entity.handler.SidedInventoryWrapper;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.item.ModItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.TeleporterMenu;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_5894;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class TeleporterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate {
    public static final boolean INTRA_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_ENABLED.getValue();
    public static final boolean INTER_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_ENABLED.getValue();
    public static final List<@NotNull class_2960> DIMENSION_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTRA_DIMENSIONAL_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_FROM_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_TO_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> DIMENSION_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTRA_DIMENSIONAL_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull class_2960> INTER_DIMENSIONAL_TO_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.getValue();
    public static final long CAPACITY = ModConfigs.COMMON_TELEPORTER_CAPACITY.getValue();
    public static final long MAX_RECEIVE = ModConfigs.COMMON_TELEPORTER_TRANSFER_RATE.getValue();
    final CachedSidedInventoryStorage<BlockPlacerBlockEntity> cachedSidedInventoryStorage;
    final InputOutputItemHandler inventory;
    private final class_1277 internalInventory = new class_1277(1){

        public int method_5444() {
            return 1;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            if (slot == 0) {
                return stack.method_31574(ModItems.TELEPORTER_MATRIX);
            }
            return super.method_5437(slot, stack);
        }

        public void method_5431() {
            super.method_5431();
            TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
        }
    };
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;

    public TeleporterBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.TELEPORTER_ENTITY, blockPos, blockState);
        this.inventory = new InputOutputItemHandler(new SidedInventoryWrapper((class_1263)this.internalInventory){

            public int[] method_5494(class_2350 side) {
                return IntStream.range(0, 1).toArray();
            }

            public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
                return this.method_5437(slot, stack);
            }

            public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
                return true;
            }
        }, (i, stack) -> true, i -> true);
        this.cachedSidedInventoryStorage = new CachedSidedInventoryStorage(this.inventory);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
                if (TeleporterBlockEntity.this.field_11863 != null && !TeleporterBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(TeleporterBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(TeleporterBlockEntity.this.method_11016(), (class_3218)TeleporterBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, MAX_RECEIVE, 0L);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.teleporter");
    }

    public int getRedstoneOutput() {
        return class_1703.method_7618((class_1263)this.internalInventory);
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        return new TeleporterMenu(id, this, inventory, (class_1263)this.internalInventory);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.internalInventory.field_5828));
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)this.internalInventory.field_5828);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public void drops(class_1937 level, class_2338 worldPosition) {
        class_1264.method_17349((class_1937)level, (class_2338)worldPosition, (class_2371)this.internalInventory.field_5828);
    }

    public void setChangedAndUpdateReadyState() {
        boolean powered;
        boolean oldPowered = this.field_11863.method_8320(this.field_11867).method_28498((class_2769)TeleporterBlock.POWERED) && (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)TeleporterBlock.POWERED) != false;
        class_1799 teleporterMatrixItemStack = this.internalInventory.method_5438(0);
        boolean bl = powered = this.internalEnergyStorage.amount == this.internalEnergyStorage.capacity && teleporterMatrixItemStack.method_31574(ModItems.TELEPORTER_MATRIX) && TeleporterMatrixItem.isLinked(teleporterMatrixItemStack);
        if (oldPowered ^ powered) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TeleporterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        this.method_5431();
    }

    public void onRedstoneTriggered() {
        class_3222 serverPlayer;
        class_1657 class_16572;
        block6: {
            block5: {
                if (Transaction.isOpen()) {
                    return;
                }
                Optional<class_1657> player = this.field_11863.method_18023(class_5575.method_31795(class_1657.class), class_238.method_19316((class_3341)class_3341.method_34390((class_2382)new class_2382(this.field_11867.method_10263() - 2, this.field_11867.method_10264() - 2, this.field_11867.method_10260() - 2), (class_2382)new class_2382(this.field_11867.method_10263() + 2, this.field_11867.method_10264() + 2, this.field_11867.method_10260() + 2))), class_1301.field_6155.and(entity -> entity.method_5707(this.field_11867.method_46558()) <= 4.0)).stream().min(Comparator.comparing(entity -> entity.method_5707(this.field_11867.method_46558())));
                if (player.isEmpty()) {
                    return;
                }
                class_16572 = player.get();
                if (!(class_16572 instanceof class_3222)) break block5;
                serverPlayer = (class_3222)class_16572;
                class_16572 = this.field_11863;
                if (class_16572 instanceof class_3218) break block6;
            }
            return;
        }
        class_3218 serverLevel = (class_3218)class_16572;
        serverLevel.method_8503().method_5382(() -> this.teleportPlayer(serverPlayer));
    }

    public void teleportPlayer(class_3222 player) {
        class_2960 toDimensionId;
        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(player.method_37908(), this.field_11867, null);
        if (energyStorage == null) {
            return;
        }
        if (energyStorage.getAmount() < CAPACITY) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.not_enough_energy").method_27692(class_124.field_1061)));
            return;
        }
        class_1799 teleporterMatrixItemStack = this.getStack(0);
        if (!teleporterMatrixItemStack.method_31574(ModItems.TELEPORTER_MATRIX)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.no_teleporter_matrix").method_27692(class_124.field_1061)));
            return;
        }
        if (!TeleporterMatrixItem.isLinked(teleporterMatrixItemStack)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_not_bound").method_27692(class_124.field_1061)));
            return;
        }
        class_2338 toPos = TeleporterMatrixItem.getBlockPos(this.field_11863, teleporterMatrixItemStack);
        if (toPos == null) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_position").method_27692(class_124.field_1061)));
            return;
        }
        class_1937 toDimension = TeleporterMatrixItem.getDimension(this.field_11863, teleporterMatrixItemStack);
        if (!(toDimension instanceof class_3218)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_dimension").method_27692(class_124.field_1061)));
            return;
        }
        if (this.field_11867.equals((Object)toPos) && this.field_11863.method_27983().equals(toDimension.method_27983())) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_self_position").method_27692(class_124.field_1061)));
            return;
        }
        class_2960 fromDimensionId = this.field_11863.method_27983().method_29177();
        boolean intraDimensional = fromDimensionId.equals((Object)(toDimensionId = toDimension.method_27983().method_29177()));
        if (intraDimensional && !INTRA_DIMENSIONAL_ENABLED) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.intra_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && !INTER_DIMENSIONAL_ENABLED) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.inter_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(fromDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(toDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{toDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_BLACKLIST.contains(fromDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_BLACKLIST.contains(fromDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from", (Object[])new Object[]{fromDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_BLACKLIST.contains(toDimensionId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to", (Object[])new Object[]{toDimensionId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        class_2960 fromDimensionTypeId = this.field_11863.method_44013().method_29177();
        class_2960 toDimensionTypeId = toDimension.method_44013().method_29177();
        if (DIMENSION_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (DIMENSION_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{toDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to_type", (Object[])new Object[]{toDimensionTypeId.toString()}).method_27692(class_124.field_1061)));
            return;
        }
        class_2586 toBlockEntity = toDimension.method_8321(toPos);
        if (!(toBlockEntity instanceof TeleporterBlockEntity)) {
            player.field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_no_teleporter").method_27692(class_124.field_1061)));
            return;
        }
        this.clearEnergy();
        class_243 toPosCenter = toPos.method_46558();
        player.method_48105((class_3218)toDimension, toPosCenter.method_10216(), (double)(toPos.method_10264() + 1), toPosCenter.method_10215(), new HashSet(), 0.0f, 0.0f);
        player.field_13987.method_14364((class_2596)new class_2767(class_6880.method_40223((Object)class_3417.field_14879), class_3419.field_15245, toPosCenter.method_10216(), (double)toPos.method_10264(), toPosCenter.method_10215(), 1.0f, 1.0f, toDimension.method_8409().method_43055()));
    }

    public int getSlotCount() {
        return this.internalInventory.method_5439();
    }

    public class_1799 getStack(int slot) {
        return this.internalInventory.method_5438(slot);
    }

    public void clearEnergy() {
        try (Transaction transaction = Transaction.openOuter();){
            this.internalEnergyStorage.extract(CAPACITY, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

