/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.block.ThermalGeneratorBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.recipe.ThermalGeneratorRecipe;
import me.jddev0.ep.screen.ThermalGeneratorMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class ThermalGeneratorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
EnergyStoragePacketUpdate,
FluidStoragePacketUpdate,
RedstoneModeUpdate,
ComparatorModeUpdate {
    private static final long CAPACITY = ModConfigs.COMMON_THERMAL_GENERATOR_CAPACITY.getValue();
    private static final long MAX_EXTRACT = ModConfigs.COMMON_THERMAL_GENERATOR_TRANSFER_RATE.getValue();
    public static final double ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_THERMAL_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue();
    final LimitingEnergyStorage energyStorage;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;
    final SimpleFluidStorage fluidStorage;
    protected final class_3913 data;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    private ComparatorMode comparatorMode = ComparatorMode.FLUID;

    public ThermalGeneratorBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.THERMAL_GENERATOR_ENTITY, blockPos, blockState);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(CAPACITY, CAPACITY, CAPACITY){

            protected void onFinalCommit() {
                ThermalGeneratorBlockEntity.this.method_5431();
                if (ThermalGeneratorBlockEntity.this.field_11863 != null && !ThermalGeneratorBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(ThermalGeneratorBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(ThermalGeneratorBlockEntity.this.method_11016(), (class_3218)ThermalGeneratorBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorage = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, 0L, MAX_EXTRACT);
        this.fluidStorage = new SimpleFluidStorage(FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_THERMAL_GENERATOR_FLUID_TANK_CAPACITY.getValue() * 1000L)){

            protected void onFinalCommit() {
                ThermalGeneratorBlockEntity.this.method_5431();
                if (ThermalGeneratorBlockEntity.this.field_11863 != null && !ThermalGeneratorBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_53002(0);
                    this.getFluid().toPacket(buffer);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(ThermalGeneratorBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(ThermalGeneratorBlockEntity.this.method_11016(), (class_3218)ThermalGeneratorBlockEntity.this.field_11863, 32.0, ModMessages.FLUID_SYNC_ID, buffer);
                }
            }

            private boolean isFluidValid(FluidVariant variant) {
                if (ThermalGeneratorBlockEntity.this.field_11863 == null) {
                    return false;
                }
                List recipes = ThermalGeneratorBlockEntity.this.field_11863.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
                return recipes.stream().map(class_8786::comp_1933).map(ThermalGeneratorRecipe::getInput).anyMatch(inputs -> Arrays.stream(inputs).anyMatch(input -> variant.getFluid() == input));
            }

            protected boolean canInsert(FluidVariant variant) {
                return this.isFluidValid(variant);
            }

            protected boolean canExtract(FluidVariant variant) {
                return this.isFluidValid(variant);
            }
        };
        this.data = new class_3913(){

            public int method_17390(int index) {
                if (index == 4) {
                    return ThermalGeneratorBlockEntity.this.redstoneMode.ordinal();
                }
                if (index == 5) {
                    return ThermalGeneratorBlockEntity.this.comparatorMode.ordinal();
                }
                if (ThermalGeneratorBlockEntity.this.field_11863 == null || index > 3) {
                    return 0;
                }
                List recipes = ThermalGeneratorBlockEntity.this.field_11863.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
                long rawProduction = 0L;
                block3: for (class_8786 recipe : recipes) {
                    for (class_3611 fluid : ((ThermalGeneratorRecipe)recipe.comp_1933()).getInput()) {
                        if (ThermalGeneratorBlockEntity.this.fluidStorage.getFluid().getFluid() != fluid) continue;
                        rawProduction = ((ThermalGeneratorRecipe)recipe.comp_1933()).getEnergyProduction();
                        rawProduction = (long)((double)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                        break block3;
                    }
                }
                long productionLeft = (long)((double)(rawProduction * ThermalGeneratorBlockEntity.this.fluidStorage.getFluid().getMilliBucketsAmount()) / 1000.0);
                return switch (index) {
                    case 0, 1, 2, 3 -> ByteUtils.get2Bytes(productionLeft, index);
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        ThermalGeneratorBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 5: {
                        ThermalGeneratorBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 6;
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.thermal_generator");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_52974(this.internalEnergyStorage.amount);
        buffer.method_52974(this.internalEnergyStorage.capacity);
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.ENERGY_SYNC_ID, buffer);
        buffer = PacketByteBufs.create();
        buffer.method_53002(0);
        this.fluidStorage.getFluid().toPacket(buffer);
        buffer.method_52974(this.fluidStorage.getCapacity());
        buffer.method_10807(this.method_11016());
        ModMessages.sendServerPacketToPlayer((class_3222)player, ModMessages.FLUID_SYNC_ID, buffer);
        return new ThermalGeneratorMenu(id, this, inventory, this.data);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ComparatorMode.ITEM -> 0;
            case ComparatorMode.FLUID -> FluidUtils.getRedstoneSignalFromFluidHandler((Storage<FluidVariant>)this.fluidStorage);
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage((EnergyStorage)this.energyStorage);
        };
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        nbt.method_10566("fluid", (class_2520)this.fluidStorage.toNBT(new class_2487()));
        nbt.method_10569("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.method_10569("configuration.comparator_mode", this.comparatorMode.ordinal());
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
        this.fluidStorage.fromNBT(nbt.method_10562("fluid"));
        this.redstoneMode = RedstoneMode.fromIndex(nbt.method_10550("configuration.redstone_mode"));
        this.comparatorMode = nbt.method_10545("configuration.comparator_mode") ? ComparatorMode.fromIndex(nbt.method_10550("configuration.comparator_mode")) : ComparatorMode.FLUID;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)ThermalGeneratorBlock.POWERED))) {
            ThermalGeneratorBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        ThermalGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(class_1937 level, class_2338 blockPos, class_2680 state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        List recipes = level.method_8433().method_30027((class_3956)ThermalGeneratorRecipe.Type.INSTANCE);
        long rawProduction = 0L;
        block5: for (class_8786 recipe : recipes) {
            for (class_3611 fluid : ((ThermalGeneratorRecipe)recipe.comp_1933()).getInput()) {
                if (blockEntity.fluidStorage.getFluid().getFluid() != fluid) continue;
                rawProduction = ((ThermalGeneratorRecipe)recipe.comp_1933()).getEnergyProduction();
                rawProduction = (long)((double)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                break block5;
            }
        }
        if (rawProduction > 0L && blockEntity.internalEnergyStorage.amount < blockEntity.internalEnergyStorage.capacity) {
            long production = (long)((double)rawProduction * ((double)Math.min(blockEntity.fluidStorage.getFluid().getMilliBucketsAmount(), 50L) / 1000.0));
            production = Math.min(production, blockEntity.internalEnergyStorage.capacity - blockEntity.internalEnergyStorage.amount);
            long fluidAmount = (long)((double)production / (double)rawProduction * 1000.0);
            production = (long)((double)(rawProduction * fluidAmount) / 1000.0);
            try (Transaction transaction = Transaction.openOuter();){
                blockEntity.fluidStorage.extract((TransferVariant)((FluidVariant)blockEntity.fluidStorage.variant), FluidUtils.convertMilliBucketsToDroplets(fluidAmount), (TransactionContext)transaction);
                blockEntity.internalEnergyStorage.insert(production, (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }

    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        LinkedList<EnergyStorage> consumerItems = new LinkedList<EnergyStorage>();
        LinkedList<Long> consumerEnergyValues = new LinkedList<Long>();
        int consumptionSum = 0;
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage energyStorage;
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153())) == null || !energyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = energyStorage.insert(Math.min(MAX_EXTRACT, blockEntity.internalEnergyStorage.amount), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum = (int)((long)consumptionSum + received);
                consumerItems.add(energyStorage);
                consumerEnergyValues.add(received);
            }
        }
        LinkedList<Long> consumerEnergyDistributed = new LinkedList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(MAX_EXTRACT, Math.min(blockEntity.internalEnergyStorage.amount, (long)consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.extract(consumptionLeft, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block18: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block18;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public long getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }

    public long getEnergy() {
        return this.internalEnergyStorage.amount;
    }

    public long getCapacity() {
        return this.internalEnergyStorage.capacity;
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, long capacity) {
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.method_5431();
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.ITEM);
        this.method_5431();
    }
}

