/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import me.jddev0.ep.block.TransformerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class TransformerBlockEntity
extends class_2586
implements EnergyStoragePacketUpdate {
    private final long maxTransferRate;
    private final TransformerBlock.Tier tier;
    private final TransformerBlock.Type type;
    final LimitingEnergyStorage energyStorageInsert;
    final LimitingEnergyStorage energyStorageExtract;
    private final EnergizedPowerEnergyStorage internalEnergyStorage;

    public static class_2591<TransformerBlockEntity> getEntityTypeFromTierAndType(TransformerBlock.Tier tier, TransformerBlock.Type type) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case TransformerBlock.Tier.TIER_LV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield ModBlockEntities.LV_TRANSFORMER_1_TO_N_ENTITY;
                    }
                    case TYPE_3_TO_3: {
                        yield ModBlockEntities.LV_TRANSFORMER_3_TO_3_ENTITY;
                    }
                    case TYPE_N_TO_1: 
                }
                yield ModBlockEntities.LV_TRANSFORMER_N_TO_1_ENTITY;
            }
            case TransformerBlock.Tier.TIER_MV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield ModBlockEntities.MV_TRANSFORMER_1_TO_N_ENTITY;
                    }
                    case TYPE_3_TO_3: {
                        yield ModBlockEntities.MV_TRANSFORMER_3_TO_3_ENTITY;
                    }
                    case TYPE_N_TO_1: 
                }
                yield ModBlockEntities.MV_TRANSFORMER_N_TO_1_ENTITY;
            }
            case TransformerBlock.Tier.TIER_HV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield ModBlockEntities.HV_TRANSFORMER_1_TO_N_ENTITY;
                    }
                    case TYPE_3_TO_3: {
                        yield ModBlockEntities.HV_TRANSFORMER_3_TO_3_ENTITY;
                    }
                    case TYPE_N_TO_1: 
                }
                yield ModBlockEntities.HV_TRANSFORMER_N_TO_1_ENTITY;
            }
            case TransformerBlock.Tier.TIER_EHV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield ModBlockEntities.EHV_TRANSFORMER_1_TO_N_ENTITY;
                    }
                    case TYPE_3_TO_3: {
                        yield ModBlockEntities.EHV_TRANSFORMER_3_TO_3_ENTITY;
                    }
                    case TYPE_N_TO_1: 
                }
                yield ModBlockEntities.EHV_TRANSFORMER_N_TO_1_ENTITY;
            }
        };
    }

    public static long getMaxEnergyTransferFromTier(TransformerBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case TransformerBlock.Tier.TIER_LV -> ModConfigs.COMMON_LV_TRANSFORMERS_TRANSFER_RATE.getValue();
            case TransformerBlock.Tier.TIER_MV -> ModConfigs.COMMON_MV_TRANSFORMERS_TRANSFER_RATE.getValue();
            case TransformerBlock.Tier.TIER_HV -> ModConfigs.COMMON_HV_TRANSFORMERS_TRANSFER_RATE.getValue();
            case TransformerBlock.Tier.TIER_EHV -> ModConfigs.COMMON_EHV_TRANSFORMERS_TRANSFER_RATE.getValue();
        };
    }

    public TransformerBlockEntity(class_2338 blockPos, class_2680 blockState, TransformerBlock.Tier tier, TransformerBlock.Type type) {
        super(TransformerBlockEntity.getEntityTypeFromTierAndType(tier, type), blockPos, blockState);
        this.tier = tier;
        this.type = type;
        this.maxTransferRate = TransformerBlockEntity.getMaxEnergyTransferFromTier(this.tier);
        this.internalEnergyStorage = new EnergizedPowerEnergyStorage(this.maxTransferRate, this.maxTransferRate, this.maxTransferRate){

            protected void onFinalCommit() {
                TransformerBlockEntity.this.method_5431();
                if (TransformerBlockEntity.this.field_11863 != null && !TransformerBlockEntity.this.field_11863.method_8608()) {
                    class_2540 buffer = PacketByteBufs.create();
                    buffer.method_52974(this.amount);
                    buffer.method_52974(this.capacity);
                    buffer.method_10807(TransformerBlockEntity.this.method_11016());
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(TransformerBlockEntity.this.method_11016(), (class_3218)TransformerBlockEntity.this.field_11863, 32.0, ModMessages.ENERGY_SYNC_ID, buffer);
                }
            }
        };
        this.energyStorageInsert = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, this.maxTransferRate, 0L);
        this.energyStorageExtract = new LimitingEnergyStorage((EnergyStorage)this.internalEnergyStorage, 0L, this.maxTransferRate);
    }

    public TransformerBlock.Type getTransformerType() {
        return this.type;
    }

    public TransformerBlock.Tier getTier() {
        return this.tier;
    }

    EnergyStorage getEnergyStorageForDirection(class_2350 side) {
        if (side == null) {
            return this.internalEnergyStorage;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)TransformerBlock.FACING);
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case TransformerBlock.Type.TYPE_1_TO_N, TransformerBlock.Type.TYPE_N_TO_1 -> {
                LimitingEnergyStorage multipleSide;
                LimitingEnergyStorage singleSide = this.type == TransformerBlock.Type.TYPE_1_TO_N ? this.energyStorageInsert : this.energyStorageExtract;
                LimitingEnergyStorage v0 = multipleSide = this.type == TransformerBlock.Type.TYPE_1_TO_N ? this.energyStorageExtract : this.energyStorageInsert;
                if (facing == side) {
                    yield singleSide;
                }
                yield multipleSide;
            }
            case TransformerBlock.Type.TYPE_3_TO_3 -> facing.method_35834(class_2350.class_2351.field_11048) == side || facing.method_35834(class_2350.class_2351.field_11052) == side || facing.method_35834(class_2350.class_2351.field_11051) == side ? this.energyStorageInsert : this.energyStorageExtract;
        };
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.internalEnergyStorage.amount);
        super.method_11007(nbt);
    }

    public void method_11014(@NotNull class_2487 nbt) {
        super.method_11014(nbt);
        this.internalEnergyStorage.amount = nbt.method_10537("energy");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, TransformerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        TransformerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    /*
     * WARNING - void declaration
     */
    private static void transferEnergy(class_1937 level, class_2338 blockPos, class_2680 state, TransformerBlockEntity blockEntity) {
        void var10_14;
        if (level.method_8608()) {
            return;
        }
        LinkedList<Object> outputDirections = new LinkedList<Object>();
        class_2350 facing = (class_2350)state.method_11654((class_2769)TransformerBlock.FACING);
        block20: for (class_2350 side : class_2350.values()) {
            switch (blockEntity.getTransformerType()) {
                case TYPE_1_TO_N: 
                case TYPE_N_TO_1: {
                    boolean isOutputMultipleSide;
                    boolean bl = blockEntity.getTransformerType() != TransformerBlock.Type.TYPE_1_TO_N;
                    boolean bl2 = isOutputMultipleSide = blockEntity.getTransformerType() == TransformerBlock.Type.TYPE_1_TO_N;
                    if (facing == side) {
                        if (!bl) continue block20;
                        outputDirections.add(side);
                        continue block20;
                    }
                    if (!isOutputMultipleSide) continue block20;
                    outputDirections.add(side);
                    continue block20;
                }
                case TYPE_3_TO_3: {
                    if (facing.method_35834(class_2350.class_2351.field_11048) == side || facing.method_35834(class_2350.class_2351.field_11052) == side || facing.method_35834(class_2350.class_2351.field_11051) == side) continue block20;
                    outputDirections.add(side);
                }
            }
        }
        LinkedList<EnergyStorage> consumerItems = new LinkedList<EnergyStorage>();
        LinkedList<Long> consumerEnergyValues = new LinkedList<Long>();
        int consumptionSum = 0;
        for (class_2350 class_23502 : outputDirections) {
            EnergyStorage energyStorage;
            class_2338 testPos = blockPos.method_10093(class_23502);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null || (energyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)class_23502.method_10153())) == null || !energyStorage.supportsInsertion()) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                long received = energyStorage.insert(Math.min(blockEntity.maxTransferRate, blockEntity.internalEnergyStorage.amount), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum = (int)((long)consumptionSum + received);
                consumerItems.add(energyStorage);
                consumerEnergyValues.add(received);
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        LinkedList<Long> consumerEnergyDistributed = new LinkedList<Long>();
        boolean bl = false;
        while (var10_14 < consumerItems.size()) {
            consumerEnergyDistributed.add(0L);
            ++var10_14;
        }
        long l = Math.min(blockEntity.maxTransferRate, Math.min(blockEntity.internalEnergyStorage.amount, (long)consumptionSum));
        try (Transaction transaction = Transaction.openOuter();){
            blockEntity.internalEnergyStorage.extract(l, (TransactionContext)transaction);
            transaction.commit();
        }
        int divisor = consumerItems.size();
        block23: while (l > 0L) {
            long consumptionPerConsumer = l / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = l / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, l));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((l -= consumptionDistributedNew) == 0L) break block23;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    @Override
    public void setEnergy(long energy) {
        this.internalEnergyStorage.amount = energy;
    }

    @Override
    public void setCapacity(long capacity) {
        this.internalEnergyStorage.capacity = capacity;
    }
}

