/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumConfigValue<T extends Enum<T>>
extends ConfigValue<T> {
    private final ArrayList<T> ENUM_VALUES;
    private final Function<String, T> VALUE_OF_FUNCTION;

    public EnumConfigValue(@NotNull String key, @NotNull T defaultValue, @NotNull @NotNull T @NotNull [] enumValues, @NotNull Function<String, T> valueOfFunction) {
        this(key, null, (Enum)defaultValue, (Enum[])enumValues, valueOfFunction);
    }

    public EnumConfigValue(@NotNull String key, @Nullable String comment, @NotNull T defaultValue, @NotNull @NotNull T @NotNull [] enumValues, @NotNull Function<String, T> valueOfFunction) {
        this(key, comment, (Enum)defaultValue, null, (Enum[])enumValues, valueOfFunction);
    }

    public EnumConfigValue(@NotNull String key, @Nullable String comment, @NotNull T defaultValue, @Nullable ValueValidator<T> customValidator, @NotNull @NotNull T @NotNull [] enumValues, @NotNull Function<String, T> valueOfFunction) {
        super(key, comment, defaultValue, customValidator);
        this.ENUM_VALUES = new ArrayList<T>(Arrays.asList(enumValues));
        this.VALUE_OF_FUNCTION = valueOfFunction;
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        commentLines.add("Value must be one of " + this.ENUM_VALUES);
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    @NotNull
    protected T readInternal(@NotNull String rawValue) throws ConfigValidationException {
        if (this.ENUM_VALUES.stream().noneMatch(enumValue -> enumValue.name().equals(rawValue))) {
            throw new ConfigValidationException("Value must be one of " + this.ENUM_VALUES);
        }
        try {
            return (T)((Enum)this.VALUE_OF_FUNCTION.apply(rawValue));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigValidationException("Invalid value: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull T value) {
        return "" + value;
    }
}

