/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class FluidStack {
    private FluidVariant fluidVariant;
    private long dropletsAmount;

    public static FluidStack fromNbt(class_2487 nbtCompound) {
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(nbtCompound.method_10558("FluidName")));
        long milliBucketsAmount = nbtCompound.method_10537("Amount");
        long dropletsLeftOverAmount = nbtCompound.method_10545("LeftoverDropletsAmount") ? nbtCompound.method_10537("LeftoverDropletsAmount") : 0L;
        long dropletsAmount = FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount) + dropletsLeftOverAmount;
        class_2487 fluidNbt = nbtCompound.method_10545("Tag") ? nbtCompound.method_10562("Tag") : null;
        return new FluidStack(fluid, fluidNbt, dropletsAmount);
    }

    public static FluidStack fromPacket(class_2540 buf) {
        return new FluidStack(FluidVariant.fromPacket((class_2540)buf), buf.readLong());
    }

    public FluidStack(class_3611 fluid, long dropletsAmount) {
        this(fluid, null, dropletsAmount);
    }

    public FluidStack(class_3611 fluid, class_2487 fluidNbt, long dropletsAmount) {
        this(FluidVariant.of((class_3611)fluid, (class_2487)fluidNbt), dropletsAmount);
    }

    public FluidStack(FluidVariant fluidVariant, long dropletsAmount) {
        this.fluidVariant = fluidVariant;
        this.dropletsAmount = dropletsAmount;
    }

    public FluidVariant getFluidVariant() {
        return this.fluidVariant;
    }

    public void setFluidVariant(FluidVariant fluidVariant) {
        this.fluidVariant = fluidVariant;
    }

    public long getDropletsAmount() {
        return this.dropletsAmount;
    }

    public void setDropletsAmount(long dropletsAmount) {
        this.dropletsAmount = dropletsAmount;
    }

    public long getMilliBucketsAmount() {
        return FluidUtils.convertDropletsToMilliBuckets(this.dropletsAmount);
    }

    public boolean isEmpty() {
        return this.fluidVariant.isBlank();
    }

    public class_3611 getFluid() {
        return this.fluidVariant.getFluid();
    }

    public String getTranslationKey() {
        return this.fluidVariant.getFluid().method_15785().method_15759().method_26204().method_9539();
    }

    public class_2487 toNBT(class_2487 nbtCompound) {
        nbtCompound.method_10582("FluidName", class_7923.field_41173.method_10221((Object)this.fluidVariant.getFluid()).toString());
        long milliBucketsAmount = FluidUtils.convertDropletsToMilliBuckets(this.dropletsAmount);
        long dropletsLeftOverAmount = this.dropletsAmount - FluidUtils.convertMilliBucketsToDroplets(milliBucketsAmount);
        nbtCompound.method_10544("Amount", milliBucketsAmount);
        if (dropletsLeftOverAmount > 0L) {
            nbtCompound.method_10544("LeftoverDropletsAmount", dropletsLeftOverAmount);
        }
        if (this.fluidVariant.getNbt() != null) {
            nbtCompound.method_10566("Tag", (class_2520)this.fluidVariant.getNbt().method_10553());
        }
        return nbtCompound;
    }

    public void toPacket(class_2540 buf) {
        this.fluidVariant.toPacket(buf);
        buf.method_52974(this.dropletsAmount);
    }
}

