/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.screen.InventoryChargerMenu;
import me.jddev0.ep.util.EnergyUtils;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class InventoryChargerItem
extends class_1792
implements class_3908 {
    public static final int SLOT_COUNT = ModConfigs.COMMON_INVENTORY_CHARGER_SLOT_COUNT.getValue();
    public static final boolean TRANSFER_RATE_LIMIT_ENABLED = ModConfigs.COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT_ENABLED.getValue();
    public static final long TRANSFER_RATE_LIMIT = ModConfigs.COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT.getValue();

    public InventoryChargerItem(FabricItemSettings props) {
        super((class_1792.class_1793)props);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (hand == class_1268.field_5810) {
            return class_1271.method_22430((Object)itemStack);
        }
        if (level.method_8608()) {
            return class_1271.method_22427((Object)itemStack);
        }
        player.method_17355((class_3908)this);
        return class_1271.method_22427((Object)itemStack);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.energizedpower.inventory_charger");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new InventoryChargerMenu(id, inventory, (class_1263)InventoryChargerItem.getInventory(inventory.method_5438(inventory.field_7545)));
    }

    public boolean method_31567(class_1799 stack) {
        class_1277 inventory = InventoryChargerItem.getInventory(stack);
        return InventoryChargerItem.getCapacity((class_1263)inventory) > 0L;
    }

    public int method_31569(class_1799 stack) {
        class_1277 inventory = InventoryChargerItem.getInventory(stack);
        return Math.round((float)InventoryChargerItem.getEnergy((class_1263)inventory) * 13.0f / (float)InventoryChargerItem.getCapacity((class_1263)inventory));
    }

    public int method_31571(class_1799 stack) {
        class_1277 inventory = InventoryChargerItem.getInventory(stack);
        float f = Math.max(0.0f, (float)InventoryChargerItem.getEnergy((class_1263)inventory) / (float)InventoryChargerItem.getCapacity((class_1263)inventory));
        return class_3532.method_15369((float)(f * 0.33f), (float)1.0f, (float)1.0f);
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 context) {
        class_1277 inventory = InventoryChargerItem.getInventory(itemStack);
        long energy = InventoryChargerItem.getEnergy((class_1263)inventory);
        long capacity = InventoryChargerItem.getCapacity((class_1263)inventory);
        long maxTransfer = InventoryChargerItem.getMaxTransfer((class_1263)inventory, null);
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energy), EnergyUtils.getEnergyWithPrefix(capacity)}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(maxTransfer)}).method_27692(class_124.field_1080));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.inventory_charger.txt.shift.1").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.energizedpower.shift_details.txt").method_27692(class_124.field_1054));
        }
    }

    private void distributeEnergy(class_1799 itemStack, class_1937 level, class_1661 inventory, int slot, boolean selected) {
        class_1277 inventoryChargerInventory = InventoryChargerItem.getInventory(itemStack);
        LinkedList<EnergyStorage> consumerItems = new LinkedList<EnergyStorage>();
        LinkedList<Long> consumerEnergyValues = new LinkedList<Long>();
        long consumptionSum = 0L;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            EnergyStorage energyStorage;
            class_1799 testItemStack;
            if (i == slot || !EnergyStorageUtil.isEnergyStorage((class_1799)(testItemStack = inventory.method_5438(i))) || (energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(testItemStack, (Object)ContainerItemContext.ofPlayerSlot((class_1657)inventory.field_7546, (SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(i))))) == null || !energyStorage.supportsInsertion()) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long received = energyStorage.insert(InventoryChargerItem.getMaxTransfer((class_1263)inventoryChargerInventory, transaction), (TransactionContext)transaction);
                if (received <= 0L) continue;
                consumptionSum += received;
                consumerItems.add(energyStorage);
                consumerEnergyValues.add(received);
                continue;
            }
        }
        LinkedList<Long> consumerEnergyDistributed = new LinkedList<Long>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0L);
        }
        long consumptionLeft = Math.min(InventoryChargerItem.getMaxTransfer((class_1263)inventoryChargerInventory, null), consumptionSum);
        this.extractEnergyFromBatteries(consumptionLeft, (class_1263)inventoryChargerInventory);
        int divisor = consumerItems.size();
        block13: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                long consumptionDistributed = (Long)consumerEnergyDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)consumerEnergyValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block13;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            long energy = (Long)consumerEnergyDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)consumerItems.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    public void extractEnergyFromBatteries(long energyProductionLeft, class_1263 inventory) {
        LinkedList<EnergyStorage> energyProduction = new LinkedList<EnergyStorage>();
        LinkedList<Long> energyProductionValues = new LinkedList<Long>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(i))));
            if (energyStorage == null) continue;
            try (Transaction transaction = Transaction.openOuter();){
                long extracted = energyStorage.extract(energyStorage.getCapacity(), (TransactionContext)transaction);
                if (extracted <= 0L) continue;
                energyProduction.add(energyStorage);
                energyProductionValues.add(extracted);
                continue;
            }
        }
        LinkedList<Long> energyProductionDistributed = new LinkedList<Long>();
        for (int i = 0; i < energyProduction.size(); ++i) {
            energyProductionDistributed.add(0L);
        }
        long productionLeft = energyProductionLeft;
        int divisor = energyProduction.size();
        block13: while (productionLeft > 0L) {
            long productionPerProducer = productionLeft / (long)divisor;
            if (productionPerProducer == 0L) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / (long)divisor;
            }
            for (int i = 0; i < energyProductionValues.size(); ++i) {
                long productionDistributed = (Long)energyProductionDistributed.get(i);
                long productionOfProducerLeft = (Long)energyProductionValues.get(i) - productionDistributed;
                long productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                energyProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0L) break block13;
            }
        }
        for (int i = 0; i < energyProduction.size(); ++i) {
            long energy = (Long)energyProductionDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)energyProduction.get(i)).extract(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        super.method_7888(itemStack, level, entity, slot, selected);
        if (level.method_8608()) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        if (player.field_7512 instanceof InventoryChargerMenu) {
            return;
        }
        this.distributeEnergy(itemStack, level, inventory, slot, selected);
    }

    public static class_1277 getInventory(final class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7948();
        if (nbt.method_10545("inventory")) {
            class_2371 items = class_2371.method_10213((int)SLOT_COUNT, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)nbt.method_10562("inventory"), (class_2371)items);
            return new class_1277((class_1799[])items.toArray((Object[])new class_1799[0])){

                public void method_5431() {
                    super.method_5431();
                    itemStack.method_7948().method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.field_5828));
                }

                public boolean method_5437(int slot, @NotNull class_1799 stack) {
                    if (slot >= 0 && slot < this.method_5439()) {
                        if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                            return false;
                        }
                        EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                        if (energyStorage == null) {
                            return false;
                        }
                        return energyStorage.supportsExtraction();
                    }
                    return super.method_5437(slot, stack);
                }

                public boolean method_5443(class_1657 player) {
                    return super.method_5443(player) && player.method_31548().method_5438(player.method_31548().field_7545) == itemStack;
                }

                public int method_5444() {
                    return 1;
                }
            };
        }
        return new class_1277(SLOT_COUNT){

            public void method_5431() {
                super.method_5431();
                itemStack.method_7948().method_10566("inventory", (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)this.field_5828));
            }

            public boolean method_5437(int slot, @NotNull class_1799 stack) {
                if (slot >= 0 && slot < this.method_5439()) {
                    if (!EnergyStorageUtil.isEnergyStorage((class_1799)stack)) {
                        return false;
                    }
                    EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
                    if (energyStorage == null) {
                        return false;
                    }
                    return energyStorage.supportsExtraction();
                }
                return super.method_5437(slot, stack);
            }

            public boolean method_5443(class_1657 player) {
                return super.method_5443(player) && player.method_31548().method_5438(player.method_31548().field_7545) == itemStack;
            }

            public int method_5444() {
                return 1;
            }
        };
    }

    public static long getEnergy(class_1263 inventory) {
        long energySum = 0L;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
            if (energyStorage == null) continue;
            long value = energyStorage.getAmount();
            if (Math.max(0L, energySum) + Math.max(0L, value) < 0L) {
                return Long.MAX_VALUE;
            }
            energySum += value;
        }
        return energySum;
    }

    public static long getCapacity(class_1263 inventory) {
        long capacitySum = 0L;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
            if (energyStorage == null) continue;
            long value = energyStorage.getCapacity();
            if (Math.max(0L, capacitySum) + Math.max(0L, value) < 0L) {
                return Long.MAX_VALUE;
            }
            capacitySum += value;
        }
        return capacitySum;
    }

    public static long getMaxTransfer(class_1263 inventory, @Nullable Transaction outerTransaction) {
        long maxTransferSum = 0L;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            long value;
            class_1799 stack = inventory.method_5438(i);
            EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(i))));
            if (energyStorage == null) continue;
            try (Transaction transaction = Transaction.openNested((TransactionContext)outerTransaction);){
                value = energyStorage.extract(energyStorage.getCapacity(), (TransactionContext)transaction);
            }
            if (Math.max(0L, maxTransferSum) + Math.max(0L, value) < 0L) {
                return Long.MAX_VALUE;
            }
            maxTransferSum += value;
        }
        if (TRANSFER_RATE_LIMIT_ENABLED) {
            return Math.min(maxTransferSum, TRANSFER_RATE_LIMIT);
        }
        return maxTransferSum;
    }
}

