/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5699;

public class AssemblingMachineRecipe
implements class_1860<class_1277> {
    private final class_1799 output;
    private final IngredientWithCount[] inputs;

    public AssemblingMachineRecipe(class_1799 output, IngredientWithCount[] inputs) {
        this.output = output;
        this.inputs = inputs;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public boolean matches(class_1277 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        boolean[] usedIndices = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            usedIndices[i] = container.method_5438(i).method_7960();
        }
        int len = Math.min(this.inputs.length, 4);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                if (usedIndices[j]) continue;
                class_1799 item = container.method_5438(j);
                if (indexMinCount != -1 && item.method_7947() >= minCount || !input.input.method_8093(item) || item.method_7947() < input.count) continue;
                indexMinCount = j;
                minCount = item.method_7947();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public class_1799 craft(class_1277 container, class_5455 registryManage) {
        return this.output;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output.method_7972();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.ASSEMBLING_MACHINE_ITEM);
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public record IngredientWithCount(class_1856 input, int count) {
        public static final Codec<IngredientWithCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1856.field_46096.fieldOf("input").forGetter(input -> input.input), (App)class_5699.field_33442.optionalFieldOf("count", (Object)1).forGetter(input -> input.count)).apply((Applicative)instance, IngredientWithCount::new));
    }

    public static final class Serializer
    implements class_1865<AssemblingMachineRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = new class_2960("energizedpower", "assembling_machine");
        private final Codec<AssemblingMachineRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)new ArrayCodec<IngredientWithCount>(IngredientWithCount.CODEC, IngredientWithCount[]::new).fieldOf("inputs").forGetter(recipe -> recipe.inputs)).apply((Applicative)instance, AssemblingMachineRecipe::new));

        private Serializer() {
        }

        public Codec<AssemblingMachineRecipe> method_53736() {
            return this.CODEC;
        }

        public AssemblingMachineRecipe read(class_2540 buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                class_1856 input = class_1856.method_8086((class_2540)buffer);
                int count = buffer.readInt();
                inputs[i] = new IngredientWithCount(input, count);
            }
            class_1799 output = buffer.method_10819();
            return new AssemblingMachineRecipe(output, inputs);
        }

        public void write(class_2540 buffer, AssemblingMachineRecipe recipe) {
            buffer.method_53002(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                recipe.inputs[i].input.method_8088(buffer);
                buffer.method_53002(recipe.inputs[i].count);
            }
            buffer.method_10793(recipe.output);
        }
    }

    public static final class Type
    implements class_3956<AssemblingMachineRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "assembling_machine";

        private Type() {
        }
    }
}

