/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class PulverizerRecipe
implements class_1860<class_1277> {
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final class_1856 input;

    public PulverizerRecipe(OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, class_1856 input) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public class_1799[] getMaxOutputCounts(boolean advanced) {
        class_1799[] generatedOutputs = new class_1799[]{this.output.output.method_46651(advanced ? this.output.percentagesAdvanced.length : this.output.percentages.length), this.secondaryOutput.output.method_46651(advanced ? this.secondaryOutput.percentagesAdvanced.length : this.secondaryOutput.percentages.length)};
        return generatedOutputs;
    }

    public class_1799[] generateOutputs(class_5819 randomSource, boolean advanced) {
        class_1799[] generatedOutputs = new class_1799[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : advanced ? output.percentagesAdvanced : output.percentages) {
                if (!(randomSource.method_43058() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.method_46651(count);
        }
        return generatedOutputs;
    }

    public boolean matches(class_1277 container, class_1937 level) {
        if (level.method_8608()) {
            return false;
        }
        return this.input.method_8093(container.method_5438(0));
    }

    public class_1799 craft(class_1277 container, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_37434((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.PULVERIZER_ITEM);
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(class_1799 output, double[] percentages, double[] percentagesAdvanced) {
        private static Codec<double[]> createDoubleArrayCodec(final boolean atLeastOnePercentageValue) {
            return new Codec<double[]>(){
                private static final Codec<List<Double>> DOUBLE_LIST_CODEC = Codec.doubleRange((double)0.0, (double)1.0).listOf();

                public <T> DataResult<Pair<double[], T>> decode(DynamicOps<T> ops, T input) {
                    return DOUBLE_LIST_CODEC.decode(ops, input).flatMap(res -> {
                        boolean errorFlag = atLeastOnePercentageValue && ((List)res.getFirst()).stream().noneMatch(d -> (int)d.doubleValue() >= 1);
                        Pair newRes = Pair.of((Object)((List)res.getFirst()).stream().mapToDouble(Double::doubleValue).toArray(), (Object)res.getSecond());
                        if (errorFlag) {
                            return DataResult.error(() -> "The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)", (Object)newRes);
                        }
                        return DataResult.success((Object)newRes);
                    });
                }

                public <T> DataResult<T> encode(double[] input, DynamicOps<T> ops, T prefix) {
                    return DOUBLE_LIST_CODEC.encode(Arrays.stream(input).boxed().toList(), ops, prefix);
                }
            };
        }

        public static Codec<OutputItemStackWithPercentages> createCodec(boolean atLeastOnePercentageValue) {
            return RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(output -> output.output), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).fieldOf("percentages").forGetter(output -> output.percentages), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).optionalFieldOf("percentagesAdvanced").forGetter(output -> Optional.of(output.percentages))).apply((Applicative)instance, (output, percentages, percentagesAdvanced) -> {
                if (percentagesAdvanced.isPresent()) {
                    return new OutputItemStackWithPercentages((class_1799)output, (double[])percentages, (double[])percentagesAdvanced.get());
                }
                return new OutputItemStackWithPercentages((class_1799)output, (double[])percentages, (double[])percentages);
            }));
        }
    }

    public static final class Serializer
    implements class_1865<PulverizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 ID = new class_2960("energizedpower", "pulverizer");
        private final Codec<PulverizerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OutputItemStackWithPercentages.createCodec(true).fieldOf("output").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.createCodec(false).optionalFieldOf("secondaryOutput", (Object)new OutputItemStackWithPercentages(class_1799.field_8037, new double[0], new double[0])).forGetter(recipe -> recipe.secondaryOutput), (App)class_1856.field_46096.fieldOf("ingredient").forGetter(recipe -> recipe.input)).apply((Applicative)instance, PulverizerRecipe::new));

        private Serializer() {
        }

        public Codec<PulverizerRecipe> method_53736() {
            return this.CODEC;
        }

        public PulverizerRecipe read(class_2540 buffer) {
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                class_1799 output = buffer.method_10819();
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                int percentageAdvancedCount = buffer.readInt();
                double[] percentagesAdvanced = new double[percentageAdvancedCount];
                for (int j = 0; j < percentageAdvancedCount; ++j) {
                    percentagesAdvanced[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
            }
            return new PulverizerRecipe(outputs[0], outputs[1], input);
        }

        public void write(class_2540 buffer, PulverizerRecipe recipe) {
            recipe.input.method_8088(buffer);
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                buffer.method_10793(output.output);
                buffer.method_53002(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.method_52940(percentage);
                }
                buffer.method_53002(output.percentagesAdvanced.length);
                for (double percentage : output.percentagesAdvanced) {
                    buffer.method_52940(percentage);
                }
            }
        }
    }

    public static final class Type
    implements class_3956<PulverizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pulverizer";

        private Type() {
        }
    }
}

