/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.AbstractGenericEnergyStorageHandledScreen;
import me.jddev0.ep.screen.AdvancedPulverizerMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class AdvancedPulverizerScreen
extends AbstractGenericEnergyStorageHandledScreen<AdvancedPulverizerMenu> {
    private final class_2960 CONFIGURATION_ICONS_TEXTURE = new class_2960("energizedpower", "textures/gui/machine_configuration/configuration_buttons.png");

    public AdvancedPulverizerScreen(AdvancedPulverizerMenu menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", new class_2960("energizedpower", "textures/gui/container/advanced_pulverizer.png"), 8, 17);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.method_2378(-22, 2, 20, 20, mouseX, mouseY)) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(((AdvancedPulverizerMenu)this.field_2797).getBlockEntity().method_11016());
                ClientPlayNetworking.send((class_2960)ModMessages.CHANGE_REDSTONE_MODE_ID, (class_2540)buf);
                clicked = true;
            } else if (this.method_2378(-22, 26, 20, 20, mouseX, mouseY)) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(((AdvancedPulverizerMenu)this.field_2797).getBlockEntity().method_11016());
                ClientPlayNetworking.send((class_2960)ModMessages.CHANGE_COMPARATOR_MODE_ID, (class_2540)buf);
                clicked = true;
            }
            if (clicked) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void method_2389(class_332 drawContext, float partialTick, int mouseX, int mouseY) {
        super.method_2389(drawContext, partialTick, mouseX, mouseY);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(i, drawContext, x, y);
            this.renderFluidMeterOverlay(i, drawContext, x, y);
        }
        this.renderProgressArrow(drawContext, x, y);
        this.renderConfiguration(drawContext, x, y, mouseX, mouseY);
    }

    private void renderFluidMeterContent(int tank, class_332 drawContext, int x, int y) {
        RenderSystem.enableBlend();
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)(x + (tank == 0 ? 44 : 152)), (float)(y + 17), 0.0f);
        this.renderFluidStack(tank, drawContext);
        drawContext.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderFluidStack(int tank, class_332 drawContext) {
        FluidStack fluidStack = ((AdvancedPulverizerMenu)this.field_2797).getFluid(tank);
        if (fluidStack.isEmpty()) {
            return;
        }
        long capacity = ((AdvancedPulverizerMenu)this.field_2797).getTankCapacity(tank);
        class_3611 fluid = fluidStack.getFluid();
        class_1058 stillFluidSprite = FluidVariantRendering.getSprite((FluidVariant)fluidStack.getFluidVariant());
        if (stillFluidSprite == null) {
            stillFluidSprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
        int fluidColorTint = FluidVariantRendering.getColor((FluidVariant)fluidStack.getFluidVariant());
        int fluidMeterPos = 52 - (int)(fluidStack.getDropletsAmount() <= 0L || capacity == 0L ? 0L : Math.min(fluidStack.getDropletsAmount(), capacity - 1L) * 52L / capacity + 1L);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)((float)(fluidColorTint >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColorTint & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 24 & 0xFF) / 255.0f));
        Matrix4f mat = drawContext.method_51448().method_23760().method_23761();
        for (int yOffset = 52; yOffset > fluidMeterPos; yOffset -= 16) {
            int height = Math.min(yOffset - fluidMeterPos, 16);
            float u0 = stillFluidSprite.method_4594();
            float u1 = stillFluidSprite.method_4577();
            float v0 = stillFluidSprite.method_4593();
            float v1 = stillFluidSprite.method_4575();
            v0 -= (float)(16 - height) / 16.0f * (v0 - v1);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(mat, 0.0f, (float)yOffset, 0.0f).method_22913(u0, v1).method_1344();
            bufferBuilder.method_22918(mat, 16.0f, (float)yOffset, 0.0f).method_22913(u1, v1).method_1344();
            bufferBuilder.method_22918(mat, 16.0f, (float)(yOffset - height), 0.0f).method_22913(u1, v0).method_1344();
            bufferBuilder.method_22918(mat, 0.0f, (float)(yOffset - height), 0.0f).method_22913(u0, v0).method_1344();
            tesselator.method_1350();
        }
    }

    private void renderFluidMeterOverlay(int tank, class_332 drawContext, int x, int y) {
        drawContext.method_25302(this.TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 176, 53, 16, 52);
    }

    private void renderProgressArrow(class_332 drawContext, int x, int y) {
        if (((AdvancedPulverizerMenu)this.field_2797).isCraftingActive()) {
            drawContext.method_25302(this.TEXTURE, x + 90, y + 34, 176, 106, ((AdvancedPulverizerMenu)this.field_2797).getScaledProgressArrowSize(), 17);
        }
    }

    private void renderConfiguration(class_332 drawContext, int x, int y, int mouseX, int mouseY) {
        RedstoneMode redstoneMode = ((AdvancedPulverizerMenu)this.field_2797).getRedstoneMode();
        int ordinal = redstoneMode.ordinal();
        if (this.method_2378(-22, 2, 20, 20, mouseX, mouseY)) {
            drawContext.method_25302(this.CONFIGURATION_ICONS_TEXTURE, x - 22, y + 2, 20 * ordinal, 20, 20, 20);
        } else {
            drawContext.method_25302(this.CONFIGURATION_ICONS_TEXTURE, x - 22, y + 2, 20 * ordinal, 0, 20, 20);
        }
        ComparatorMode comparatorMode = ((AdvancedPulverizerMenu)this.field_2797).getComparatorMode();
        ordinal = comparatorMode.ordinal();
        if (this.method_2378(-22, 26, 20, 20, mouseX, mouseY)) {
            drawContext.method_25302(this.CONFIGURATION_ICONS_TEXTURE, x - 22, y + 26, 20 * ordinal, 60, 20, 20);
        } else {
            drawContext.method_25302(this.CONFIGURATION_ICONS_TEXTURE, x - 22, y + 26, 20 * ordinal, 40, 20, 20);
        }
    }

    @Override
    protected void method_2380(class_332 drawContext, int mouseX, int mouseY) {
        ArrayList<class_5250> components;
        super.method_2380(drawContext, mouseX, mouseY);
        for (int i = 0; i < 2; ++i) {
            if (!this.method_2378(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            components = new ArrayList<class_5250>(2);
            boolean fluidEmpty = ((AdvancedPulverizerMenu)this.field_2797).getFluid(i).isEmpty();
            long fluidAmount = fluidEmpty ? 0L : ((AdvancedPulverizerMenu)this.field_2797).getFluid(i).getMilliBucketsAmount();
            class_5250 tooltipComponent = class_2561.method_43469((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(((AdvancedPulverizerMenu)this.field_2797).getTankCapacity(i)))});
            if (!fluidEmpty) {
                tooltipComponent = class_2561.method_43471((String)((AdvancedPulverizerMenu)this.field_2797).getFluid(i).getTranslationKey()).method_27693(" ").method_10852((class_2561)tooltipComponent);
            }
            components.add(tooltipComponent);
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.method_2378(-22, 2, 20, 20, mouseX, mouseY)) {
            RedstoneMode redstoneMode = ((AdvancedPulverizerMenu)this.field_2797).getRedstoneMode();
            components = new ArrayList(2);
            components.add(class_2561.method_43471((String)("tooltip.energizedpower.machine_configuration.redstone_mode." + redstoneMode.method_15434())));
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        } else if (this.method_2378(-22, 26, 20, 20, mouseX, mouseY)) {
            ComparatorMode comparatorMode = ((AdvancedPulverizerMenu)this.field_2797).getComparatorMode();
            components = new ArrayList(2);
            components.add(class_2561.method_43471((String)("tooltip.energizedpower.machine_configuration.comparator_mode." + comparatorMode.method_15434())));
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

