/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.screen.DrainMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class DrainScreen
extends class_465<DrainMenu> {
    private final class_2960 TEXTURE = new class_2960("energizedpower", "textures/gui/container/generic_fluid.png");

    public DrainScreen(DrainMenu menu, class_1661 inventory, class_2561 component) {
        super((class_1703)menu, inventory, component);
    }

    protected void method_2389(class_332 drawContext, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        drawContext.method_25302(this.TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779);
        this.renderFluidMeterContent(drawContext, x, y);
        this.renderFluidMeterOverlay(drawContext, x, y);
    }

    private void renderFluidMeterContent(class_332 drawContext, int x, int y) {
        RenderSystem.enableBlend();
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)(x + 80), (float)(y + 17), 0.0f);
        this.renderFluidStack(drawContext);
        drawContext.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderFluidStack(class_332 drawContext) {
        FluidStack fluidStack = ((DrainMenu)this.field_2797).getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        long capacity = ((DrainMenu)this.field_2797).getTankCapacity();
        class_3611 fluid = fluidStack.getFluid();
        class_1058 stillFluidSprite = FluidVariantRendering.getSprite((FluidVariant)fluidStack.getFluidVariant());
        if (stillFluidSprite == null) {
            stillFluidSprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
        int fluidColorTint = FluidVariantRendering.getColor((FluidVariant)fluidStack.getFluidVariant());
        int fluidMeterPos = 52 - (int)(fluidStack.getDropletsAmount() <= 0L || capacity == 0L ? 0L : Math.min(fluidStack.getDropletsAmount(), capacity - 1L) * 52L / capacity + 1L);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)((float)(fluidColorTint >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColorTint & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 24 & 0xFF) / 255.0f));
        Matrix4f mat = drawContext.method_51448().method_23760().method_23761();
        for (int yOffset = 52; yOffset > fluidMeterPos; yOffset -= 16) {
            int height = Math.min(yOffset - fluidMeterPos, 16);
            float u0 = stillFluidSprite.method_4594();
            float u1 = stillFluidSprite.method_4577();
            float v0 = stillFluidSprite.method_4593();
            float v1 = stillFluidSprite.method_4575();
            v0 -= (float)(16 - height) / 16.0f * (v0 - v1);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(mat, 0.0f, (float)yOffset, 0.0f).method_22913(u0, v1).method_1344();
            bufferBuilder.method_22918(mat, 16.0f, (float)yOffset, 0.0f).method_22913(u1, v1).method_1344();
            bufferBuilder.method_22918(mat, 16.0f, (float)(yOffset - height), 0.0f).method_22913(u1, v0).method_1344();
            bufferBuilder.method_22918(mat, 0.0f, (float)(yOffset - height), 0.0f).method_22913(u0, v0).method_1344();
            tesselator.method_1350();
        }
    }

    private void renderFluidMeterOverlay(class_332 drawContext, int x, int y) {
        drawContext.method_25302(this.TEXTURE, x + 80, y + 17, 176, 0, 16, 52);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        this.method_2380(drawContext, mouseX, mouseY);
    }

    protected void method_2380(class_332 drawContext, int mouseX, int mouseY) {
        super.method_2380(drawContext, mouseX, mouseY);
        if (this.method_2378(80, 17, 16, 52, mouseX, mouseY)) {
            ArrayList<class_5250> components = new ArrayList<class_5250>(2);
            boolean fluidEmpty = ((DrainMenu)this.field_2797).getFluid().isEmpty();
            long fluidAmount = fluidEmpty ? 0L : ((DrainMenu)this.field_2797).getFluid().getMilliBucketsAmount();
            class_5250 tooltipComponent = class_2561.method_43469((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(((DrainMenu)this.field_2797).getTankCapacity()))});
            if (!fluidEmpty) {
                tooltipComponent = class_2561.method_43471((String)((DrainMenu)this.field_2797).getFluid().getTranslationKey()).method_27693(" ").method_10852((class_2561)tooltipComponent);
            }
            components.add(tooltipComponent);
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

