/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.screen.FluidTankMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class FluidTankScreen
extends class_465<FluidTankMenu> {
    private final class_2960 TEXTURE = new class_2960("energizedpower", "textures/gui/container/fluid_tank.png");

    public FluidTankScreen(FluidTankMenu menu, class_1661 inventory, class_2561 component) {
        super((class_1703)menu, inventory, component);
    }

    public FluidTankBlock.Tier getTier() {
        return ((FluidTankMenu)this.field_2797).getTier();
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.method_2378(158, 16, 11, 11, mouseX, mouseY)) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(((FluidTankMenu)this.field_2797).getBlockEntity().method_11016());
                buf.method_53002(0);
                buf.method_52964(!((FluidTankMenu)this.field_2797).isIgnoreNBT());
                ClientPlayNetworking.send((class_2960)ModMessages.SET_CHECKBOX_ID, (class_2540)buf);
                clicked = true;
            }
            if (this.method_2378(151, 34, 18, 18, mouseX, mouseY)) {
                Iterator iterator;
                FluidVariant fluidFilterVariant = FluidVariant.blank();
                class_1799 carriedItemStack = ((FluidTankMenu)this.field_2797).method_34255();
                Storage fluidStorage = (Storage)FluidStorage.ITEM.find(carriedItemStack, (Object)ContainerItemContext.withConstant((class_1799)carriedItemStack));
                if (fluidStorage != null && (iterator = fluidStorage.iterator()).hasNext()) {
                    StorageView fluidView = (StorageView)iterator.next();
                    fluidFilterVariant = (FluidVariant)fluidView.getResource();
                }
                FluidStack fluidFilter = new FluidStack(fluidFilterVariant, 1L);
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(((FluidTankMenu)this.field_2797).getBlockEntity().method_11016());
                fluidFilter.toPacket(buf);
                ClientPlayNetworking.send((class_2960)ModMessages.SET_FLUID_TANK_FILTER_ID, (class_2540)buf);
                clicked = true;
            }
            if (clicked) {
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    protected void method_2389(class_332 drawContext, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        drawContext.method_25302(this.TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779);
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(drawContext, x, y, i);
            this.renderFluidMeterOverlay(drawContext, x, y, i);
        }
        this.renderCheckboxes(drawContext, x, y, mouseX, mouseY);
    }

    private void renderFluidMeterContent(class_332 drawContext, int x, int y, int tank) {
        RenderSystem.enableBlend();
        drawContext.method_51448().method_22903();
        if (tank == 0) {
            drawContext.method_51448().method_46416((float)(x + 80), (float)(y + 17), 0.0f);
        } else if (tank == 1) {
            drawContext.method_51448().method_46416((float)(x + 152), (float)(y + 19), 0.0f);
        }
        this.renderFluidStack(drawContext, tank);
        drawContext.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderFluidStack(class_332 drawContext, int tank) {
        int yOffset;
        FluidStack fluidStack = ((FluidTankMenu)this.field_2797).getFluid(tank);
        if (fluidStack.isEmpty()) {
            return;
        }
        long capacity = ((FluidTankMenu)this.field_2797).getTankCapacity(tank);
        class_3611 fluid = fluidStack.getFluid();
        class_1058 stillFluidSprite = FluidVariantRendering.getSprite((FluidVariant)fluidStack.getFluidVariant());
        if (stillFluidSprite == null) {
            stillFluidSprite = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
        int fluidColorTint = FluidVariantRendering.getColor((FluidVariant)fluidStack.getFluidVariant());
        int fluidMeterPos = switch (tank) {
            case 0 -> 52 - (int)(fluidStack.getDropletsAmount() <= 0L || capacity == 0L ? 0L : Math.min(fluidStack.getDropletsAmount(), capacity - 1L) * 52L / capacity + 1L);
            case 1 -> 16;
            default -> 0;
        };
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)((float)(fluidColorTint >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColorTint & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 24 & 0xFF) / 255.0f));
        Matrix4f mat = drawContext.method_51448().method_23760().method_23761();
        int n = yOffset = tank == 0 ? 52 : 32;
        while (yOffset > fluidMeterPos) {
            int height = Math.min(yOffset - fluidMeterPos, 16);
            float u0 = stillFluidSprite.method_4594();
            float u1 = stillFluidSprite.method_4577();
            float v0 = stillFluidSprite.method_4593();
            float v1 = stillFluidSprite.method_4575();
            v0 -= (float)(16 - height) / 16.0f * (v0 - v1);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(mat, 0.0f, (float)yOffset, 0.0f).method_22913(u0, v1).method_1344();
            bufferBuilder.method_22918(mat, 16.0f, (float)yOffset, 0.0f).method_22913(u1, v1).method_1344();
            bufferBuilder.method_22918(mat, 16.0f, (float)(yOffset - height), 0.0f).method_22913(u1, v0).method_1344();
            bufferBuilder.method_22918(mat, 0.0f, (float)(yOffset - height), 0.0f).method_22913(u0, v0).method_1344();
            tesselator.method_1350();
            yOffset -= 16;
        }
    }

    private void renderFluidMeterOverlay(class_332 drawContext, int x, int y, int tank) {
        if (tank == 0) {
            drawContext.method_25302(this.TEXTURE, x + 80, y + 17, 176, 0, 16, 52);
        } else if (tank == 1) {
            drawContext.method_25302(this.TEXTURE, x + 152, y + 35, 176, 64, 16, 16);
        }
    }

    private void renderCheckboxes(class_332 drawContext, int x, int y, int mouseX, int mouseY) {
        if (((FluidTankMenu)this.field_2797).isIgnoreNBT()) {
            drawContext.method_25302(this.TEXTURE, x + 158, y + 16, 176, 53, 11, 11);
        }
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25394(drawContext, mouseX, mouseY, delta);
        this.method_2380(drawContext, mouseX, mouseY);
    }

    protected void method_2380(class_332 drawContext, int mouseX, int mouseY) {
        ArrayList<class_5250> components;
        super.method_2380(drawContext, mouseX, mouseY);
        if (this.method_2378(80, 17, 16, 52, mouseX, mouseY)) {
            components = new ArrayList<class_5250>(2);
            boolean fluidEmpty = ((FluidTankMenu)this.field_2797).getFluid(0).isEmpty();
            long fluidAmount = fluidEmpty ? 0L : ((FluidTankMenu)this.field_2797).getFluid(0).getMilliBucketsAmount();
            class_5250 tooltipComponent = class_2561.method_43469((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(FluidUtils.convertDropletsToMilliBuckets(((FluidTankMenu)this.field_2797).getTankCapacity(0)))});
            if (!fluidEmpty) {
                tooltipComponent = class_2561.method_43471((String)((FluidTankMenu)this.field_2797).getFluid(0).getTranslationKey()).method_27693(" ").method_10852((class_2561)tooltipComponent);
            }
            components.add(tooltipComponent);
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.method_2378(158, 16, 11, 11, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(class_2561.method_43471((String)"tooltip.energizedpower.fluid_tanks.cbx.ignore_nbt"));
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.method_2378(151, 34, 18, 18, mouseX, mouseY)) {
            components = new ArrayList(2);
            FluidStack fluidFilter = ((FluidTankMenu)this.field_2797).getFluid(1);
            if (fluidFilter.isEmpty()) {
                components.add(class_2561.method_43471((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.no_filter_set"));
            } else {
                components.add(class_2561.method_43469((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.filter_set", (Object[])new Object[]{class_2561.method_43471((String)fluidFilter.getTranslationKey())}));
            }
            components.add(class_2561.method_43473());
            components.add(class_2561.method_43471((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.txt.1").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            components.add(class_2561.method_43471((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.txt.2").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
            drawContext.method_51437(this.field_22793, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

