/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import com.mojang.datafixers.util.Either;
import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;

public final class EitherEndec<L, R>
implements Endec<Either<L, R>> {
    private final Endec<L> leftEndec;
    private final Endec<R> rightEndec;
    private final boolean exclusive;

    public EitherEndec(Endec<L> leftEndec, Endec<R> rightEndec, boolean exclusive) {
        this.leftEndec = leftEndec;
        this.rightEndec = rightEndec;
        this.exclusive = exclusive;
    }

    @Override
    public void encode(Serializer<?> serializer, Either<L, R> either) {
        if (serializer.attributes().contains((Object)SerializationAttribute.SELF_DESCRIBING)) {
            either.ifLeft(left -> this.leftEndec.encode(serializer, left)).ifRight(right -> this.rightEndec.encode(serializer, right));
        } else {
            either.ifLeft(left -> {
                try (Serializer.Struct struct = serializer.struct();){
                    struct.field("is_left", Endec.BOOLEAN, true).field("left", this.leftEndec, left);
                }
            }).ifRight(right -> {
                try (Serializer.Struct struct = serializer.struct();){
                    struct.field("is_left", Endec.BOOLEAN, false).field("right", this.rightEndec, right);
                }
            });
        }
    }

    @Override
    public Either<L, R> decode(Deserializer<?> deserializer) {
        boolean selfDescribing = deserializer.attributes().contains((Object)SerializationAttribute.SELF_DESCRIBING);
        if (selfDescribing) {
            Either leftResult = null;
            try {
                leftResult = Either.left((Object)deserializer.tryRead(this.leftEndec::decode));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.exclusive && leftResult != null) {
                return leftResult;
            }
            Either rightResult = null;
            try {
                rightResult = Either.right((Object)deserializer.tryRead(this.rightEndec::decode));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.exclusive && leftResult != null && rightResult != null) {
                throw new IllegalStateException("Both alternatives read successfully, can not pick the correct one; first: " + leftResult + " second: " + rightResult);
            }
            if (leftResult != null) {
                return leftResult;
            }
            if (rightResult != null) {
                return rightResult;
            }
            throw new IllegalStateException("Neither alternative read successfully");
        }
        Deserializer.Struct struct = deserializer.struct();
        if (struct.field("is_left", Endec.BOOLEAN).booleanValue()) {
            return Either.left(struct.field("left", this.leftEndec));
        }
        return Either.right(struct.field("right", this.rightEndec));
    }
}

