/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import io.wispforest.owo.Owo;
import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.StructEndec;
import io.wispforest.owo.serialization.annotations.NullableComponent;
import io.wispforest.owo.serialization.endec.ReflectiveEndecBuilder;
import io.wispforest.owo.serialization.endec.StructField;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;

public final class RecordEndec<R extends Record>
implements StructEndec<R> {
    private static final Map<Class<?>, RecordEndec<?>> ENDECS = new HashMap();
    private final List<StructField<R, ?>> fields;
    private final Constructor<R> instanceCreator;

    private RecordEndec(Constructor<R> instanceCreator, List<StructField<R, ?>> fields) {
        this.instanceCreator = instanceCreator;
        this.fields = fields;
    }

    public static <R extends Record> RecordEndec<R> create(Class<R> recordClass) {
        if (ENDECS.containsKey(recordClass)) {
            return ENDECS.get(recordClass);
        }
        ArrayList fields = new ArrayList();
        Class[] canonicalConstructorArgs = new Class[recordClass.getRecordComponents().length];
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        for (int i = 0; i < recordClass.getRecordComponents().length; ++i) {
            try {
                RecordComponent component = recordClass.getRecordComponents()[i];
                MethodHandle handle = lookup.unreflect(component.getAccessor());
                Endec<?> endec = ReflectiveEndecBuilder.get(component.getGenericType());
                if (component.isAnnotationPresent(NullableComponent.class)) {
                    endec = endec.nullableOf();
                }
                fields.add(new StructField<Record, Object>(component.getName(), endec, instance -> RecordEndec.getRecordEntry(instance, handle)));
                canonicalConstructorArgs[i] = component.getType();
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create method handle for record component accessor");
            }
        }
        try {
            RecordEndec<R> endec = new RecordEndec<R>(recordClass.getConstructor(canonicalConstructorArgs), fields);
            ENDECS.put(recordClass, endec);
            return endec;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not locate canonical record constructor");
        }
    }

    private static <R extends Record> Object getRecordEntry(R instance, MethodHandle accessor) {
        try {
            return accessor.invoke(instance);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to get record component value", e);
        }
    }

    @Override
    public R decodeStruct(Deserializer.Struct struct) {
        Object[] fieldValues = new Object[this.fields.size()];
        MutableInt index = new MutableInt();
        this.fields.forEach(field -> {
            fieldValues[index.getAndIncrement()] = field.decodeField(struct);
        });
        try {
            return (R)((Record)this.instanceCreator.newInstance(fieldValues));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Owo.LOGGER.error("Error while deserializing record", (Throwable)e);
            return null;
        }
    }

    @Override
    public void encodeStruct(Serializer.Struct struct, R instance) {
        this.fields.forEach(field -> field.encodeField(struct, instance));
    }
}

