/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.annotations.SealedPolymorphic;
import io.wispforest.owo.serialization.endec.BuiltInEndecs;
import io.wispforest.owo.serialization.endec.RecordEndec;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ReflectiveEndecBuilder {
    private static final Map<Class<?>, Endec<?>> CLASS_TO_ENDEC = new HashMap();

    public static <T> void register(Endec<T> endec, Class<T> clazz) {
        if (CLASS_TO_ENDEC.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has an associated endec");
        }
        CLASS_TO_ENDEC.put(clazz, endec);
    }

    @SafeVarargs
    private static <T> void register(Endec<T> endec, Class<T> ... classes) {
        for (Class<T> clazz : classes) {
            ReflectiveEndecBuilder.register(endec, clazz);
        }
    }

    public static Endec<?> get(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return ReflectiveEndecBuilder.get(clazz);
        }
        ParameterizedType parameterized = (ParameterizedType)type;
        Class raw = (Class)parameterized.getRawType();
        Type[] typeArgs = parameterized.getActualTypeArguments();
        if (raw == Map.class) {
            return typeArgs[0] == String.class ? ReflectiveEndecBuilder.get(typeArgs[1]).mapOf() : Endec.map(ReflectiveEndecBuilder.get(typeArgs[0]), ReflectiveEndecBuilder.get(typeArgs[1]));
        }
        if (raw == List.class) {
            return ReflectiveEndecBuilder.get(typeArgs[0]).listOf();
        }
        if (raw == Set.class) {
            return ReflectiveEndecBuilder.get(typeArgs[0]).listOf().xmap(list -> new HashSet(list), set -> List.copyOf(set));
        }
        if (raw == Optional.class) {
            return ReflectiveEndecBuilder.get(typeArgs[0]).optionalOf();
        }
        return ReflectiveEndecBuilder.get(raw);
    }

    public static <T> Endec<T> get(Class<T> clazz) {
        Endec<T> endec = ReflectiveEndecBuilder.getOrNull(clazz);
        if (endec == null) {
            throw new IllegalStateException("No endec available for class '" + clazz.getName() + "'");
        }
        return endec;
    }

    public static <T> Optional<Endec<T>> maybeGet(Class<T> clazz) {
        return Optional.ofNullable(ReflectiveEndecBuilder.getOrNull(clazz));
    }

    @Nullable
    private static <T> Endec<T> getOrNull(Class<T> clazz) {
        Endec<Object> serializer = CLASS_TO_ENDEC.get(clazz);
        if (serializer == null) {
            if (Record.class.isAssignableFrom(clazz)) {
                serializer = RecordEndec.create(clazz);
            } else if (clazz.isEnum()) {
                serializer = Endec.forEnum(clazz);
            } else if (clazz.isArray()) {
                serializer = ReflectiveEndecBuilder.createArrayEndec(clazz.getComponentType());
            } else if (clazz.isAnnotationPresent(io.wispforest.owo.network.serialization.SealedPolymorphic.class) || clazz.isAnnotationPresent(SealedPolymorphic.class)) {
                serializer = ReflectiveEndecBuilder.createSealedSerializer(clazz);
            } else {
                return null;
            }
            CLASS_TO_ENDEC.put(clazz, serializer);
        }
        return serializer;
    }

    private static Endec<?> createArrayEndec(Class<?> elementClass) {
        Endec<?> elementEndec = ReflectiveEndecBuilder.get(elementClass);
        return elementEndec.listOf().xmap(list -> {
            int length = list.size();
            Object array = Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }, t -> {
            int length = Array.getLength(t);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(t, i));
            }
            return list;
        });
    }

    private static Endec<?> createSealedSerializer(Class<?> commonClass) {
        if (!commonClass.isSealed()) {
            throw new IllegalStateException("@SealedPolymorphic class must be sealed");
        }
        List permittedSubclasses = Arrays.stream(commonClass.getPermittedSubclasses()).collect(Collectors.toList());
        for (int i = 0; i < permittedSubclasses.size(); ++i) {
            Class clazz = (Class)permittedSubclasses.get(i);
            if (!clazz.isSealed()) continue;
            for (Class<?> subclass : clazz.getPermittedSubclasses()) {
                if (permittedSubclasses.contains(subclass)) continue;
                permittedSubclasses.add(subclass);
            }
        }
        for (Class clazz : permittedSubclasses) {
            if (clazz.isSealed() || Modifier.isFinal(clazz.getModifiers())) continue;
            throw new IllegalStateException("Subclasses of a @SealedPolymorphic class must themselves be sealed");
        }
        permittedSubclasses.sort(Comparator.comparing(Class::getName));
        Int2ObjectOpenHashMap serializerMap = new Int2ObjectOpenHashMap();
        Reference2IntOpenHashMap classesMap = new Reference2IntOpenHashMap();
        classesMap.defaultReturnValue(-1);
        for (int i = 0; i < permittedSubclasses.size(); ++i) {
            Class klass = (Class)permittedSubclasses.get(i);
            serializerMap.put(i, ReflectiveEndecBuilder.get(klass));
            classesMap.put((Object)klass, i);
        }
        return Endec.dispatched(integer -> (Endec)serializerMap.get(integer.intValue()), instance -> classesMap.getInt(instance.getClass()), Endec.INT);
    }

    static {
        ReflectiveEndecBuilder.register(Endec.BOOLEAN, Boolean.class, Boolean.TYPE);
        ReflectiveEndecBuilder.register(Endec.INT, Integer.class, Integer.TYPE);
        ReflectiveEndecBuilder.register(Endec.LONG, Long.class, Long.TYPE);
        ReflectiveEndecBuilder.register(Endec.FLOAT, Float.class, Float.TYPE);
        ReflectiveEndecBuilder.register(Endec.DOUBLE, Double.class, Double.TYPE);
        ReflectiveEndecBuilder.register(Endec.BYTE, Byte.class, Byte.TYPE);
        ReflectiveEndecBuilder.register(Endec.SHORT, Short.class, Short.TYPE);
        ReflectiveEndecBuilder.register(Endec.SHORT.xmap(aShort -> Character.valueOf((char)aShort.shortValue()), character -> (short)character.charValue()), Character.class, Character.TYPE);
        ReflectiveEndecBuilder.register(Endec.VOID, Void.class);
        ReflectiveEndecBuilder.register(Endec.STRING, String.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.UUID, UUID.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.DATE, Date.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.PACKET_BYTE_BUF, class_2540.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.BLOCK_POS, class_2338.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.CHUNK_POS, class_1923.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.ITEM_STACK, class_1799.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.IDENTIFIER, class_2960.class);
        ReflectiveEndecBuilder.register(NbtEndec.COMPOUND, class_2487.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.BLOCK_HIT_RESULT, class_3965.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.BITSET, BitSet.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.TEXT, class_2561.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.PACKET_BYTE_BUF.xmap(byteBuf -> {
            class_2396 particleType = (class_2396)class_7923.field_41180.method_10200(byteBuf.readInt());
            return particleType.method_10298().method_10297(particleType, byteBuf);
        }, particleEffect -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_53002(class_7923.field_41180.method_10206((Object)particleEffect.method_10295()));
            particleEffect.method_10294(buf);
            return buf;
        }), class_2394.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.VEC3D, class_243.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.VECTOR3F, Vector3f.class);
        ReflectiveEndecBuilder.register(BuiltInEndecs.VEC3I, class_2382.class);
    }
}

