/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.bytebuf;

import io.netty.buffer.ByteBuf;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_8702;
import net.minecraft.class_8703;
import net.minecraft.class_8704;

public class ByteBufSerializer<B extends ByteBuf>
implements Serializer<B> {
    private final B buffer;

    protected ByteBufSerializer(B buffer) {
        this.buffer = buffer;
    }

    public static <B extends ByteBuf> ByteBufSerializer<B> of(B buffer) {
        return new ByteBufSerializer<B>(buffer);
    }

    public static ByteBufSerializer<class_2540> packet() {
        return ByteBufSerializer.of(PacketByteBufs.create());
    }

    @Override
    public Set<SerializationAttribute> attributes() {
        return Set.of();
    }

    @Override
    public void writeByte(byte value) {
        this.buffer.writeByte((int)value);
    }

    @Override
    public void writeShort(short value) {
        this.buffer.writeShort((int)value);
    }

    @Override
    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.writeDouble(value);
    }

    @Override
    public void writeVarInt(int value) {
        class_8703.method_53017(this.buffer, (int)value);
    }

    @Override
    public void writeVarLong(long value) {
        class_8704.method_53021(this.buffer, (long)value);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
    }

    @Override
    public void writeString(String value) {
        class_8702.method_53013(this.buffer, (CharSequence)value, (int)Short.MAX_VALUE);
    }

    @Override
    public void writeBytes(byte[] bytes) {
        this.writeVarInt(bytes.length);
        this.buffer.writeBytes(bytes);
    }

    @Override
    public <V> void writeOptional(Endec<V> endec, Optional<V> optional) {
        this.writeBoolean(optional.isPresent());
        optional.ifPresent(value -> endec.encode(this, value));
    }

    @Override
    public <V> Serializer.Map<V> map(Endec<V> valueEndec, int size) {
        this.writeVarInt(size);
        return new Sequence<V>(valueEndec);
    }

    @Override
    public <E> Serializer.Sequence<E> sequence(Endec<E> elementEndec, int size) {
        this.writeVarInt(size);
        return new Sequence<E>(elementEndec);
    }

    @Override
    public Serializer.Struct struct() {
        return new Sequence(null);
    }

    @Override
    public B result() {
        return this.buffer;
    }

    private class Sequence<V>
    implements Serializer.Sequence<V>,
    Serializer.Struct,
    Serializer.Map<V> {
        private final Endec<V> valueEndec;

        private Sequence(Endec<V> valueEndec) {
            this.valueEndec = valueEndec;
        }

        @Override
        public void element(V element) {
            this.valueEndec.encode(ByteBufSerializer.this, element);
        }

        @Override
        public void entry(String key, V value) {
            ByteBufSerializer.this.writeString(key);
            this.valueEndec.encode(ByteBufSerializer.this, value);
        }

        @Override
        public <F> Serializer.Struct field(String name, Endec<F> endec, F value) {
            endec.encode(ByteBufSerializer.this, value);
            return this;
        }

        @Override
        public void end() {
        }
    }
}

