/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.edm;

import io.wispforest.owo.serialization.format.edm.EdmElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EdmIo {
    public static void encode(DataOutput output, EdmElement<?> data) throws IOException {
        output.writeByte(data.type().ordinal());
        EdmIo.encodeElementData(output, data);
    }

    public static EdmElement<?> decode(DataInput input) throws IOException {
        return EdmIo.decodeElementData(input, input.readByte());
    }

    public static void encodeElementData(DataOutput output, EdmElement<?> data) throws IOException {
        switch (data.type()) {
            case BYTE: {
                output.writeByte(((Byte)data.cast()).byteValue());
                break;
            }
            case SHORT: {
                output.writeShort(((Short)data.cast()).shortValue());
                break;
            }
            case INT: {
                output.writeInt((Integer)data.cast());
                break;
            }
            case LONG: {
                output.writeLong((Long)data.cast());
                break;
            }
            case FLOAT: {
                output.writeFloat(((Float)data.cast()).floatValue());
                break;
            }
            case DOUBLE: {
                output.writeDouble((Double)data.cast());
                break;
            }
            case BOOLEAN: {
                output.writeBoolean((Boolean)data.cast());
                break;
            }
            case STRING: {
                output.writeUTF((String)data.cast());
                break;
            }
            case BYTES: {
                output.writeInt(((byte[])data.cast()).length);
                output.write((byte[])data.cast());
                break;
            }
            case OPTIONAL: {
                Optional optional = (Optional)data.cast();
                output.writeBoolean(optional.isPresent());
                if (!optional.isPresent()) break;
                EdmIo.encodeElementData(output, (EdmElement)optional.get());
                break;
            }
            case SEQUENCE: {
                List list = (List)data.cast();
                output.writeInt(list.size());
                if (list.isEmpty()) break;
                for (EdmElement element : list) {
                    output.writeByte(element.type().ordinal());
                    EdmIo.encodeElementData(output, element);
                }
                break;
            }
            case MAP: {
                Map map = (Map)data.cast();
                output.writeInt(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    output.writeUTF((String)entry.getKey());
                    output.writeByte(((EdmElement)entry.getValue()).type().ordinal());
                    EdmIo.encodeElementData(output, (EdmElement)entry.getValue());
                }
                break;
            }
        }
    }

    private static EdmElement<?> decodeElementData(DataInput input, byte type) throws IOException {
        return switch (EdmElement.Type.values()[type]) {
            default -> throw new IncompatibleClassChangeError();
            case EdmElement.Type.BYTE -> EdmElement.wrapByte(input.readByte());
            case EdmElement.Type.SHORT -> EdmElement.wrapShort(input.readShort());
            case EdmElement.Type.INT -> EdmElement.wrapInt(input.readInt());
            case EdmElement.Type.LONG -> EdmElement.wrapLong(input.readLong());
            case EdmElement.Type.FLOAT -> EdmElement.wrapFloat(input.readFloat());
            case EdmElement.Type.DOUBLE -> EdmElement.wrapDouble(input.readDouble());
            case EdmElement.Type.BOOLEAN -> EdmElement.wrapBoolean(input.readBoolean());
            case EdmElement.Type.STRING -> EdmElement.wrapString(input.readUTF());
            case EdmElement.Type.BYTES -> {
                byte[] result = new byte[input.readInt()];
                input.readFully(result);
                yield EdmElement.wrapBytes(result);
            }
            case EdmElement.Type.OPTIONAL -> {
                if (input.readByte() != 0) {
                    yield EdmElement.wrapOptional(Optional.of(EdmIo.decodeElementData(input, input.readByte())));
                }
                yield EdmElement.wrapOptional(Optional.empty());
            }
            case EdmElement.Type.SEQUENCE -> {
                int length = input.readInt();
                if (length != 0) {
                    ArrayList result = new ArrayList(length);
                    for (int i = 0; i < length; ++i) {
                        result.add(EdmIo.decodeElementData(input, input.readByte()));
                    }
                    yield EdmElement.wrapSequence(result);
                }
                yield EdmElement.wrapSequence(List.of());
            }
            case EdmElement.Type.MAP -> {
                int length = input.readInt();
                HashMap result = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    result.put(input.readUTF(), EdmIo.decodeElementData(input, input.readByte()));
                }
                yield EdmElement.wrapMap(result);
            }
        };
    }
}

