/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.nbt;

import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SelfDescribedDeserializer;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.util.RecursiveDeserializer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class NbtDeserializer
extends RecursiveDeserializer<class_2520>
implements SelfDescribedDeserializer<class_2520> {
    private static final Set<SerializationAttribute> ATTRIBUTES = EnumSet.of(SerializationAttribute.SELF_DESCRIBING);

    protected NbtDeserializer(class_2520 element) {
        super(element);
    }

    public static NbtDeserializer of(class_2520 element) {
        return new NbtDeserializer(element);
    }

    private <N extends class_2520> N getAs(class_2520 element, Class<N> clazz) {
        if (clazz.isInstance(element)) {
            return (N)((class_2520)clazz.cast(element));
        }
        throw new IllegalStateException("Expected a " + clazz.getSimpleName() + ", found a " + element.getClass().getSimpleName());
    }

    @Override
    public Set<SerializationAttribute> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public byte readByte() {
        return this.getAs((class_2520)this.getValue(), class_2481.class).method_10698();
    }

    @Override
    public short readShort() {
        return this.getAs((class_2520)this.getValue(), class_2516.class).method_10696();
    }

    @Override
    public int readInt() {
        return this.getAs((class_2520)this.getValue(), class_2497.class).method_10701();
    }

    @Override
    public long readLong() {
        return this.getAs((class_2520)this.getValue(), class_2503.class).method_10699();
    }

    @Override
    public float readFloat() {
        return this.getAs((class_2520)this.getValue(), class_2494.class).method_10700();
    }

    @Override
    public double readDouble() {
        return this.getAs((class_2520)this.getValue(), class_2489.class).method_10697();
    }

    @Override
    public int readVarInt() {
        return this.getAs((class_2520)this.getValue(), class_2514.class).method_10701();
    }

    @Override
    public long readVarLong() {
        return this.getAs((class_2520)this.getValue(), class_2514.class).method_10699();
    }

    @Override
    public boolean readBoolean() {
        return this.getAs((class_2520)this.getValue(), class_2481.class).method_10698() != 0;
    }

    @Override
    public String readString() {
        return this.getAs((class_2520)this.getValue(), class_2519.class).method_10714();
    }

    @Override
    public byte[] readBytes() {
        return this.getAs((class_2520)this.getValue(), class_2479.class).method_10521();
    }

    @Override
    public <V> Optional<V> readOptional(Endec<V> endec) {
        if (this.isReadingStructField()) {
            return Optional.of(endec.decode(this));
        }
        Deserializer.Struct struct = this.struct();
        return struct.field("present", Endec.BOOLEAN) != false ? Optional.of(struct.field("value", endec)) : Optional.empty();
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(Endec<E> elementEndec) {
        return new Sequence<E>(elementEndec, (List)this.getAs((class_2520)this.getValue(), class_2483.class));
    }

    @Override
    public <V> Deserializer.Map<V> map(Endec<V> valueEndec) {
        return new Map<V>(valueEndec, this.getAs((class_2520)this.getValue(), class_2487.class));
    }

    @Override
    public Deserializer.Struct struct() {
        return new Struct(this.getAs((class_2520)this.getValue(), class_2487.class));
    }

    @Override
    public <S> void readAny(Serializer<S> visitor) {
        this.decodeValue(visitor, (class_2520)this.getValue());
    }

    private <S> void decodeValue(Serializer<S> visitor, class_2520 value) {
        switch (value.method_10711()) {
            case 1: {
                visitor.writeByte(((class_2481)value).method_10698());
                break;
            }
            case 2: {
                visitor.writeShort(((class_2516)value).method_10696());
                break;
            }
            case 3: {
                visitor.writeInt(((class_2497)value).method_10701());
                break;
            }
            case 4: {
                visitor.writeLong(((class_2503)value).method_10699());
                break;
            }
            case 5: {
                visitor.writeFloat(((class_2494)value).method_10700());
                break;
            }
            case 6: {
                visitor.writeDouble(((class_2489)value).method_10697());
                break;
            }
            case 8: {
                visitor.writeString(value.method_10714());
                break;
            }
            case 7: {
                visitor.writeBytes(((class_2479)value).method_10521());
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                class_2483 list = (class_2483)value;
                try (Serializer.Sequence<class_2520> sequence = visitor.sequence(Endec.of(this::decodeValue, deserializer -> null), list.size());){
                    list.forEach(sequence::element);
                    break;
                }
            }
            case 10: {
                class_2487 compound = (class_2487)value;
                try (Serializer.Map<class_2520> map = visitor.map(Endec.of(this::decodeValue, deserializer -> null), compound.method_10546());){
                    for (String key : compound.method_10541()) {
                        map.entry(key, compound.method_10580(key));
                    }
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Non-standard, unrecognized NbtElement implementation cannot be decoded");
            }
        }
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final Endec<V> valueEndec;
        private final Iterator<class_2520> elements;
        private final int size;

        private Sequence(Endec<V> valueEndec, List<class_2520> elements) {
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public V next() {
            return (V)NbtDeserializer.this.frame(this.elements::next, () -> this.valueEndec.decode(NbtDeserializer.this), false);
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final Endec<V> valueEndec;
        private final class_2487 compound;
        private final Iterator<String> keys;
        private final int size;

        private Map(Endec<V> valueEndec, class_2487 compound) {
            this.valueEndec = valueEndec;
            this.compound = compound;
            this.keys = compound.method_10541().iterator();
            this.size = compound.method_10546();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            String key = this.keys.next();
            return (Map.Entry)NbtDeserializer.this.frame(() -> this.compound.method_10580(key), () -> java.util.Map.entry(key, this.valueEndec.decode(NbtDeserializer.this)), false);
        }
    }

    public class Struct
    implements Deserializer.Struct {
        private final class_2487 compound;

        public Struct(class_2487 compound) {
            this.compound = compound;
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec) {
            if (!this.compound.method_10545(name)) {
                throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
            }
            return (F)NbtDeserializer.this.frame(() -> this.compound.method_10580(name), () -> endec.decode(NbtDeserializer.this), true);
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec, @Nullable F defaultValue) {
            if (!this.compound.method_10545(name)) {
                return defaultValue;
            }
            return (F)NbtDeserializer.this.frame(() -> this.compound.method_10580(name), () -> endec.decode(NbtDeserializer.this), true);
        }
    }
}

