/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.util;

import io.wispforest.owo.serialization.Serializer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;

public abstract class RecursiveSerializer<T>
implements Serializer<T> {
    protected final Deque<Frame<T>> frames = new ArrayDeque<Frame<T>>();
    protected T result;

    protected RecursiveSerializer(T initialResult) {
        this.result = initialResult;
        this.frames.push(new Frame<Object>(t -> {
            this.result = t;
        }, false));
    }

    protected void consume(T value) {
        this.frames.peek().sink.accept(value);
    }

    protected boolean isWritingStructField() {
        return this.frames.peek().isStructField;
    }

    protected void frame(FrameAction<T> action, boolean isStructField) {
        EncodedValue encoded = new EncodedValue();
        this.frames.push(new Frame<Object>(encoded::set, isStructField));
        action.accept(encoded);
        this.frames.pop();
    }

    @Override
    public T result() {
        return this.result;
    }

    protected record Frame<T>(Consumer<T> sink, boolean isStructField) {
    }

    protected static class EncodedValue<T> {
        private T value = null;
        private boolean encoded = false;

        protected EncodedValue() {
        }

        private void set(T value) {
            this.value = value;
            this.encoded = true;
        }

        public T get() {
            return this.value;
        }

        public boolean wasEncoded() {
            return this.encoded;
        }

        public T require(String name) {
            if (!this.encoded) {
                throw new IllegalStateException("Endec for " + name + " serialized nothing");
            }
            return this.value;
        }
    }

    @FunctionalInterface
    protected static interface FrameAction<T> {
        public void accept(EncodedValue<T> var1);
    }
}

