/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves;

import blue.endless.scarves.ScarvesBlocks;
import blue.endless.scarves.api.FabricSquare;
import blue.endless.scarves.api.FabricSquareRegistry;
import blue.endless.scarves.ghost.ImplementedGhostInventory;
import blue.endless.scarves.gui.ScarfTableGuiDescription;
import blue.endless.scarves.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3914;

public class ScarfTableBlockEntity
extends class_2586
implements ImplementedInventory,
ImplementedGhostInventory,
class_1275,
class_3908 {
    private class_2561 customName;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private class_2371<class_1799> ghostItems = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    public static final int SLOT_INPUT = 8;
    public static final int SLOT_OUTPUT = 9;

    public ScarfTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ScarvesBlocks.SCARF_TABLE_ENTITY, pos, state);
    }

    public List<FabricSquare> getGhostPattern(int patternLength) {
        ArrayList<FabricSquare> result = new ArrayList<FabricSquare>();
        int count = Math.max(patternLength, this.ghostItems.size());
        for (int i = 0; i < count; ++i) {
            FabricSquare square;
            class_1799 ghostItem = (class_1799)this.ghostItems.get(i);
            if (ghostItem.method_7960() || (square = FabricSquareRegistry.forItem(ghostItem)) == null) continue;
            result.add(square);
        }
        return result;
    }

    public class_2499 getAppliedPattern(int patternLength, int repetitions) {
        List<FabricSquare> pattern = this.getGhostPattern(patternLength);
        if (pattern.isEmpty()) {
            return new class_2499();
        }
        class_2499 list = new class_2499();
        for (int i = 0; i < repetitions; ++i) {
            for (FabricSquare square : pattern) {
                list.add((Object)square.toCompound());
            }
        }
        return list;
    }

    public void applyLeft(int patternLength, int repetitions) {
        class_1799 scarfStack = (class_1799)this.inventory.get(0);
        if (scarfStack.method_7960()) {
            return;
        }
        class_2499 appliedPattern = this.getAppliedPattern(patternLength, repetitions);
        class_2487 tag = scarfStack.method_7948();
        tag.method_10566("LeftScarf", (class_2520)appliedPattern);
        this.method_5447(0, scarfStack);
        this.method_5431();
    }

    public void applyRight(int patternLength, int repetitions) {
        class_1799 scarfStack = (class_1799)this.inventory.get(0);
        if (scarfStack.method_7960()) {
            return;
        }
        class_2499 appliedPattern = this.getAppliedPattern(patternLength, repetitions);
        class_2487 tag = scarfStack.method_7948();
        tag.method_10566("RightScarf", (class_2520)appliedPattern);
        this.method_5447(0, scarfStack);
        this.method_5431();
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public class_2371<class_1799> getGhostItems() {
        return this.ghostItems;
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.readGhostItems(nbt);
        super.method_11014(nbt);
    }

    protected void method_11007(class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.inventory);
        this.writeGhostItems(nbt);
        super.method_11007(nbt);
    }

    public void setCustomName(class_2561 name) {
        this.customName = name;
    }

    public class_2561 method_5477() {
        return this.customName;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ScarfTableGuiDescription(syncId, playerInventory, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }
}

