/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.scarves;

import blue.endless.scarves.ScarfItem;
import blue.endless.scarves.ScarvesBlocks;
import blue.endless.scarves.ScarvesItems;
import blue.endless.scarves.api.ScarvesApi;
import blue.endless.scarves.api.ScarvesIntegration;
import blue.endless.scarves.ghost.GhostInventoryNetworking;
import blue.endless.scarves.integration.StaticDataIntegration;
import io.github.queerbric.pride.PrideFlag;
import io.github.queerbric.pride.PrideFlags;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_1074;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScarvesMod
implements ModInitializer {
    public static final String MODID = "scarves";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Scarves");
    public static final class_2960 GHOST_SLOT_MESSAGE = new class_2960("scarves", "ghost");
    public static class_1761 ITEM_GROUP;
    private static final List<class_1799> creativeScarves;

    public void onInitialize() {
        ITEM_GROUP = FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43470((String)"Scarves")).method_47320(() -> new class_1799((class_1935)ScarvesItems.SCARF)).method_47317((context, entries) -> {
            entries.method_45420(new class_1799((class_1935)ScarvesItems.SCARF));
            entries.method_45420(new class_1799((class_1935)ScarvesItems.SCARF_STAPLER));
            entries.method_45420(new class_1799((class_1935)ScarvesItems.SCARF_TABLE));
            ScarvesMod.addPrideScarves(entries);
            for (class_1799 stack : creativeScarves) {
                entries.method_45420(stack);
            }
        }).method_47324();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960(MODID, "general"), (Object)ITEM_GROUP);
        ScarvesBlocks.register();
        ScarvesItems.register();
        GhostInventoryNetworking.init();
        for (EntrypointContainer entrypoint : FabricLoader.getInstance().getEntrypointContainers(MODID, ScarvesIntegration.class)) {
            try {
                ((ScarvesIntegration)entrypoint.getEntrypoint()).integrateWithScarves(ScarvesApi.instance());
            }
            catch (Throwable t) {
                LOGGER.error("Mod '" + entrypoint.getProvider().getMetadata().getId() + "' threw an exception trying to activate Scarves integration.", t);
            }
        }
        StaticDataIntegration.init();
    }

    public static void addCreativeScarf(class_1799 scarfItem) {
        creativeScarves.add(scarfItem);
    }

    public static void addPrideScarves(class_1761.class_7704 entries) {
        for (PrideFlag flag : PrideFlags.getFlags()) {
            if (flag == null) {
                LOGGER.warn("Null pride flag found!");
                continue;
            }
            int reps = 8 / flag.getColors().size();
            if (reps < 1) {
                reps = 1;
            }
            int flagLength = flag.getColors().size() * reps;
            class_1799 scarf = ScarfItem.createScarf(flag, flagLength, flag, 0);
            String flagKey = "flag.pridelib." + flag.getId();
            class_5250 flagName = class_1074.method_4663((String)flagKey) ? class_2561.method_43471((String)flagKey) : class_2561.method_43470((String)StringUtils.capitalize((String)flag.getId()));
            class_5250 name = class_2561.method_43469((String)"item.scarves.scarf.named", (Object[])new Object[]{flagName});
            scarf = ScarfItem.setName(scarf, (class_2561)name);
            entries.method_45420(scarf);
        }
        PrideFlag biFlag = PrideFlags.getFlag((String)"bisexual");
        PrideFlag panFlag = PrideFlags.getFlag((String)"pansexual");
        if (biFlag != null && panFlag != null) {
            class_1799 biPanScarf = ScarfItem.createScarf(biFlag, 30, panFlag, 15);
            class_5250 biPanName = class_2561.method_43470((String)StringUtils.capitalize((String)"Bi/Pan"));
            class_5250 name = class_2561.method_43469((String)"item.scarves.scarf.named", (Object[])new Object[]{biPanName});
            biPanScarf = ScarfItem.setName(biPanScarf, (class_2561)name);
            entries.method_45420(biPanScarf);
        }
    }

    static {
        creativeScarves = new ArrayList<class_1799>();
    }
}

